/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.midi.playlist;

import io.github.tofodroid.mods.mimi.common.midi.BasicMidiInfo;
import io.github.tofodroid.mods.mimi.server.events.broadcast.producer.transmitter.ServerTransmitterManager;
import io.github.tofodroid.mods.mimi.server.midi.ServerMidiManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;

public abstract class APlaylistHandler {
    protected BasicMidiInfo selectedSongInfo = null;
    protected Integer selectedDisplayIndex = -1;
    protected ArrayList<BasicMidiInfo> filteredSongs = new ArrayList();
    protected final UUID musicPlayerId;

    public abstract ArrayList<UUID> getFavoriteSongs();

    public abstract LoopMode getLoopMode();

    public abstract FavoriteMode getFavoriteMode();

    public abstract SourceMode getSourceMode();

    public abstract Boolean getIsShuffled();

    public abstract UUID getClientSourceId();

    protected abstract Integer getShuffleSeed();

    protected abstract void setFavoriteSongs(ArrayList<UUID> var1);

    protected abstract void setLoopMode(LoopMode var1);

    protected abstract void setFavoriteMode(FavoriteMode var1);

    protected abstract void setSourceMode(SourceMode var1);

    protected abstract void setIsShuffled(Boolean var1);

    public APlaylistHandler(UUID musicPlayerId) {
        this.musicPlayerId = musicPlayerId;
    }

    protected ArrayList<BasicMidiInfo> getSourceSongsSorted(SourceMode source) {
        ArrayList<BasicMidiInfo> result = new ArrayList<BasicMidiInfo>();
        if (source != SourceMode.SERVER && this.getClientSourceId() != null) {
            result.addAll(ServerMidiManager.getSortedMidiInfosForSourceId(this.getClientSourceId()));
        }
        if (source != SourceMode.CLIENT) {
            result.addAll(ServerMidiManager.getServerSongs());
        }
        return result;
    }

    public LoopMode cycleLoopMode() {
        LoopMode mode = this.getLoopMode();
        if (mode == LoopMode.NONE) {
            this.setLoopMode(LoopMode.SINGLE);
        } else if (mode == LoopMode.SINGLE) {
            this.setLoopMode(LoopMode.ALL);
        } else if (mode == LoopMode.ALL) {
            this.setLoopMode(LoopMode.NONE);
        }
        return this.getLoopMode();
    }

    public FavoriteMode cycleFavoriteMode() {
        FavoriteMode mode = this.getFavoriteMode();
        if (mode == FavoriteMode.ALL) {
            this.setFavoriteMode(FavoriteMode.FAVORITE);
        } else if (mode == FavoriteMode.FAVORITE) {
            this.setFavoriteMode(FavoriteMode.NOT_FAVORITE);
        } else if (mode == FavoriteMode.NOT_FAVORITE) {
            this.setFavoriteMode(FavoriteMode.ALL);
        }
        this.refreshFilteredSongs();
        return this.getFavoriteMode();
    }

    public SourceMode cycleSourceMode() {
        SourceMode mode = this.getSourceMode();
        if (mode == SourceMode.ALL) {
            this.setSourceMode(SourceMode.SERVER);
        } else if (mode == SourceMode.SERVER) {
            this.setSourceMode(SourceMode.CLIENT);
        } else if (mode == SourceMode.CLIENT) {
            this.setSourceMode(SourceMode.ALL);
        }
        this.refreshFilteredSongs();
        return this.getSourceMode();
    }

    public Boolean toggleShuffled() {
        this.setIsShuffled(this.getIsShuffled() == false);
        this.refreshFilteredSongs();
        return this.getIsShuffled();
    }

    public Boolean toggleSongFavorite() {
        ArrayList<UUID> newFaves = this.getFavoriteSongs();
        Boolean isNowFavorite = false;
        if (this.getSelectedSongId() != null) {
            if (this.getFavoriteSongs().contains(this.getSelectedSongId())) {
                newFaves.remove(this.getSelectedSongId());
            } else {
                newFaves.add(this.getSelectedSongId());
                isNowFavorite = true;
            }
            this.setFavoriteSongs(newFaves);
            this.refreshFilteredSongs();
        }
        return isNowFavorite;
    }

    public Boolean refreshFilteredSongs() {
        ArrayList<BasicMidiInfo> allSongsSorted = this.getSourceSongsSorted(this.getSourceMode());
        ArrayList<UUID> favoriteSongs = this.getFavoriteSongs();
        this.filteredSongs = this.getFavoriteMode() != FavoriteMode.ALL ? new ArrayList(allSongsSorted.stream().filter(songInfo -> favoriteSongs.contains(songInfo.fileId) == (this.getFavoriteMode() == FavoriteMode.FAVORITE)).collect(Collectors.toList())) : new ArrayList<BasicMidiInfo>(allSongsSorted);
        if (this.getIsShuffled().booleanValue()) {
            Collections.shuffle(this.filteredSongs, new Random(this.getShuffleSeed().intValue()));
        }
        Integer newSelectedIndex = null;
        if (this.getSelectedSongId() != null) {
            for (int i = 0; i < this.filteredSongs.size(); ++i) {
                if (!this.filteredSongs.get((int)i).fileId.toString().equals(this.getSelectedSongId().toString())) continue;
                newSelectedIndex = i;
            }
        }
        if (newSelectedIndex != null) {
            this.selectedDisplayIndex = newSelectedIndex;
            return true;
        }
        this.selectDisplaySong(-1);
        return false;
    }

    public Integer getFilteredSongCount() {
        return this.filteredSongs.size();
    }

    public Integer getSelectedDisplayIndex() {
        return this.selectedDisplayIndex != null ? this.selectedDisplayIndex : -1;
    }

    public UUID getSelectedSongId() {
        return this.selectedSongInfo != null ? this.selectedSongInfo.fileId : null;
    }

    public BasicMidiInfo getSelectedSongInfo() {
        return this.selectedSongInfo;
    }

    public Boolean getFilterHasSongs() {
        return this.getFilteredSongCount() > 0;
    }

    public ArrayList<BasicMidiInfo> getSortedFilteredSongs() {
        return this.filteredSongs;
    }

    public void selectNextSong() {
        if (this.getFilterHasSongs().booleanValue()) {
            Integer newSongIndex = 0;
            if (this.getSelectedDisplayIndex() < this.getFilteredSongCount() - 1) {
                newSongIndex = this.getSelectedDisplayIndex() + 1;
            }
            this.selectDisplaySong(newSongIndex);
        }
    }

    public void selectPreviousSong() {
        if (this.getFilterHasSongs().booleanValue()) {
            Integer newSongIndex = this.getFilteredSongCount() - 1;
            if (this.getSelectedDisplayIndex() > 0) {
                newSongIndex = this.getSelectedDisplayIndex() - 1;
            }
            this.selectDisplaySong(newSongIndex);
        }
    }

    public void selectDisplaySong(Integer displaySongIndex) {
        if (displaySongIndex >= 0 && displaySongIndex < this.getFilteredSongCount()) {
            this.selectedDisplayIndex = displaySongIndex;
            this.selectedSongInfo = this.filteredSongs.get(displaySongIndex);
        } else {
            this.selectedDisplayIndex = null;
            this.selectedSongInfo = null;
        }
        ServerTransmitterManager.onSelectedSongChange(this.musicPlayerId, this.selectedSongInfo);
    }

    public static enum SourceMode {
        ALL,
        CLIENT,
        SERVER;

    }

    public static enum LoopMode {
        ALL,
        SINGLE,
        NONE;

    }

    public static enum FavoriteMode {
        ALL,
        FAVORITE,
        NOT_FAVORITE;

    }
}

