/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.midi.playlist;

import io.github.tofodroid.mods.mimi.server.midi.playlist.APlaylistHandler;
import io.github.tofodroid.mods.mimi.server.midi.playlist.PlaylistData;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerPlaylistHandler
extends APlaylistHandler {
    protected PlaylistData data;
    private static final SavedData.Factory<PlaylistData> DATA_FACTORY = new SavedData.Factory(PlaylistData::new, PlaylistData::loadFromTag, DataFixTypes.OPTIONS);

    public PlayerPlaylistHandler(ServerPlayer player) {
        super(player.getUUID());
        this.data = (PlaylistData)player.getServer().overworld().getDataStorage().computeIfAbsent(DATA_FACTORY, "mimi-ender-playlist-" + player.getUUID().toString());
        this.data.setDirty();
    }

    @Override
    public ArrayList<UUID> getFavoriteSongs() {
        return this.data.favoriteSongs;
    }

    @Override
    public APlaylistHandler.LoopMode getLoopMode() {
        return this.data.loopMode;
    }

    @Override
    public APlaylistHandler.FavoriteMode getFavoriteMode() {
        return this.data.favoriteMode;
    }

    @Override
    public APlaylistHandler.SourceMode getSourceMode() {
        return this.data.sourceMode;
    }

    @Override
    public Boolean getIsShuffled() {
        return this.data.isShuffled;
    }

    @Override
    protected void setFavoriteSongs(ArrayList<UUID> favorites) {
        this.data.favoriteSongs = favorites;
        this.data.setDirty();
    }

    @Override
    protected void setLoopMode(APlaylistHandler.LoopMode mode) {
        this.data.loopMode = mode;
        this.data.setDirty();
    }

    @Override
    protected void setFavoriteMode(APlaylistHandler.FavoriteMode mode) {
        this.data.favoriteMode = mode;
        this.data.setDirty();
    }

    @Override
    protected void setSourceMode(APlaylistHandler.SourceMode mode) {
        this.data.sourceMode = mode;
        this.data.setDirty();
    }

    @Override
    protected void setIsShuffled(Boolean shuffle) {
        this.data.isShuffled = shuffle;
        this.data.shuffleSeed = shuffle != false ? Integer.valueOf(Math.abs(new Random().nextInt())) : Integer.valueOf(0);
        this.data.setDirty();
    }

    @Override
    public UUID getClientSourceId() {
        return this.musicPlayerId;
    }

    @Override
    protected Integer getShuffleSeed() {
        return this.data.shuffleSeed;
    }
}

