/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.midi.playlist;

import io.github.tofodroid.mods.mimi.server.midi.playlist.APlaylistHandler;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;

public class PlaylistData
extends SavedData {
    public ArrayList<UUID> favoriteSongs = new ArrayList();
    public APlaylistHandler.LoopMode loopMode = APlaylistHandler.LoopMode.NONE;
    public APlaylistHandler.FavoriteMode favoriteMode = APlaylistHandler.FavoriteMode.ALL;
    public APlaylistHandler.SourceMode sourceMode = APlaylistHandler.SourceMode.ALL;
    public Boolean isShuffled = false;
    public Integer shuffleSeed = 0;

    public static PlaylistData loadFromTag(CompoundTag tag, HolderLookup.Provider registries) {
        PlaylistData data = new PlaylistData();
        if (tag.contains("favorite_songs")) {
            CompoundTag favoriteSongTag = tag.getCompound("favorite_songs");
            data.favoriteSongs = new ArrayList(favoriteSongTag.getAllKeys().stream().map(key -> UUID.fromString(key)).collect(Collectors.toList()));
        }
        if (tag.contains("loop_mode")) {
            APlaylistHandler.LoopMode loopMode = data.loopMode = tag.getBoolean("loop_mode") ? APlaylistHandler.LoopMode.ALL : APlaylistHandler.LoopMode.SINGLE;
        }
        if (tag.contains("favorite_mode")) {
            APlaylistHandler.FavoriteMode favoriteMode = data.favoriteMode = tag.getBoolean("favorite_mode") ? APlaylistHandler.FavoriteMode.FAVORITE : APlaylistHandler.FavoriteMode.NOT_FAVORITE;
        }
        if (tag.contains("source_mode")) {
            APlaylistHandler.SourceMode sourceMode = data.sourceMode = tag.getBoolean("source_mode") ? APlaylistHandler.SourceMode.CLIENT : APlaylistHandler.SourceMode.SERVER;
        }
        if (tag.contains("shuffled")) {
            data.isShuffled = true;
            data.shuffleSeed = tag.getInt("shuffled");
        }
        return data;
    }

    public static CompoundTag writeToTag(PlaylistData data, CompoundTag resultTag, HolderLookup.Provider registries) {
        CompoundTag favoriteSongTag = new CompoundTag();
        if (!data.favoriteSongs.isEmpty()) {
            Integer i = 0;
            while (i < data.favoriteSongs.size()) {
                favoriteSongTag.putBoolean(data.favoriteSongs.get(i).toString(), true);
                Integer n = i;
                i = i + 1;
            }
            resultTag.put("favorite_songs", (Tag)favoriteSongTag);
        } else {
            resultTag.remove("favorite_songs");
        }
        if (data.loopMode != APlaylistHandler.LoopMode.NONE) {
            resultTag.putBoolean("loop_mode", data.loopMode == APlaylistHandler.LoopMode.ALL);
        } else {
            resultTag.remove("loop_mode");
        }
        if (data.favoriteMode != APlaylistHandler.FavoriteMode.ALL) {
            resultTag.putBoolean("favorite_mode", data.favoriteMode == APlaylistHandler.FavoriteMode.FAVORITE);
        } else {
            resultTag.remove("favorite_mode");
        }
        if (data.sourceMode != APlaylistHandler.SourceMode.ALL) {
            resultTag.putBoolean("source_mode", data.sourceMode == APlaylistHandler.SourceMode.CLIENT);
        } else {
            resultTag.remove("source_mode");
        }
        if (data.isShuffled.booleanValue()) {
            resultTag.putInt("shuffled", data.shuffleSeed.intValue());
        } else {
            resultTag.remove("shuffled");
        }
        return resultTag;
    }

    public static PlaylistData loadFromComponents(DataComponentHolder components) {
        Integer ival;
        Boolean bval;
        PlaylistData data = new PlaylistData();
        CompoundTag cval = TagUtils.getNbtOrDefault(components, "favorite_songs", null);
        if (cval != null) {
            data.favoriteSongs = new ArrayList(cval.getAllKeys().stream().map(key -> UUID.fromString(key)).collect(Collectors.toList()));
        }
        if ((bval = TagUtils.getBooleanOrDefault(components, "loop_mode", null)) != null) {
            APlaylistHandler.LoopMode loopMode = data.loopMode = bval != false ? APlaylistHandler.LoopMode.ALL : APlaylistHandler.LoopMode.SINGLE;
        }
        if ((bval = TagUtils.getBooleanOrDefault(components, "favorite_mode", null)) != null) {
            APlaylistHandler.FavoriteMode favoriteMode = data.favoriteMode = bval != false ? APlaylistHandler.FavoriteMode.FAVORITE : APlaylistHandler.FavoriteMode.NOT_FAVORITE;
        }
        if ((bval = TagUtils.getBooleanOrDefault(components, "source_mode", null)) != null) {
            APlaylistHandler.SourceMode sourceMode = data.sourceMode = bval != false ? APlaylistHandler.SourceMode.CLIENT : APlaylistHandler.SourceMode.SERVER;
        }
        if ((ival = TagUtils.getIntOrDefault(components, "shuffled", null)) != null) {
            data.shuffleSeed = ival;
        }
        return data;
    }

    public static ItemStack writeToComponents(PlaylistData data, ItemStack stack) {
        CompoundTag favoriteSongTag = null;
        if (!data.favoriteSongs.isEmpty()) {
            favoriteSongTag = new CompoundTag();
            Integer i = 0;
            while (i < data.favoriteSongs.size()) {
                favoriteSongTag.putBoolean(data.favoriteSongs.get(i).toString(), true);
                Integer n = i;
                i = i + 1;
            }
        }
        TagUtils.setOrRemoveNbt(stack, "favorite_songs", favoriteSongTag);
        TagUtils.setOrRemoveBoolean(stack, "loop_mode", data.loopMode == APlaylistHandler.LoopMode.NONE ? null : Boolean.valueOf(data.loopMode == APlaylistHandler.LoopMode.ALL));
        TagUtils.setOrRemoveBoolean(stack, "favorite_mode", data.favoriteMode == APlaylistHandler.FavoriteMode.ALL ? null : Boolean.valueOf(data.favoriteMode == APlaylistHandler.FavoriteMode.FAVORITE));
        TagUtils.setOrRemoveBoolean(stack, "source_mode", data.sourceMode == APlaylistHandler.SourceMode.ALL ? null : Boolean.valueOf(data.sourceMode == APlaylistHandler.SourceMode.CLIENT));
        TagUtils.setOrRemoveInt(stack, "shuffled", data.isShuffled != false ? data.shuffleSeed : null);
        return stack;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        return PlaylistData.writeToTag(this, tag, registries);
    }
}

