/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.midi.transmitter;

import io.github.tofodroid.com.sun.media.sound.MidiUtils;
import io.github.tofodroid.com.sun.media.sound.SimpleThreadSequencer;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.midi.BasicMidiInfo;
import io.github.tofodroid.mods.mimi.server.midi.transmitter.ServerMidiInputReceiver;
import io.github.tofodroid.mods.mimi.util.MidiFileUtils;
import java.util.UUID;
import java.util.function.Consumer;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;

public class ServerMidiSequencer {
    private final Runnable sequenceEndCallback;
    private Sequence activeSequence;
    private BasicMidiInfo activeSequenceInfo;
    private Integer songLengthSeconds;
    private byte[] channelMapping;
    private Long startPlayMicros = null;
    private SimpleThreadSequencer<ServerMidiInputReceiver> activeSequencer;

    public ServerMidiSequencer(Consumer<ShortMessage> eventHandler, Runnable sequenceEndCallback) {
        this.initializeSequencer(new ServerMidiInputReceiver(eventHandler));
        this.sequenceEndCallback = sequenceEndCallback;
    }

    public Boolean isPlaying() {
        return this.activeSequencer.isOpen() ? this.activeSequencer.isRunning() : false;
    }

    public Boolean isInProgress() {
        Integer seconds = this.getPositionSeconds();
        return seconds != null && seconds > 0;
    }

    public BasicMidiInfo getSequenceInfo() {
        return this.activeSequenceInfo;
    }

    public Boolean hasSongLoaded() {
        return this.activeSequenceInfo != null && this.activeSequence != null;
    }

    public void unloadSong() {
        this.stop();
        this.activeSequenceInfo = null;
        this.songLengthSeconds = null;
        this.channelMapping = null;
    }

    public UUID getSequenceId() {
        return this.activeSequenceInfo != null ? this.activeSequenceInfo.fileId : null;
    }

    public Integer getPositionSeconds() {
        if (this.activeSequencer.isOpen()) {
            return Long.valueOf(this.activeSequencer.getMicrosecondPosition() / 1000000L).intValue();
        }
        return null;
    }

    public Integer getSongLengthSeconds() {
        return this.songLengthSeconds;
    }

    public byte[] getChannelMapping() {
        return this.channelMapping;
    }

    public void load(BasicMidiInfo info, Sequence sequence) {
        if (this.activeSequencer != null) {
            try {
                this.activeSequencer.setSequence(sequence);
                this.activeSequencer.setTickPosition(0L);
                this.activeSequenceInfo = info;
                this.activeSequence = sequence;
                this.songLengthSeconds = MidiFileUtils.getSongLenghtSeconds(sequence);
                this.channelMapping = MidiFileUtils.getChannelMapping(sequence);
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Failed to load sequence: " + info.fileName + " - " + e.getMessage());
                this.close();
            }
        }
    }

    public void play() {
        if (this.hasSongLoaded().booleanValue() && !this.activeSequencer.isRunning()) {
            if (!this.activeSequencer.isOpen()) {
                this.activeSequencer.open();
                try {
                    this.activeSequencer.setSequence(this.activeSequence);
                }
                catch (Exception e) {
                    MIMIMod.LOGGER.error("Failed to load sequence: " + this.activeSequenceInfo.fileName + " - " + e.getMessage());
                    this.close();
                }
            }
            if (this.activeSequencer.isOpen()) {
                if (this.startPlayMicros != null) {
                    this.activeSequencer.setMicrosecondPosition(this.startPlayMicros);
                    this.startPlayMicros = null;
                }
                this.activeSequencer.start();
            }
        }
    }

    public void setPositionPercent1000(Integer percent) {
        if (this.hasSongLoaded().booleanValue()) {
            Long newMicroPos;
            Boolean wasPlaying = this.isPlaying();
            if (wasPlaying.booleanValue()) {
                this.pause();
            }
            this.startPlayMicros = newMicroPos = Long.valueOf((newMicroPos = Long.valueOf(Double.valueOf(Double.valueOf(percent.intValue()) / 1000.0 * Double.valueOf(this.activeSequence.getMicrosecondLength())).longValue())) < 0L ? 0L : (newMicroPos >= this.activeSequence.getMicrosecondLength() ? this.activeSequence.getMicrosecondLength() - 100L : newMicroPos));
            if (wasPlaying.booleanValue()) {
                this.play();
            }
        }
    }

    public void pause() {
        if (this.activeSequencer.isOpen() && this.activeSequencer.isRunning()) {
            this.activeSequencer.pause();
        }
    }

    public void stop() {
        if (this.activeSequencer.isOpen()) {
            try {
                this.activeSequencer.stop();
                this.activeSequencer.close();
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Failed to stop sequencer: ", (Throwable)e);
                this.close();
            }
        }
    }

    public void close() {
        if (this.activeSequencer.isOpen()) {
            try {
                this.activeSequencer.stop();
                this.activeSequencer.close();
            }
            catch (Exception e) {
                MIMIMod.LOGGER.error("Failed to stop sequencer: ", (Throwable)e);
            }
            this.activeSequencer = null;
        }
        this.activeSequenceInfo = null;
        this.songLengthSeconds = null;
        this.channelMapping = null;
    }

    protected Boolean initializeSequencer(ServerMidiInputReceiver receiver) {
        try {
            final ServerMidiSequencer self = this;
            this.activeSequencer = new SimpleThreadSequencer<ServerMidiInputReceiver>(receiver);
            this.activeSequencer.addMetaEventListener(new MetaEventListener(){

                @Override
                public void meta(MetaMessage meta) {
                    if (MidiUtils.isMetaEndOfTrack(meta) && !ServerMidiSequencer.this.activeSequencer.isRunning()) {
                        self.stop();
                        self.sequenceEndCallback.run();
                    }
                }
            });
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create sequencer: ", e);
        }
    }
}

