/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.network;

import io.github.tofodroid.com.sun.media.sound.MidiUtils;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.midi.BasicMidiInfo;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.common.network.ServerMidiUploadPacket;
import io.github.tofodroid.mods.mimi.server.ServerExecutorProxy;
import io.github.tofodroid.mods.mimi.server.events.broadcast.producer.transmitter.ServerTransmitterManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.sound.midi.Sequence;
import net.minecraft.server.level.ServerPlayer;

public class ServerMidiUploadManager {
    private static final Integer REQUEST_MISSING_PARTS_EVERY_TICKS = 100;
    private static final Integer CANCEL_UPLOAD_AFTER_TICKS = 1000;
    private static Map<UUID, UUID> UPLOAD_CLIENTS = new HashMap<UUID, UUID>();
    private static Map<UUID, BasicMidiInfo> UPLOAD_INFOS = new HashMap<UUID, BasicMidiInfo>();
    private static Map<UUID, Map<Integer, ServerMidiUploadPacket>> UPLOAD_PARTS = new HashMap<UUID, Map<Integer, ServerMidiUploadPacket>>();
    private static Map<UUID, Integer> TICKS_SINCE_LAST_PART = new HashMap<UUID, Integer>();
    private static Boolean doTick = false;

    public static void onServerTick() {
        if (doTick.booleanValue()) {
            ArrayList<UUID> toFail = new ArrayList<UUID>();
            ArrayList<UUID> toClear = new ArrayList<UUID>();
            for (UUID fileId : TICKS_SINCE_LAST_PART.keySet()) {
                int count = TICKS_SINCE_LAST_PART.get(fileId);
                ServerPlayer player = ServerExecutorProxy.getServerPlayerById(UPLOAD_CLIENTS.get(fileId));
                if (player == null || count > CANCEL_UPLOAD_AFTER_TICKS) {
                    toFail.add(fileId);
                } else if (count > 0 && count % REQUEST_MISSING_PARTS_EVERY_TICKS == 0) {
                    if (UPLOAD_PARTS.get(fileId).values().isEmpty()) {
                        ServerMidiUploadManager.requestParts(player, fileId, new byte[]{1});
                    } else {
                        ServerMidiUploadPacket packet = new ArrayList<ServerMidiUploadPacket>(UPLOAD_PARTS.get(fileId).values()).get(0);
                        byte[] missingParts = ServerMidiUploadManager.getMissingParts(fileId, packet.totalParts);
                        if (missingParts.length == 0) {
                            toClear.add(fileId);
                        } else {
                            ServerMidiUploadManager.requestParts(player, fileId, missingParts);
                        }
                    }
                }
                TICKS_SINCE_LAST_PART.put(fileId, count + 1);
            }
            for (UUID fileId : toFail) {
                ServerMidiUploadManager.onUploadFailed(fileId);
            }
            for (UUID fileId : toClear) {
                UPLOAD_CLIENTS.remove(fileId);
                UPLOAD_PARTS.remove(fileId);
                UPLOAD_INFOS.remove(fileId);
                TICKS_SINCE_LAST_PART.remove(fileId);
            }
            doTick = !TICKS_SINCE_LAST_PART.isEmpty();
        }
    }

    public static void startUploadRequest(UUID clientId, BasicMidiInfo info) {
        ServerPlayer player = ServerExecutorProxy.getServerPlayerById(clientId);
        if (!UPLOAD_PARTS.containsKey(info.fileId) && player != null) {
            UPLOAD_PARTS.put(info.fileId, new HashMap());
            UPLOAD_INFOS.put(info.fileId, info);
            UPLOAD_CLIENTS.put(info.fileId, clientId);
            TICKS_SINCE_LAST_PART.put(info.fileId, 0);
            doTick = true;
            NetworkProxy.sendToPlayer(player, new ServerMidiUploadPacket(info.fileId));
        }
    }

    public static byte[] getMissingParts(UUID fileId, Byte expectedParts) {
        Map<Integer, ServerMidiUploadPacket> filePackets = UPLOAD_PARTS.get(fileId);
        int[] parts = new int[]{};
        if (filePackets != null) {
            parts = IntStream.range(0, expectedParts.byteValue()).filter(i -> !filePackets.containsKey(i)).toArray();
        }
        byte[] result = new byte[parts.length];
        for (int i2 = 0; i2 < parts.length; ++i2) {
            result[i2] = (byte)parts[i2];
        }
        return result;
    }

    public static void handlePacket(ServerMidiUploadPacket message, ServerPlayer sender) {
        if (!UPLOAD_CLIENTS.get(message.fileId).equals(sender.getUUID())) {
            MIMIMod.LOGGER.warn("Received upload packet for fileId " + String.valueOf(message.fileId) + " from unexpected sender. Ignoring.");
            return;
        }
        Map<Integer, ServerMidiUploadPacket> filePackets = UPLOAD_PARTS.get(message.fileId);
        if (message.failed().booleanValue()) {
            ServerMidiUploadManager.onUploadFailed(message.fileId);
            return;
        }
        filePackets.put(message.part.intValue(), message);
        if (ServerMidiUploadManager.partsAreAllPresent(message.fileId, filePackets, message.totalParts).booleanValue()) {
            TICKS_SINCE_LAST_PART.remove(message.fileId);
            Sequence sequence = ServerMidiUploadManager.loadSequenceFromParts(UPLOAD_PARTS.remove(message.fileId));
            BasicMidiInfo info = UPLOAD_INFOS.remove(message.fileId);
            UPLOAD_CLIENTS.remove(message.fileId);
            if (sequence == null) {
                ServerTransmitterManager.onSequenceUploadFailed(info);
                return;
            }
            ServerTransmitterManager.onFinishUploadSequence(info, sequence);
        } else {
            UPLOAD_PARTS.put(message.fileId, filePackets);
            TICKS_SINCE_LAST_PART.put(message.fileId, 0);
        }
        doTick = !TICKS_SINCE_LAST_PART.isEmpty();
    }

    public static Sequence loadSequenceFromParts(Map<Integer, ServerMidiUploadPacket> parts) {
        try {
            byte[] fullBytes = ServerMidiUploadManager.merge(parts.values().stream().map(p -> p.data).collect(Collectors.toList()));
            return MidiUtils.byteArrayToSequence(fullBytes);
        }
        catch (Exception e) {
            MIMIMod.LOGGER.error("Failed to load MIDI sequence from received data parts: ", (Throwable)e);
            return null;
        }
    }

    public static void onUploadFailed(UUID fileId) {
        TICKS_SINCE_LAST_PART.remove(fileId);
        doTick = !TICKS_SINCE_LAST_PART.isEmpty();
        UPLOAD_PARTS.remove(fileId);
        BasicMidiInfo info = UPLOAD_INFOS.remove(fileId);
        UPLOAD_CLIENTS.remove(fileId);
        ServerTransmitterManager.onSequenceUploadFailed(info);
    }

    public static byte[] merge(List<byte[]> arrays) {
        int length = arrays.stream().collect(Collectors.summingInt(a -> ((byte[])a).length));
        int i = 0;
        byte[] result = new byte[length];
        Iterator<byte[]> iterator = arrays.iterator();
        while (iterator.hasNext()) {
            byte[] a2;
            byte[] byArray = a2 = iterator.next();
            int n = byArray.length;
            for (int j = 0; j < n; ++j) {
                byte b;
                result[i] = b = byArray[j];
                ++i;
            }
        }
        return result;
    }

    public static Boolean partsAreAllPresent(UUID fileId, Map<Integer, ServerMidiUploadPacket> filePackets, Byte expectedParts) {
        return filePackets.size() == expectedParts.byteValue() && filePackets.values().stream().allMatch(packet -> packet.fileId.equals(fileId)) && IntStream.range(0, expectedParts.byteValue()).allMatch(i -> filePackets.containsKey(i));
    }

    public static void requestParts(ServerPlayer player, UUID fileId, byte[] parts) {
        NetworkProxy.sendToPlayer(player, new ServerMidiUploadPacket(fileId, parts));
    }
}

