/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.util;

import com.mojang.serialization.Codec;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class TagUtils {
    private static final HashMap<String, DataComponentType<Byte>> BYTE_COMPONENTS = new HashMap();
    private static final HashMap<String, DataComponentType<Integer>> INT_COMPONENTS = new HashMap();
    private static final HashMap<String, DataComponentType<Boolean>> BOOL_COMPONENTS = new HashMap();
    private static final HashMap<String, DataComponentType<String>> STRING_COMPONENTS = new HashMap();
    private static final HashMap<String, DataComponentType<UUID>> UUID_COMPONENTS = new HashMap();
    private static final HashMap<String, DataComponentType<CompoundTag>> NBT_COMPONENTS = new HashMap();
    public static final HashMap<ResourceLocation, DataComponentType<?>> COMPONENT_TYPES = new HashMap();

    private static <T> DataComponentType<T> register(String pName, UnaryOperator<DataComponentType.Builder<T>> pBuilder) {
        DataComponentType component = ((DataComponentType.Builder)pBuilder.apply(DataComponentType.builder())).build();
        COMPONENT_TYPES.put(ResourceUtils.newModLocation(pName), component);
        return component;
    }

    private static final DataComponentType<Byte> createByteComponent(String tag) {
        return BYTE_COMPONENTS.computeIfAbsent(tag, newTag -> TagUtils.register(tag, builder -> builder.persistent((Codec)Codec.BYTE).networkSynchronized(ByteBufCodecs.BYTE)));
    }

    private static final DataComponentType<Integer> createIntComponent(String tag) {
        return INT_COMPONENTS.computeIfAbsent(tag, newTag -> TagUtils.register(tag, builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT)));
    }

    private static final DataComponentType<Boolean> createBoolComponent(String tag) {
        return BOOL_COMPONENTS.computeIfAbsent(tag, newTag -> TagUtils.register(tag, builder -> builder.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL)));
    }

    private static final DataComponentType<String> createStringComponent(String tag) {
        return STRING_COMPONENTS.computeIfAbsent(tag, newTag -> TagUtils.register(tag, builder -> builder.persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8)));
    }

    private static final DataComponentType<UUID> createUUIDComponent(String tag) {
        return UUID_COMPONENTS.computeIfAbsent(tag, newTag -> TagUtils.register(tag, builder -> builder.persistent(UUIDUtil.CODEC).networkSynchronized(UUIDUtil.STREAM_CODEC)));
    }

    private static final DataComponentType<CompoundTag> createNbtComponent(String tag) {
        return NBT_COMPONENTS.computeIfAbsent(tag, newTag -> TagUtils.register(tag, builder -> builder.persistent(CompoundTag.CODEC).networkSynchronized(ByteBufCodecs.COMPOUND_TAG)));
    }

    public static final DataComponentType<Byte> getByteComponent(String tag) {
        return BYTE_COMPONENTS.computeIfAbsent(tag, newTag -> {
            MIMIMod.LOGGER.error("Attempted to access unregistered byte component: " + tag);
            return null;
        });
    }

    public static final DataComponentType<Integer> getIntComponent(String tag) {
        return INT_COMPONENTS.computeIfAbsent(tag, newTag -> {
            MIMIMod.LOGGER.error("Attempted to access unregistered int component: " + tag);
            return null;
        });
    }

    public static final DataComponentType<Boolean> getBoolComponent(String tag) {
        return BOOL_COMPONENTS.computeIfAbsent(tag, newTag -> {
            MIMIMod.LOGGER.error("Attempted to access unregistered bool component: " + tag);
            return null;
        });
    }

    public static final DataComponentType<String> getStringComponent(String tag) {
        return STRING_COMPONENTS.computeIfAbsent(tag, newTag -> {
            MIMIMod.LOGGER.error("Attempted to access unregistered string component: " + tag);
            return null;
        });
    }

    public static final DataComponentType<UUID> getUUIDComponent(String tag) {
        return UUID_COMPONENTS.computeIfAbsent(tag, newTag -> {
            MIMIMod.LOGGER.error("Attempted to access unregistered uuid component: " + tag);
            return null;
        });
    }

    public static final DataComponentType<CompoundTag> getNbtComponent(String tag) {
        return NBT_COMPONENTS.computeIfAbsent(tag, newTag -> {
            MIMIMod.LOGGER.error("Attempted to access unregistered nbt component: " + tag);
            return null;
        });
    }

    public static <T> T getOrDefault(DataComponentHolder stack, DataComponentType<T> type, T defaultVal) {
        Object result = stack.get(type);
        return (T)(result != null ? result : defaultVal);
    }

    public static CompoundTag getNbtOrDefault(DataComponentHolder stack, String tag, CompoundTag defaultVal) {
        try {
            DataComponentType<CompoundTag> componentType = TagUtils.getNbtComponent(tag);
            return stack.has(componentType) ? (CompoundTag)stack.get(componentType) : defaultVal;
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static UUID getUUIDOrDefault(DataComponentHolder stack, String tag, UUID defaultVal) {
        try {
            DataComponentType<UUID> componentType = TagUtils.getUUIDComponent(tag);
            return stack.has(componentType) ? (UUID)stack.get(componentType) : defaultVal;
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static Integer getIntOrDefault(DataComponentHolder stack, String tag, Integer defaultVal) {
        try {
            DataComponentType<Integer> componentType = TagUtils.getIntComponent(tag);
            return stack.has(componentType) ? (Integer)stack.get(componentType) : defaultVal;
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static Byte getByteOrDefault(DataComponentHolder stack, String tag, Byte defaultVal) {
        try {
            DataComponentType<Byte> componentType = TagUtils.getByteComponent(tag);
            return stack.has(componentType) ? (Byte)stack.get(componentType) : defaultVal;
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static Boolean getBooleanOrDefault(DataComponentHolder stack, String tag, Boolean defaultVal) {
        try {
            DataComponentType<Boolean> componentType = TagUtils.getBoolComponent(tag);
            return stack.has(componentType) ? (Boolean)stack.get(componentType) : defaultVal;
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static String getStringOrDefault(DataComponentHolder stack, String tag, String defaultVal) {
        try {
            DataComponentType<String> componentType = TagUtils.getStringComponent(tag);
            return stack.has(componentType) ? (String)stack.get(componentType) : defaultVal;
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static void setOrRemoveNbt(ItemStack stack, String tag, CompoundTag value) {
        DataComponentType<CompoundTag> componentType = TagUtils.getNbtComponent(tag);
        if (value != null) {
            stack.set(componentType, (Object)value);
        } else if (stack.has(componentType)) {
            stack.remove(componentType);
        }
    }

    public static void setOrRemoveUUID(ItemStack stack, String tag, UUID value) {
        DataComponentType<UUID> componentType = TagUtils.getUUIDComponent(tag);
        if (value != null) {
            stack.set(componentType, (Object)value);
        } else if (stack.has(componentType)) {
            stack.remove(componentType);
        }
    }

    public static void setOrRemoveInt(ItemStack stack, String tag, Integer value) {
        DataComponentType<Integer> componentType = TagUtils.getIntComponent(tag);
        if (value != null) {
            stack.set(componentType, (Object)value);
        } else if (stack.has(componentType)) {
            stack.remove(componentType);
        }
    }

    public static void setOrRemoveByte(ItemStack stack, String tag, Byte value) {
        DataComponentType<Byte> componentType = TagUtils.getByteComponent(tag);
        if (value != null) {
            stack.set(componentType, (Object)value);
        } else if (stack.has(componentType)) {
            stack.remove(componentType);
        }
    }

    public static void setOrRemoveBoolean(ItemStack stack, String tag, Boolean value) {
        DataComponentType<Boolean> componentType = TagUtils.getBoolComponent(tag);
        if (value != null) {
            stack.set(componentType, (Object)value);
        } else if (stack.has(componentType)) {
            stack.remove(componentType);
        }
    }

    public static void setOrRemoveString(ItemStack stack, String tag, String value) {
        DataComponentType<String> componentType = TagUtils.getStringComponent(tag);
        if (value != null) {
            stack.set(componentType, (Object)value);
        } else if (stack.has(componentType)) {
            stack.remove(componentType);
        }
    }

    public static Byte getByteOrDefault(ItemStack stack, String tag, Integer defaultVal) {
        return TagUtils.getByteOrDefault((DataComponentHolder)stack, tag, defaultVal.byteValue());
    }

    public static Integer getIntOrDefault(ItemStack stack, String tag, Byte defaultVal) {
        return TagUtils.getIntOrDefault((DataComponentHolder)stack, tag, defaultVal.intValue());
    }

    static {
        TagUtils.createBoolComponent("inverted");
        TagUtils.createIntComponent("dye_id");
        TagUtils.createIntComponent("setting_type");
        TagUtils.createNbtComponent("favorite_songs");
        TagUtils.createBoolComponent("loop_mode");
        TagUtils.createBoolComponent("favorite_mode");
        TagUtils.createBoolComponent("source_mode");
        TagUtils.createIntComponent("shuffled");
        TagUtils.createByteComponent("filter_note");
        TagUtils.createByteComponent("filter_oct");
        TagUtils.createBoolComponent("invert_note_oct");
        TagUtils.createByteComponent("broadcast_note");
        TagUtils.createUUIDComponent("source_uuid");
        TagUtils.createStringComponent("source_name");
        TagUtils.createBoolComponent("sys_input");
        TagUtils.createIntComponent("channels");
        TagUtils.createByteComponent("filter_instrument");
        TagUtils.createBoolComponent("invert_instrument");
        TagUtils.createByteComponent("instrument_volume");
        TagUtils.createBoolComponent("invert_signal");
        TagUtils.createBoolComponent("note_start");
        TagUtils.createByteComponent("hold_ticks");
        TagUtils.createByteComponent("broadcast_range");
        TagUtils.createStringComponent("sound");
        TagUtils.createStringComponent("particle");
        TagUtils.createByteComponent("volume");
        TagUtils.createByteComponent("pitch");
        TagUtils.createByteComponent("side");
        TagUtils.createByteComponent("spread");
        TagUtils.createByteComponent("count");
        TagUtils.createByteComponent("speed_x");
        TagUtils.createByteComponent("speed_y");
        TagUtils.createByteComponent("speed_z");
        TagUtils.createIntComponent("particle_loop");
        TagUtils.createIntComponent("sound_loop");
        for (byte i = 0; i < 16; i = (byte)(i + 1)) {
            TagUtils.createByteComponent("channel_map_" + i);
        }
    }
}

