/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen;

import com.mojang.brigadier.CommandDispatcher;
import com.notunanancyowen.commands.AttackCommand;
import com.notunanancyowen.commands.MotionCommand;
import com.notunanancyowen.commands.PathToCommand;
import com.notunanancyowen.commands.TargetCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobAITweaks
implements ModInitializer {
    public static final String MOD_ID = "mob-ai-tweaks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mob-ai-tweaks");
    public static final class_1928.class_4313<class_1928.class_4310> MOBS_ARE_OP = GameRuleRegistry.register((String)"crazyMobs", (class_1928.class_5198)class_1928.class_5198.field_24095, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)false));
    public static final class_6862<class_1792> SHULKER_BREEDING_ITEMS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"mob-ai-tweaks", (String)"shulker_breeding_items"));
    public static final class_6862<class_1792> BANNED_BOWS_AND_CROSSBOWS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"mob-ai-tweaks", (String)"banned_bows_and_crossbows"));
    public static final class_6862<class_1299<?>> BOSS_THAT_ANNOUNCES_SUMMON = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"mob-ai-tweaks", (String)"bosses_that_announce_spawn"));
    public static final class_6862<class_1299<?>> BOSS_THAT_ANNOUNCES_DEFEAT = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"mob-ai-tweaks", (String)"bosses_that_announce_death"));
    private static final HashMap<String, Integer> configIntegers = new HashMap();
    private static final ArrayList<String> disabledFeatures = new ArrayList();
    private static final ArrayList<class_1792> possibleBows = new ArrayList();
    private static final ArrayList<class_1792> possibleCrossbows = new ArrayList();
    public static final ArrayList<String> hostilesThatCannotSit = new ArrayList();
    public static final ArrayList<String> allayItemBlacklist = new ArrayList();
    public static final HashMap<String, String> snifferItemToBiome = new HashMap();

    public void onInitialize() {
        String configText;
        StringBuilder bob;
        BufferedReader reader;
        FileReader configReader;
        FileWriter configWriter;
        File config;
        block75: {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
                AttackCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess);
                MotionCommand.register((CommandDispatcher<class_2168>)dispatcher);
                PathToCommand.register((CommandDispatcher<class_2168>)dispatcher);
                TargetCommand.register((CommandDispatcher<class_2168>)dispatcher);
            });
            try {
                if (FabricLoader.getInstance().getConfigDir().resolve(MOD_ID).toFile().mkdir()) {
                    LOGGER.info("Added general directory!");
                }
                if (FabricLoader.getInstance().getConfigDir().resolve("mob-ai-tweaks/blacklists").toFile().mkdir()) {
                    LOGGER.info("Added blacklists directory!");
                }
                if (FabricLoader.getInstance().getConfigDir().resolve("mob-ai-tweaks/sniffer").toFile().mkdir()) {
                    LOGGER.info("Added sniffer directory!");
                }
            }
            catch (SecurityException e) {
                LOGGER.info("Error making config directories: %n" + e.getLocalizedMessage());
            }
            try {
                config = FabricLoader.getInstance().getConfigDir().resolve("mob-ai-tweaks/blacklists/modded_bows_and_crossbows.txt").toFile();
                if (!config.createNewFile()) break block75;
                configWriter = new FileWriter(config);
                try {
                    configWriter.write("#Dual blacklist for modded bows and crossbows, takes their in-game ID (e.g. mob-ai-tweaks:modded_bow_or_crossbow_item)");
                    configWriter.close();
                }
                finally {
                    configWriter.close();
                }
            }
            catch (IOException | SecurityException e) {
                LOGGER.info("Error making config: %n" + e.getLocalizedMessage());
            }
        }
        try {
            config = FabricLoader.getInstance().getConfigDir().resolve("mob-ai-tweaks/blacklists/allay_weapons.txt").toFile();
            if (config.createNewFile()) {
                configWriter = new FileWriter(config);
                try {
                    configWriter.write("#Blacklist for items allays can use in combat, takes their in-game ID (e.g. mob-ai-tweaks:item_to_blacklist)");
                    configWriter.close();
                }
                finally {
                    configWriter.close();
                }
            }
            configReader = new FileReader(config);
            try {
                reader = new BufferedReader(configReader);
                bob = new StringBuilder();
                configText = null;
                while ((configText = reader.readLine()) != null) {
                    bob.append(configText);
                    bob.append(System.getProperty("line.separator"));
                }
                bob.deleteCharAt(bob.length() - 1);
                reader.close();
                bob.toString().lines().forEach(configContent -> {
                    if (!configContent.startsWith("#Blacklist")) {
                        allayItemBlacklist.add((String)configContent);
                    }
                });
                configReader.close();
            }
            finally {
                configReader.close();
            }
        }
        catch (IOException | SecurityException e) {
            LOGGER.info("Error making config: %n" + e.getLocalizedMessage());
        }
        try {
            config = FabricLoader.getInstance().getConfigDir().resolve("mob-ai-tweaks/blacklists/hostiles_that_can_sit.txt").toFile();
            if (config.createNewFile()) {
                configWriter = new FileWriter(config);
                try {
                    configWriter.write("#Blacklist for hostile mobs that can sit down randomly, takes their in-game ID (e.g. mob-ai-tweaks:mob_to_blacklist)");
                    configWriter.close();
                }
                finally {
                    configWriter.close();
                }
            }
            configReader = new FileReader(config);
            try {
                reader = new BufferedReader(configReader);
                bob = new StringBuilder();
                configText = null;
                while ((configText = reader.readLine()) != null) {
                    bob.append(configText);
                    bob.append(System.getProperty("line.separator"));
                }
                bob.deleteCharAt(bob.length() - 1);
                reader.close();
                bob.toString().lines().forEach(configContent -> {
                    if (!configContent.startsWith("#Blacklist")) {
                        hostilesThatCannotSit.add((String)configContent);
                    }
                });
                configReader.close();
            }
            finally {
                configReader.close();
            }
        }
        catch (IOException | SecurityException e) {
            LOGGER.info("Error making config: %n" + e.getLocalizedMessage());
        }
        String snifferConfig = "#Example is as goes, mob-ai-tweaks:item_to_sniff=mob-ai-tweaks:biome_to_find, do note that it supports biome tags but not item tags\nminecraft:acacia_sapling=#minecraft:is_savanna\nminecraft:bamboo=minecraft:bamboo_jungle\nminecraft:birch_sapling=minecraft:birch_forest\nminecraft:brown_mushroom=minecraft:swamp\nminecraft:cherry_sapling=minecraft:cherry_grove\nminecraft:dark_oak_sapling=minecraft:dark_forest\nminecraft:mangrove_roots=minecraft:mangrove_swamp\nminecraft:oak_sapling=minecraft:forest\nminecraft:red_mushroom=minecraft:mushroom_fields\nminecraft:red_sand=#minecraft:is_badlands\nminecraft:sand=minecraft:desert\nminecraft:spruce_sapling=#minecraft:is_taiga\nminecraft:sunflower=minecraft:plains";
        try {
            File config2 = FabricLoader.getInstance().getConfigDir().resolve("mob-ai-tweaks/sniffer/item_to_biome.txt").toFile();
            if (config2.createNewFile()) {
                try (FileWriter configWriter2 = new FileWriter(config2);){
                    configWriter2.write(snifferConfig);
                    configWriter2.close();
                }
            }
            try (FileReader configReader2 = new FileReader(config2);){
                BufferedReader reader2 = new BufferedReader(configReader2);
                StringBuilder bob2 = new StringBuilder();
                String configText2 = null;
                while ((configText2 = reader2.readLine()) != null) {
                    bob2.append(configText2);
                    bob2.append(System.getProperty("line.separator"));
                }
                bob2.deleteCharAt(bob2.length() - 1);
                reader2.close();
                bob2.toString().lines().forEach(configContent -> {
                    if (!configContent.startsWith("#Example")) {
                        String[] configValues = configContent.split("=", 2);
                        for (int i = 0; i < configValues.length; ++i) {
                            if (configValues[i].contains(":")) continue;
                            configValues[i] = configValues[i].contains("#") ? configValues[i].replace("#", "#minecraft:") : "minecraft:" + configValues[i];
                        }
                        snifferItemToBiome.put(configValues[0], configValues[1]);
                    }
                });
                configReader2.close();
            }
        }
        catch (IOException | SecurityException e) {
            LOGGER.info("Error making config: %n" + e.getLocalizedMessage());
        }
        String originalConfig = "#All cooldowns are in ticks and all chances are in percentage\nallay_rework=true\nblaze_attack_rework=true\nblaze_extra_fireballs_count=0\nblazes_strafe_when_shooting=true\nbogged_special_attacks=true\nbogged_special_attack_cooldown=120\nbosses_enrage=true\nbosses_announce_spawn_and_death=true\nburn_and_freeze_visual_effects=true\nburning_projectile_visuals=true\ncats_avoid_projectiles=true\nchickens_flee_from_mobs=true\nchickens_shed_feathers=true\nchickens_shed_feather_chance=50\ncreepers_explode_stuck_arrows=true\ncreepers_delay_explosion_when_hit=true\ndisable_golem_infighting=true\ndrowned_rework=true\ndrowned_swimming_animation=true\nenchantments_from_mod=true\nender_dragon_crystal_threshold_peaceful=1\nender_dragon_crystal_threshold_easy=2\nender_dragon_crystal_threshold_normal=3\nender_dragon_crystal_threshold_hard=4\nender_dragon_healing_rework=true\nender_dragon_rework=true\nenderman_rework=true\nenderman_rework_attack_animation=true\nelder_guardians_are_bosses=true\nelder_guardians_boss_armor=8\nelder_guardians_boss_health=150\nevokers_cast_fireball=true\nevokers_cast_fireball_cooldown=20\nghasts_cry_tears=true\nghasts_cry_tears_cooldown=60\nhostile_mobs_can_escape_boats=true\nhostile_mobs_can_sit=true\nhostile_mobs_sitting_can_be_startled=true\nhusks_can_burrow=true\nillagers_and_zombie_villagers_fight=true\nillagers_use_boats=true\nillusioner_rework=true\nillusioner_bad_omen_spawn_chance=5\niron_golem_rework=true\niron_golem_pickaxe_damage_boost=100\nline_of_sight_rework=true\nmelee_mobs_jump_to_reach=true\nominous_mobs=true\nphantom_rework=true\nphantom_projectile_damage_boost=200\nphantom_reset_insomnia_size=3\nphantoms_become_hostile_size=3\nphantom_boss_follow_range=160\nphantom_boss_health=100\nphantom_boss_size=20\nphantom_boss_spawn_chance=1\nphantoms_from_spawner_always_attack=true\npillager_crossbow_range=15\npillagers_eat_food=true\npillagers_can_melee_attack=true\npillagers_use_modded_crossbows=true\nranged_mobs_reposition=true\nranged_mobs_use_guns=true\nravagers_are_minibosses=true\nravager_special_attacks=true\nravager_special_attack_cooldown=180\nshulker_breed_heal_amount=10\nshulker_pickaxe_damage_boost=150\nshulker_duplicate_dye_amount=3\nshulkers_are_breedable=true\nshulkers_are_dyeable=true\nshulkers_can_be_silk_touched=true\nskeleton_babies=true\nskeleton_horsemen=true\nskeleton_sniper_AI=true\nskeleton_special_attacks=true\nskeleton_special_attack_cooldown=200\nskeleton_strafe_speed_buff=true\nskeletons_can_convert_to_wither=true\nskeletons_use_modded_bows=true\nsneak_to_approach_animals=true\nsniffer_announces_biome_find=true\nsniffer_announces_block_find=true\nsniffer_rework=true\nsnow_golem_rework=true\nsnow_golem_pumpkin_can_be_returned=true\nsnow_golem_armor_if_it_has_pumpkin=10\nsnow_golem_accuracy_when_no_pumpkin=2\nsquid_ink_inflicts_debuffs=true\nsquid_ink_debuff_radius=8\nsquid_ink_debuff_duration=100\nglow_squid_night_vision_on_stare_duration=600\nstray_special_attacks=true\nstray_special_attack_cooldown=120\nthrowable_fire_charges=true\nundead_horses_burn_in_day=true\nvex_rework=true\nvex_charge_attack_min_distance=4\nvex_projectile_damage_boost=200\nvillagers_eat_food=true\nvillagers_have_special_roles=true\nwardens_get_stunned_by_bells=true\nwither_death_animation=true\nwither_rework=true\nwither_boss_armor=12\nwither_boss_follow_range=120\nwither_boss_health=300\nwither_skeleton_special_attacks=true\nwither_skeleton_special_attack_cooldown=200\nwither_skeletons_with_bows_chance=10\nzombie_dads_from_bedrock=true\nzombie_leader_rework=true\nzombie_pigmen_can_use_crossbows=true\nzombie_pigmen_with_crossbows_chance=20\nzombie_villager_special_attacks=true";
        long originalConfigSize = originalConfig.lines().count();
        try {
            FileWriter configWriter3;
            File config3 = FabricLoader.getInstance().getConfigDir().resolve("mob-ai-tweaks/general_config.txt").toFile();
            if (config3.createNewFile()) {
                configWriter3 = new FileWriter(config3);
                try {
                    configWriter3.write(originalConfig);
                    configWriter3.close();
                }
                finally {
                    configWriter3.close();
                }
            }
            try (FileReader configReader3 = new FileReader(config3);){
                BufferedReader reader3 = new BufferedReader(configReader3);
                StringBuilder bob3 = new StringBuilder();
                String configText3 = null;
                int tries = -1;
                while ((long)(++tries) <= originalConfigSize && (configText3 = reader3.readLine()) != null) {
                    bob3.append(configText3);
                    bob3.append(System.getProperty("line.separator"));
                }
                bob3.deleteCharAt(bob3.length() - 1);
                reader3.close();
                bob3.toString().lines().forEach(configContent -> {
                    if (!configContent.startsWith("#") && configContent.contains("=")) {
                        String[] configValues = configContent.split("=", 2);
                        if (configValues[1].contains("false")) {
                            disabledFeatures.add(configValues[0]);
                        } else if (!configValues[1].contains("true")) {
                            boolean putItIn = true;
                            for (int i = 0; i < configValues[1].length(); ++i) {
                                if (Character.isDigit(configValues[1].charAt(i))) continue;
                                putItIn = false;
                                break;
                            }
                            if (putItIn) {
                                configIntegers.put(configValues[0], Integer.valueOf(configValues[1]));
                            }
                        }
                    }
                });
                configReader3.close();
                if (bob3.toString().lines().count() == originalConfigSize) {
                    return;
                }
            }
            config3.delete();
            if (config3.createNewFile()) {
                configWriter3 = new FileWriter(config3);
                try {
                    originalConfig.lines().forEach(configContent -> {
                        if (((String)configContent).startsWith("#") || !((String)configContent).contains("=")) {
                            try {
                                configWriter3.append((CharSequence)configContent);
                                if ((long)originalConfig.lines().toList().indexOf(configContent) < originalConfigSize - 1L) {
                                    configWriter3.append(System.getProperty("line.separator"));
                                }
                            }
                            catch (IOException e) {
                                return;
                            }
                            return;
                        }
                        String[] configValues = ((String)configContent).split("=", 2);
                        if (configIntegers.containsKey(configValues[0])) {
                            try {
                                Object number = "";
                                for (int i = 0; i < configValues[1].length(); ++i) {
                                    if (!Character.isDigit(configValues[1].charAt(i))) continue;
                                    number = (String)number + configValues[1].charAt(i);
                                }
                                configContent = configValues[0] + "=" + MobAITweaks.getModConfigValue(configValues[0], Integer.valueOf((String)number));
                                configWriter3.append((CharSequence)configContent);
                                if ((long)originalConfig.lines().toList().indexOf(configContent) < originalConfigSize - 1L) {
                                    configWriter3.append(System.getProperty("line.separator"));
                                }
                            }
                            catch (IOException e) {
                                return;
                            }
                            return;
                        }
                        if (disabledFeatures.contains(configValues[0]) || configValues[1].contains("false")) {
                            configContent = ((String)configContent).replace("true", "false");
                        }
                        try {
                            configWriter3.append((CharSequence)configContent);
                            if ((long)originalConfig.lines().toList().indexOf(configContent) < originalConfigSize - 1L) {
                                configWriter3.append(System.getProperty("line.separator"));
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                    configWriter3.close();
                }
                finally {
                    configWriter3.close();
                }
            }
            LOGGER.info("Config updated!");
        }
        catch (IOException | SecurityException e) {
            LOGGER.info("Error making config: %n" + e.getLocalizedMessage());
        }
        LOGGER.info("Mob AIs have been tweaked!");
    }

    public static boolean isOminous(class_1309 entity) {
        return entity != null && MobAITweaks.getModConfigValue("ominous_mobs") && (entity.method_6059(class_1294.field_16595) || entity.method_6059(class_1294.field_50116));
    }

    public static class_1792 getRandomBow(class_5819 random) {
        if (!MobAITweaks.getModConfigValue("skeletons_use_modded_bows")) {
            return class_1802.field_8102;
        }
        if (possibleBows.isEmpty()) {
            LOGGER.info("List of possible modded bow items are empty, preparing to fill up...");
            class_7923.field_41178.method_10220().filter(item -> item instanceof class_1753).forEach(item -> possibleBows.add((class_1792)item));
            if (possibleBows.size() > 1) {
                block13: {
                    try {
                        File config = FabricLoader.getInstance().getConfigDir().resolve("mob-ai-tweaks/blacklists/modded_bows_and_crossbows.txt").toFile();
                        if (!config.exists()) break block13;
                        try (FileReader configReader = new FileReader(config);){
                            BufferedReader reader = new BufferedReader(configReader);
                            StringBuilder bob = new StringBuilder();
                            String configText = null;
                            int tries = -1;
                            while (++tries < Integer.MAX_VALUE && (configText = reader.readLine()) != null) {
                                bob.append(configText);
                                bob.append(System.getProperty("line.separator"));
                            }
                            bob.deleteCharAt(bob.length() - 1);
                            reader.close();
                            String b = bob.toString();
                            String blacklist = b.substring(b.indexOf(")") + 1);
                            if (possibleBows.removeIf(bow -> blacklist.contains(bow.toString()))) {
                                LOGGER.info(String.format("Some modded bow items have been blacklisted...", new Object[0]));
                            }
                            configReader.close();
                        }
                    }
                    catch (IOException | SecurityException e) {
                        LOGGER.info("Error reading config: %n" + e.getLocalizedMessage());
                    }
                }
                LOGGER.info(String.format("Found %d modded bow items, all have been registered. Expect skeletons to spawn with them!", possibleBows.size()));
            } else {
                LOGGER.info("No modded bow items have been found!");
            }
        }
        return possibleBows.size() > 1 ? possibleBows.get(random.method_43048(possibleBows.size() - 1) + 1) : class_1802.field_8102;
    }

    public static class_1792 getRandomCrossbow(class_5819 random) {
        if (!MobAITweaks.getModConfigValue("pillagers_use_modded_crossbows")) {
            return class_1802.field_8399;
        }
        if (possibleCrossbows.isEmpty()) {
            LOGGER.info("List of possible modded crossbow items are empty, preparing to fill up...");
            class_7923.field_41178.method_10220().filter(item -> item instanceof class_1764).forEach(item -> possibleCrossbows.add((class_1792)item));
            if (possibleCrossbows.size() > 1) {
                block13: {
                    try {
                        File config = FabricLoader.getInstance().getConfigDir().resolve("mob-ai-tweaks/blacklists/modded_bows_and_crossbows.txt").toFile();
                        if (!config.exists()) break block13;
                        try (FileReader configReader = new FileReader(config);){
                            BufferedReader reader = new BufferedReader(configReader);
                            StringBuilder bob = new StringBuilder();
                            String configText = null;
                            int tries = -1;
                            while (++tries < Integer.MAX_VALUE && (configText = reader.readLine()) != null) {
                                bob.append(configText);
                                bob.append(System.getProperty("line.separator"));
                            }
                            bob.deleteCharAt(bob.length() - 1);
                            reader.close();
                            String b = bob.toString();
                            String blacklist = b.substring(b.indexOf(")") + 1);
                            if (possibleCrossbows.removeIf(crossbow -> blacklist.contains(crossbow.toString()))) {
                                LOGGER.info(String.format("Some modded bow items have been blacklisted...", new Object[0]));
                            }
                            configReader.close();
                        }
                    }
                    catch (IOException | SecurityException e) {
                        LOGGER.info("Error reading config: %n" + e.getLocalizedMessage());
                    }
                }
                LOGGER.info(String.format("Found %d modded crossbow items, all have been registered. Expect pillagers to spawn with them!", possibleCrossbows.size()));
            } else {
                LOGGER.info("No modded crossbow items have been found!");
            }
        }
        return possibleCrossbows.size() > 1 ? possibleCrossbows.get(random.method_43048(possibleCrossbows.size() - 1) + 1) : class_1802.field_8399;
    }

    public static boolean getModConfigValue(String whatToGet) {
        if (disabledFeatures == null || disabledFeatures.isEmpty()) {
            return true;
        }
        try {
            return !disabledFeatures.contains(whatToGet);
        }
        catch (Throwable ignore) {
            return true;
        }
    }

    public static int getModConfigValue(String whatToGet, int fallback) {
        if (configIntegers == null || configIntegers.isEmpty()) {
            return fallback;
        }
        try {
            return configIntegers.getOrDefault(whatToGet, fallback);
        }
        catch (Throwable ignore) {
            return fallback;
        }
    }
}

