/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.notunanancyowen.MobAITweaks;
import com.notunanancyowen.goals.PhantomBossGoal;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10691;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1307;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import net.minecraft.class_1451;
import net.minecraft.class_1569;
import net.minecraft.class_1593;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_5743;
import net.minecraft.class_8103;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1593.class})
public abstract class PhantomEntityMixin
extends class_1307
implements class_1569 {
    @Unique
    private static final class_2940<Boolean> FROM_SPAWNER = class_2945.method_12791(PhantomEntityMixin.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Boolean> BOSS = class_2945.method_12791(PhantomEntityMixin.class, (class_2941)class_2943.field_13323);
    @Unique
    private final class_3213 bossBar = new class_3213(this.method_5476(), class_1259.class_1260.field_5780, class_1259.class_1261.field_5795);
    @Shadow
    class_243 field_7314 = class_243.field_1353;

    @Shadow
    public abstract void method_7091(int var1);

    @Shadow
    public abstract int method_7084();

    @Shadow
    protected abstract void method_5959();

    PhantomEntityMixin(class_1299<? extends class_1593> type, class_1937 world) {
        super(type, world);
    }

    public boolean method_64397(class_3218 server, class_1282 source, float amount) {
        float damageMultiplier = (float)MobAITweaks.getModConfigValue("phantom_projectile_damage_boost", 200) * 0.01f + 1.0f;
        if (damageMultiplier <= 0.0f) {
            return false;
        }
        if (!((Boolean)this.method_5841().method_12789(BOSS)).booleanValue() && source.method_48789(class_8103.field_42247)) {
            amount = amount > 0.0f ? (amount *= damageMultiplier) : (amount += damageMultiplier);
        }
        return super.method_64397(server, source, amount);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="HEAD")})
    private void trackData(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(FROM_SPAWNER, (Object)false);
        builder.method_56912(BOSS, (Object)false);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void putNewStuffToNBT(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10556("IsBoss", ((Boolean)this.method_5841().method_12789(BOSS)).booleanValue());
        nbt.method_10556("IsFromSpawner", ((Boolean)this.method_5841().method_12789(FROM_SPAWNER)).booleanValue());
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void getNewStuffFromNBT(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10577("IsBoss").ifPresent(b -> this.method_5841().method_12778(BOSS, b));
        nbt.method_10577("IsFromSpawner").ifPresent(s -> this.method_5841().method_12778(FROM_SPAWNER, s));
    }

    @Inject(method={"initialize"}, at={@At(value="TAIL")})
    private void onSpawn(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, CallbackInfoReturnable<class_1315> cir) {
        if (spawnReason == class_3730.field_47245 || spawnReason == class_3730.field_16469) {
            this.method_5841().method_12778(FROM_SPAWNER, (Object)MobAITweaks.getModConfigValue("phantoms_from_spawner_always_attack"));
        } else if (spawnReason == class_3730.field_16459 && !this.method_5770().method_8390(class_1593.class, this.method_5829().method_1009(128.0, 128.0, 128.0), p -> (Boolean)p.method_5841().method_12789(BOSS)).isEmpty()) {
            this.method_31472();
        } else if (MobAITweaks.getModConfigValue("ominous_mobs") && this.method_59922().method_43048(100) < MobAITweaks.getModConfigValue("phantom_boss_spawn_chance", 1)) {
            for (class_1657 p2 : this.method_37908().method_18456()) {
                if (!MobAITweaks.isOminous((class_1309)p2)) continue;
                this.method_5841().method_12778(BOSS, (Object)true);
            }
        }
    }

    @Inject(method={"onTrackedDataSet"}, at={@At(value="TAIL")})
    private void becomeBoss(class_2940<?> data, CallbackInfo ci) {
        if (data.equals(BOSS)) {
            if (((Boolean)this.method_5841().method_12789(BOSS)).booleanValue()) {
                class_1324 attribute4;
                this.field_5960 = true;
                int phantomBossSize = MobAITweaks.getModConfigValue("phantom_boss_size", 20);
                if (this.method_7084() < phantomBossSize) {
                    this.method_7091(phantomBossSize);
                }
                class_1324 attribute2 = this.method_5996(class_5134.field_23716);
                int phantomBossHP = MobAITweaks.getModConfigValue("phantom_boss_health", 100);
                if (attribute2 != null && attribute2.method_6194() != (double)phantomBossHP) {
                    attribute2.method_6192((double)phantomBossHP);
                    this.method_6033(phantomBossHP);
                }
                class_1324 attribute3 = this.method_5996(class_5134.field_23717);
                int phantomBossFR = MobAITweaks.getModConfigValue("phantom_boss_follow_range", 160);
                if (attribute3 != null && attribute3.method_6194() < (double)phantomBossFR) {
                    attribute3.method_6192((double)phantomBossFR);
                }
                if ((attribute4 = this.method_5996(class_5134.field_23721)) != null && attribute4.method_6194() != 14.0) {
                    attribute4.method_6192(14.0);
                }
            } else {
                this.bossBar.method_14094();
                this.bossBar.method_14091(false);
                this.field_5960 = false;
                this.method_7091(1);
                class_1324 attribute2 = this.method_5996(class_5134.field_23716);
                int phantomBossHP = 20;
                if (attribute2 != null && attribute2.method_6194() != (double)phantomBossHP) {
                    attribute2.method_6192((double)phantomBossHP);
                    this.method_6033(phantomBossHP);
                }
                class_1324 attribute3 = this.method_5996(class_5134.field_23717);
                int phantomBossFR = 16;
                if (attribute3 != null && attribute3.method_6194() != (double)phantomBossFR) {
                    attribute3.method_6192((double)phantomBossFR);
                }
                this.method_5959();
            }
        }
    }

    @Inject(method={"initGoals"}, at={@At(value="TAIL")})
    private void reworkTargeting(CallbackInfo ci) {
        if (MobAITweaks.getModConfigValue("ominous_mobs")) {
            this.field_6201.method_6277(0, (class_1352)new PhantomBossGoal((class_1593)this){

                @Override
                public boolean method_6264() {
                    return (Boolean)PhantomEntityMixin.this.method_5841().method_12789(BOSS);
                }

                @Override
                public void method_6269() {
                    super.method_6269();
                    PhantomEntityMixin.this.field_6201.method_35113(p -> !((Object)((Object)this)).equals(p));
                    if (PhantomEntityMixin.this.method_5968() != null) {
                        PhantomEntityMixin.this.field_7314 = PhantomEntityMixin.this.method_5968().method_33571();
                    }
                }

                @Override
                protected class_243 getTargetPosition() {
                    return PhantomEntityMixin.this.field_7314;
                }

                @Override
                protected void setTargetPosition(class_243 where) {
                    PhantomEntityMixin.this.field_7314 = where;
                }
            });
        }
        if (!MobAITweaks.getModConfigValue("phantom_rework")) {
            return;
        }
        this.field_6185.method_35115().clear();
        this.field_6185.method_6277(0, new class_1352(){
            private boolean shootSpitBall = false;
            private int delay = 2.method_38848((int)20);

            public boolean method_6264() {
                if (this.delay > 0) {
                    --this.delay;
                    return false;
                }
                if (PhantomEntityMixin.this.method_6065() != null) {
                    PhantomEntityMixin.this.method_5980(PhantomEntityMixin.this.method_6065());
                    return true;
                }
                if (PhantomEntityMixin.this.method_7084() > MobAITweaks.getModConfigValue("phantoms_become_hostile_size", 3) || ((Boolean)PhantomEntityMixin.this.method_5841().method_12789(FROM_SPAWNER)).booleanValue()) {
                    this.delay = 2.method_38848((int)60);
                    List list = PhantomEntityMixin.this.method_37908().method_8390(class_1657.class, PhantomEntityMixin.this.method_5829().method_1009(16.0, 64.0, 16.0), p -> p.method_5805() && !p.method_68878() && !p.method_7325() && PhantomEntityMixin.this.method_5739((class_1297)p) < 64.0f);
                    if (list.isEmpty()) {
                        return false;
                    }
                    list.sort(Comparator.comparing(class_1297::method_23318).reversed());
                    for (class_1657 player : list) {
                        if (!class_4051.field_18092.method_18419(2.method_64451((class_1297)PhantomEntityMixin.this), (class_1309)PhantomEntityMixin.this, (class_1309)player)) continue;
                        PhantomEntityMixin.this.method_5980((class_1309)player);
                        return true;
                    }
                    return false;
                }
                this.delay = 2.method_38848((int)60);
                List list = PhantomEntityMixin.this.method_37908().method_8390(class_1429.class, PhantomEntityMixin.this.method_5829().method_1009(16.0, 64.0, 16.0), p -> PhantomEntityMixin.this.method_5739((class_1297)p) < 64.0f);
                if (list.isEmpty()) {
                    return false;
                }
                list.sort(Comparator.comparing(class_1297::method_23318).reversed());
                for (class_1429 animal : list) {
                    if (animal instanceof class_1451) {
                        return false;
                    }
                    if (!class_4051.field_18092.method_18419(2.method_64451((class_1297)PhantomEntityMixin.this), (class_1309)PhantomEntityMixin.this, (class_1309)animal) || animal.method_6109()) continue;
                    PhantomEntityMixin.this.method_5980((class_1309)animal);
                    return true;
                }
                return false;
            }

            public boolean method_6266() {
                return PhantomEntityMixin.this.method_5968() != null && class_4051.field_18092.method_18419(2.method_64451((class_1297)PhantomEntityMixin.this), (class_1309)PhantomEntityMixin.this, PhantomEntityMixin.this.method_5968());
            }

            public void method_6269() {
                if (2.method_64451((class_1297)PhantomEntityMixin.this).method_64395().method_8355(MobAITweaks.MOBS_ARE_OP)) {
                    this.shootSpitBall = true;
                }
                super.method_6269();
            }

            public void method_6268() {
                class_1309 target;
                class_1309 class_13092;
                if (!((Boolean)PhantomEntityMixin.this.method_5841().method_12789(BOSS)).booleanValue() && this.shootSpitBall && (class_13092 = PhantomEntityMixin.this.method_5968()) instanceof class_1309 && Math.abs(Math.atan2((target = class_13092).method_23321() - PhantomEntityMixin.this.method_23321(), target.method_23317() - PhantomEntityMixin.this.method_23317()) - Math.atan2(PhantomEntityMixin.this.method_18798().method_10215(), PhantomEntityMixin.this.method_18798().method_10216())) < 0.1 && PhantomEntityMixin.this.method_5739((class_1297)target) > 10.0f) {
                    class_1937 class_19372;
                    class_1799 ball = class_1802.field_8828.method_7854();
                    ball.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8972));
                    class_10691 spit = new class_10691(PhantomEntityMixin.this.method_37908(), (class_1309)PhantomEntityMixin.this, ball);
                    spit.method_5875(true);
                    spit.method_33574(PhantomEntityMixin.this.method_33571().method_1019(PhantomEntityMixin.this.method_18798()));
                    if (PhantomEntityMixin.this.method_5968() != null) {
                        spit.method_18799(PhantomEntityMixin.this.method_5968().method_33571().method_1019(PhantomEntityMixin.this.method_5968().method_18798()).method_1020(spit.method_19538()).method_1029().method_1021(2.0));
                    } else {
                        spit.method_18799(PhantomEntityMixin.this.method_5720().method_1021(2.0));
                    }
                    PhantomEntityMixin.this.method_37908().method_8649((class_1297)spit);
                    if (!PhantomEntityMixin.this.method_5701()) {
                        PhantomEntityMixin.this.method_37908().method_8396((class_1297)PhantomEntityMixin.this, PhantomEntityMixin.this.method_24515(), class_3417.field_15194, class_3419.field_15251, 4.0f, 1.0f);
                    }
                    if ((class_19372 = PhantomEntityMixin.this.method_37908()) instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)class_19372;
                        serverWorld.method_65096((class_2394)class_2398.field_11246, PhantomEntityMixin.this.method_23317(), PhantomEntityMixin.this.method_23320(), PhantomEntityMixin.this.method_23321(), PhantomEntityMixin.this.method_7084() * 2 + 4, 0.1, 0.1, 0.1, 0.2);
                    }
                    this.shootSpitBall = false;
                }
                super.method_6268();
            }
        });
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void bossHealthBar(CallbackInfo ci) {
        if (((Boolean)this.method_5841().method_12789(BOSS)).booleanValue()) {
            class_3222 attacker;
            class_3222 target;
            double followRange = this.method_45325(class_5134.field_23717);
            class_1309 class_13092 = this.method_5968();
            if (class_13092 instanceof class_3222 && (double)this.method_5739((class_1297)(target = (class_3222)class_13092)) < followRange) {
                this.bossBar.method_14088(target);
            }
            if ((class_13092 = this.method_49107()) instanceof class_3222 && (double)this.method_5739((class_1297)(attacker = (class_3222)class_13092)) < followRange) {
                this.bossBar.method_14088(attacker);
            }
            for (class_3222 player : this.bossBar.method_14092()) {
                if (!((double)this.method_5739((class_1297)player) >= followRange)) continue;
                this.bossBar.method_14089(player);
            }
            this.bossBar.method_5408(this.method_6032() / this.method_6063());
            if (this.method_16914()) {
                this.bossBar.method_5413(this.method_5476());
            } else {
                this.bossBar.method_5413((class_2561)class_2561.method_43471((String)"mob-ai-tweaks.ominous_phantom"));
            }
            this.field_6251 = 1.0f;
        }
    }

    @ModifyExpressionValue(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/mob/PhantomEntity;isAffectedByDaylight()Z")})
    private boolean doNotBurnInDaylightIfBoss(boolean original) {
        return original && (Boolean)this.method_5841().method_12789(BOSS) == false;
    }

    @ModifyArg(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;addParticleClient(Lnet/minecraft/particle/ParticleEffect;DDDDDD)V"), index=0)
    private class_2394 replaceParticleWhenBoss(class_2394 parameters) {
        if (((Boolean)this.method_5841().method_12789(BOSS)).booleanValue()) {
            return new class_5743(class_9848.method_61323((int)25, (int)255, (int)10), class_9848.method_61323((int)20, (int)20, (int)20), 2.0f);
        }
        return parameters;
    }

    public boolean method_5874(class_3218 world, class_1309 other) {
        if (MobAITweaks.getModConfigValue("phantom_rework") && !((Boolean)this.method_5841().method_12789(BOSS)).booleanValue() && other instanceof class_1429) {
            this.method_7091(this.method_7084() + 1);
        }
        return super.method_5874(world, other);
    }

    protected void method_23733(@Nullable class_1309 adversary) {
        class_1657 player;
        if (((Boolean)this.method_5841().method_12789(BOSS)).booleanValue()) {
            this.bossBar.method_5408(0.0f);
        }
        if (MobAITweaks.getModConfigValue("phantom_rework") && this.method_7084() > MobAITweaks.getModConfigValue("phantom_reset_insomnia_size", 3) && adversary instanceof class_1657 && (player = (class_1657)adversary) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.method_14248().method_15023(player, class_3468.field_15419.method_14956((Object)class_3468.field_15429), 0);
        }
        super.method_23733(adversary);
    }

    protected void method_60699(class_3218 server, class_1297.class_5529 reason) {
        this.bossBar.method_14094();
        this.bossBar.method_14091(false);
        if (MobAITweaks.getModConfigValue("bosses_announce_spawn_and_death") && ((Boolean)this.method_5841().method_12789(BOSS)).booleanValue() && this.method_5682() != null && this.method_5682().method_3760() != null) {
            boolean useTerrariaText = FabricLoader.getInstance().isModLoaded("terra_entity");
            class_5250 message = class_2561.method_43469((String)(useTerrariaText ? (reason == class_1297.class_5529.field_26998 ? "message.terraentity.boss_leave" : "message.terraentity.boss_discard") : "mob-ai-tweaks.boss_defeated"), (Object[])new Object[]{class_2561.method_43471((String)"mob-ai-tweaks.ominous_phantom").getString()}).method_27661().method_27692(class_124.field_1064);
            if (useTerrariaText) {
                message.method_27692(class_124.field_1067);
            }
            if (reason == class_1297.class_5529.field_26998 || useTerrariaText) {
                this.method_5682().method_3760().method_43514((class_2561)message, false);
            }
        }
        super.method_60699(server, reason);
    }
}

