/*
 * Decompiled with CFR 0.152.
 */
package com.notunanancyowen.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.notunanancyowen.MobAITweaks;
import com.notunanancyowen.dataholders.WitherAttacksInterface;
import com.notunanancyowen.goals.WitherChargeAttackGoal;
import com.notunanancyowen.goals.WitherSlamAttackGoal;
import com.notunanancyowen.goals.WitherStrafeShootGoal;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1528;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4135;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1528.class})
public abstract class WitherEntityMixin
extends class_1588
implements class_1603,
WitherAttacksInterface {
    @Shadow
    @Final
    private class_3213 field_7093;
    @Shadow
    @Final
    private int[] field_7091;
    @Shadow
    private int field_7082;
    @Unique
    private final int[] headAttacksCounter = new int[]{0, 0, 0, 0};
    @Unique
    private static final class_2940<Integer> CHARGE_TIME = class_2945.method_12791(WitherEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Integer> SLAM_TIME = class_2945.method_12791(WitherEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Boolean> ENRAGED = class_2945.method_12791(WitherEntityMixin.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Boolean> BLUE = class_2945.method_12791(WitherEntityMixin.class, (class_2941)class_2943.field_13323);
    @Unique
    private class_1282 lastDamageSource;
    @Unique
    private boolean isReworked = true;

    @Shadow
    protected abstract void method_6877(int var1, double var2, double var4, double var6, boolean var8);

    @Shadow
    protected abstract class_3414 method_6002();

    @Shadow
    public abstract int method_6884();

    @Shadow
    public abstract boolean method_6872();

    @Shadow
    public abstract void method_6876(int var1, int var2);

    WitherEntityMixin(class_1299<? extends class_1588> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"shootSkullAt(ILnet/minecraft/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void performRangedAttack(int i, class_1309 livingEntity, CallbackInfo ci) {
        if (!this.isReworked) {
            return;
        }
        if (this.method_6884() > 0 || this.getChargeTime() > 0 || this.getSlamTime() > 0) {
            this.method_5841().method_12778(BLUE, (Object)false);
            ci.cancel();
            return;
        }
        double targetPosX = livingEntity.method_23317();
        double targetPosY = livingEntity.method_23318() + (double)livingEntity.method_5751() * 0.5;
        double targetPosZ = livingEntity.method_23321();
        float hpRatio = this.method_6032() / this.method_6063();
        if (i == 0) {
            this.method_6877(i, targetPosX, targetPosY, targetPosZ, true);
            ci.cancel();
        } else if (hpRatio < 0.6666f || this.headAttacksCounter[i] < 0) {
            if (this.headAttacksCounter[i] <= 0 || hpRatio < 0.1666f) {
                this.headAttacksCounter[i] = hpRatio <= 0.3333f ? 4 : 8;
                this.method_6877(i, targetPosX, targetPosY, targetPosZ, true);
                ci.cancel();
            } else {
                int n = i;
                this.headAttacksCounter[n] = this.headAttacksCounter[n] - 1;
            }
        }
    }

    @Inject(method={"shootSkullAt(IDDDZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasShotBlueSkull(int headIndex, double targetX, double targetY, double targetZ, boolean charged, CallbackInfo ci) {
        if (this.method_6884() > 0 || this.getChargeTime() > 0 || this.getSlamTime() > 0) {
            this.method_5841().method_12778(BLUE, (Object)false);
            ci.cancel();
        } else {
            this.method_5841().method_12778(BLUE, (Object)charged);
        }
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void trackData(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(CHARGE_TIME, (Object)0);
        builder.method_56912(SLAM_TIME, (Object)0);
        builder.method_56912(ENRAGED, (Object)false);
        builder.method_56912(BLUE, (Object)false);
    }

    @Inject(method={"initGoals"}, at={@At(value="TAIL")})
    private void addNewAttacks(CallbackInfo ci) {
        if (!MobAITweaks.getModConfigValue("wither_rework")) {
            return;
        }
        this.field_6201.method_6277(0, (class_1352)new WitherChargeAttackGoal(this));
        this.field_6201.method_6277(0, (class_1352)new WitherSlamAttackGoal(this));
        this.field_6201.method_6277(1, (class_1352)new WitherStrafeShootGoal(this));
        this.field_6201.method_6280(this.field_6201.method_35115().stream().filter(goal -> goal.method_19058().getClass().getPackageName().startsWith("net.minecraft")).findFirst().get().method_19058());
    }

    @Inject(method={"mobTick"}, at={@At(value="TAIL")})
    private void fixBossBar(CallbackInfo ci) {
        block8: {
            block7: {
                if (this.isReworked && this.field_7093.method_5415() != class_1259.class_1261.field_5796) {
                    this.field_7093.method_5409(class_1259.class_1261.field_5796);
                }
                if (!this.isEnraged()) break block7;
                if (this.method_6032() >= this.method_6063()) {
                    this.field_7093.method_5413((class_2561)this.field_7093.method_5414().method_27661().method_27692(class_124.field_1068));
                    this.method_5841().method_12778(ENRAGED, (Object)false);
                } else {
                    this.field_7093.method_5413((class_2561)this.field_7093.method_5414().method_27661().method_27692(class_124.field_1061));
                }
                if (this.method_37908().method_8608()) break block8;
                for (int i = 0; i < this.field_7091.length; ++i) {
                    if (this.field_7091[i] > 0) {
                        int n = i;
                        this.field_7091[n] = this.field_7091[n] - 4;
                        continue;
                    }
                    if (this.field_7091[i] >= 0) continue;
                    this.field_7091[i] = 0;
                }
                break block8;
            }
            if (!(this.getChargeTime() <= 0 && this.getSlamTime() <= 0 || this.method_37908().method_8608())) {
                for (int i = 0; i < this.field_7091.length; ++i) {
                    this.field_7091[i] = this.method_59922().method_39332(5, 15);
                }
            }
        }
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/boss/WitherEntity;setVelocity(Lnet/minecraft/util/math/Vec3d;)V", shift=At.Shift.AFTER)})
    private void flyUpToChasePlayer(CallbackInfo ci) {
        class_1309 class_13092;
        if (this.isReworked && !this.method_5987() && this.getChargeTime() <= 0 && this.getSlamTime() <= 0 && this.method_6032() <= this.method_6063() && (class_13092 = this.method_5968()) instanceof class_1309) {
            class_1309 target = class_13092;
            double speedMultiplier = this.method_5739((class_1297)target) > 12.0f ? (target.method_6128() ? 3.2 : 1.7) : 1.1;
            double yVelocity = Math.abs(this.method_18798().field_1351);
            this.method_18800(this.method_18798().method_10216() * speedMultiplier, (target.method_23318() > this.method_23320() ? yVelocity : -yVelocity) * (Math.abs(target.method_23318() - this.method_23320()) > 8.0 ? 2.8 : 1.2), this.method_18798().method_10215() * speedMultiplier);
            this.method_5988().method_35111((class_1297)target);
            this.method_5951((class_1297)target, 30.0f, 30.0f);
        }
    }

    @ModifyExpressionValue(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/boss/WitherEntity;shouldRenderOverlay()Z", ordinal=0)})
    private boolean halfHealth(boolean original) {
        return this.isReworked ? this.method_6032() <= this.method_6063() * 0.5f : original;
    }

    @Inject(method={"tickMovement"}, at={@At(value="TAIL")})
    private void fixHealthBarDesync(CallbackInfo ci) {
        if (this.method_5987()) {
            this.field_7093.method_5408(this.method_6032() / this.method_6063());
        }
    }

    @ModifyReturnValue(method={"shouldRenderOverlay"}, at={@At(value="TAIL")})
    private boolean showShield(boolean original) {
        if (!this.isReworked) {
            return original;
        }
        int i = this.getSlamTime();
        if (i > 55) {
            i = 0;
        }
        if (this.getChargeTime() > 0) {
            i = this.getChargeTime();
        }
        return i > 0 && (i > 20 || i / 3 % 2 != 1);
    }

    @Inject(method={"onSummoned"}, at={@At(value="TAIL")})
    private void onSpawned(CallbackInfo ci) {
        if (MobAITweaks.getModConfigValue("bosses_announce_spawn_and_death") && this.method_5682() != null && this.method_5682().method_3760() != null) {
            this.method_5682().method_3760().method_43514((class_2561)class_2561.method_43469((String)"mob-ai-tweaks.boss_summoned", (Object[])new Object[]{this.method_5477().getString()}).method_27661().method_27692(class_124.field_1064), false);
        }
        if (this.isReworked) {
            this.field_7093.method_5409(class_1259.class_1261.field_5796);
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void putNewStuffToNBT(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10569("blockBreakingCooldown", this.field_7082);
        nbt.method_10569("ChargeAttackTime", this.getChargeTime());
        nbt.method_10569("SlamAttackTime", this.getSlamTime());
        nbt.method_10556("IsEnraged", this.isEnraged());
        nbt.method_10556("IsBlue", this.beBlue());
        nbt.method_10539("SkullsCooldown", this.field_7091);
        nbt.method_10539("UntilChargedSkull", this.headAttacksCounter);
        this.isReworked = MobAITweaks.getModConfigValue("wither_rework");
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void getNewStuffFromNBT(class_2487 nbt, CallbackInfo ci) {
        try {
            nbt.method_10554("SkullsCooldown").ifPresent(sc -> {
                for (int i = 0; i < sc.size(); ++i) {
                    this.field_7091[i] = sc.method_68576(i, 0);
                }
            });
            nbt.method_10554("SkullsCooldown").ifPresent(ucs -> {
                for (int i = 0; i < ucs.size(); ++i) {
                    this.headAttacksCounter[i] = ucs.method_68576(i, 0);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        nbt.method_10550("blockBreakingCooldown").ifPresent(i -> {
            this.field_7082 = i;
        });
        nbt.method_10550("ChargeAttackTime").ifPresent(i -> this.method_5841().method_12778(CHARGE_TIME, i));
        nbt.method_10550("SlamAttackTime").ifPresent(i -> this.method_5841().method_12778(SLAM_TIME, i));
        nbt.method_10577("IsEnraged").ifPresent(b -> this.method_5841().method_12778(ENRAGED, b));
        nbt.method_10577("IsBlue").ifPresent(b -> this.method_5841().method_12778(BLUE, b));
    }

    @ModifyConstant(method={"mobTick"}, constant={@Constant(floatValue=10.0f, ordinal=0)})
    private float fixSpawnHealingValue(float constant) {
        return this.method_6063() / 30.0f;
    }

    @ModifyConstant(method={"mobTick"}, constant={@Constant(intValue=20, ordinal=1)})
    private int realHealInterval(int constant) {
        return this.method_5968() == null ? 10 : (this.isEnraged() || !this.isReworked ? constant : this.field_6012 + 1);
    }

    @ModifyReturnValue(method={"createWitherAttributes"}, at={@At(value="TAIL")})
    private static class_5132.class_5133 attribution(class_5132.class_5133 original) {
        if (MobAITweaks.getModConfigValue("wither_rework")) {
            return original.method_26868(class_5134.field_23724, (double)MobAITweaks.getModConfigValue("wither_boss_armor", 12)).method_26868(class_5134.field_23717, (double)MobAITweaks.getModConfigValue("wither_boss_follow_range", 120)).method_26868(class_5134.field_23716, (double)MobAITweaks.getModConfigValue("wither_boss_health", 300));
        }
        return original;
    }

    public boolean method_64397(class_3218 serverWorld, class_1282 source, float amount) {
        this.lastDamageSource = source;
        if (this.field_7082 >= 20) {
            this.field_7082 = 0;
        }
        if (this.method_5679(serverWorld, source) || this.method_6884() > 0 && !source.method_48789(class_8103.field_42242) || source == this.method_48923().method_48812((class_1309)this) || source.method_49708(class_8111.field_42334) || source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337) || source.method_49708(class_8111.field_51566) || source.method_49708(class_8111.field_42338) || source.method_49708(class_8111.field_42350) || source.method_48789(class_8103.field_42257) || source.method_5529() == this || source.method_5529() instanceof class_1528) {
            return false;
        }
        if (source.method_49708(class_8111.field_47737)) {
            amount += (float)this.method_6127().method_26856(class_5134.field_23724) / 3.0f;
        } else if (source.method_49708(class_8111.field_42349)) {
            amount += (float)((int)(amount * 1.15f));
        } else if (source.method_49708(class_8111.field_42321) && this.method_6872()) {
            amount *= 0.5f;
        } else if (!(!MobAITweaks.getModConfigValue("bosses_enrage") || source.method_49708(class_8111.field_42347) || source.method_49708(class_8111.field_44868) || source.method_49708(class_8111.field_44869) || source.method_49708(class_8111.field_42341) || this.isEnraged() || !(amount >= this.method_6063() * 0.2f))) {
            this.method_5841().method_12778(ENRAGED, (Object)true);
            this.method_6025(amount * 2.0f);
            if (this.method_5682() != null && this.method_5682().method_3760() != null) {
                this.method_5682().method_3760().method_43514((class_2561)class_2561.method_43471((String)"mob-ai-tweaks.boss_enraged").method_27661().method_27692(class_124.field_1061), false);
            }
            this.field_7093.method_5413((class_2561)this.field_7093.method_5414().method_27661().method_27692(class_124.field_1061));
            return super.method_64397(serverWorld, source, this.method_6063() * 0.2f);
        }
        return super.method_64397(serverWorld, source, amount);
    }

    public void method_6078(class_1282 damageSource) {
        if (!MobAITweaks.getModConfigValue("wither_death_animation")) {
            super.method_6078(damageSource);
            return;
        }
        this.lastDamageSource = damageSource;
        this.field_7093.method_14091(false);
        this.field_7093.method_14094();
        this.method_5980(null);
        for (int i = 0; i < 3; ++i) {
            this.method_6876(i, 0);
        }
        super.method_6078(damageSource);
    }

    protected void method_6108() {
        int totalDeathTime;
        if (!MobAITweaks.getModConfigValue("wither_death_animation") || this.lastDamageSource.method_49708(class_8111.field_44869)) {
            super.method_6108();
            return;
        }
        this.method_5942().method_6340();
        this.method_55695();
        this.method_18800(-this.method_18798().method_10216(), 0.1, -this.method_18798().method_10215());
        for (class_4135 goal : this.field_6201.method_35115()) {
            goal.method_6270();
        }
        for (class_4135 target : this.field_6185.method_35115()) {
            target.method_6270();
        }
        if (this.method_37908().method_8608()) {
            this.field_6235 = this.method_59922().method_39332(1, 9);
            this.method_37908().method_8406((class_2394)class_2398.field_11236, this.method_23317() + (double)this.method_59922().method_39332(-3, 3), class_3532.method_16436((double)0.5, (double)this.method_23320(), (double)this.method_23318()) + (double)this.method_59922().method_39332(-3, 3), this.method_23321() + (double)this.method_59922().method_39332(-3, 3), 0.0, 0.0, 0.0);
            this.method_37908().method_8406((class_2394)class_2398.field_17909, this.method_23317() + (double)this.method_59922().method_39332(-3, 3), class_3532.method_16436((double)0.5, (double)this.method_23320(), (double)this.method_23318()) + (double)this.method_59922().method_39332(-3, 3), this.method_23321() + (double)this.method_59922().method_39332(-3, 3), 0.0, 0.0, 0.0);
            return;
        }
        if (++this.field_6213 % 10 == 0) {
            class_4135 target;
            if (this.method_6054() && this.lastDamageSource != null && this.lastDamageSource.method_5529() != null && (target = this.method_37908()) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)target;
                this.method_23883(serverWorld, this.lastDamageSource.method_5529());
            }
            this.method_6877(this.method_59922().method_43048(4), this.method_23317() + (double)this.method_59922().method_39332(-100, 100), this.method_23318() + (double)this.method_59922().method_39332(-100, 100), this.method_23321() + (double)this.method_59922().method_39332(-100, 100), this.method_59922().method_43056());
        }
        if (this.field_6213 == (totalDeathTime = 200) - 1) {
            class_3414 class_34142;
            this.method_37908().method_46407((class_1297)this, this.method_48923().method_48819((class_1297)this, (class_1297)this), new class_5362(), this.method_19538(), 8.0f, false, class_1937.class_7867.field_40890);
            if (!this.method_5701()) {
                this.method_37908().method_8474(1022, this.method_24515(), 0);
            }
            if ((class_34142 = this.method_6002()) instanceof class_3414) {
                class_3414 sound = class_34142;
                this.method_5783(sound, this.method_6107() * 1.3f, this.method_6017());
            }
        } else if (!this.method_31481() && this.field_6213 >= totalDeathTime) {
            if (this.lastDamageSource != null && this.lastDamageSource.method_5529() != null && this.method_5682() != null) {
                this.method_16080(this.method_5682().method_3847(this.method_37908().method_27983()), this.lastDamageSource);
            }
            this.method_37908().method_43275((class_1297)this, (class_6880)class_5712.field_37676, this.method_19538());
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    protected void method_16080(class_3218 world, class_1282 damageSource) {
        if (!MobAITweaks.getModConfigValue("wither_death_animation") || this.isEnraged() || this.field_6213 >= 200) {
            super.method_16080(world, damageSource);
        }
    }

    protected void method_5710(float yaw, float pitch) {
        super.method_5710((float)this.field_45123, pitch);
    }

    @Override
    public void setChargeTime(int i) {
        if (i >= 20 && this.method_5968() != null) {
            this.field_7082 = 0;
        }
        this.method_5841().method_12778(CHARGE_TIME, (Object)i);
    }

    @Override
    public void setSlamTime(int i) {
        if (i >= 20 && this.method_5968() != null && !this.method_6057((class_1297)this.method_5968())) {
            this.field_7082 = 0;
        }
        this.method_5841().method_12778(SLAM_TIME, (Object)i);
    }

    @Override
    public int getChargeTime() {
        return (Integer)this.method_5841().method_12789(CHARGE_TIME);
    }

    @Override
    public int getSlamTime() {
        return (Integer)this.method_5841().method_12789(SLAM_TIME);
    }

    @Override
    public boolean isEnraged() {
        return (Boolean)this.method_5841().method_12789(ENRAGED);
    }

    @Override
    public boolean beBlue() {
        return this.method_6032() <= this.method_6063() * 0.1666f || (Boolean)this.method_5841().method_12789(BLUE) != false;
    }
}

