/*
 * Decompiled with CFR 0.152.
 */
package dev.enderman.minecraft.plugins.fire.better.enchantments.fire.protection;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0006\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"getFireProtectionLevel", "", "Lorg/bukkit/entity/Entity;", "getMaxFireProtectionLevel", "getFireProtectionFactor", "", "Lorg/bukkit/inventory/ItemStack;", "project"})
@SourceDebugExtension(value={"SMAP\nFireProtectionLevel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FireProtectionLevel.kt\ndev/enderman/minecraft/plugins/fire/better/enchantments/fire/protection/FireProtectionLevelKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1863#2,2:42\n*S KotlinDebug\n*F\n+ 1 FireProtectionLevel.kt\ndev/enderman/minecraft/plugins/fire/better/enchantments/fire/protection/FireProtectionLevelKt\n*L\n13#1:42,2\n*E\n"})
public final class FireProtectionLevelKt {
    public static final int getFireProtectionLevel(@NotNull Entity $this$getFireProtectionLevel) {
        int total;
        block2: {
            Intrinsics.checkNotNullParameter($this$getFireProtectionLevel, "<this>");
            if (!($this$getFireProtectionLevel instanceof LivingEntity)) {
                return 0;
            }
            total = 0;
            Object object = ((LivingEntity)$this$getFireProtectionLevel).getEquipment();
            if (object == null || (object = object.getArmorContents()) == null || (object = ArraysKt.filterNotNull(object)) == null) break block2;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                if (!it.hasItemMeta()) continue;
                total += it.getEnchantmentLevel(Enchantment.FIRE_PROTECTION);
            }
        }
        return total;
    }

    public static final int getMaxFireProtectionLevel(@NotNull Entity $this$getMaxFireProtectionLevel) {
        ItemStack[] itemStackArray;
        Intrinsics.checkNotNullParameter($this$getMaxFireProtectionLevel, "<this>");
        if (!($this$getMaxFireProtectionLevel instanceof LivingEntity)) {
            return 0;
        }
        return Enchantment.FIRE_PROTECTION.getMaxLevel() * ((itemStackArray = ((LivingEntity)$this$getMaxFireProtectionLevel).getEquipment()) != null && (itemStackArray = itemStackArray.getArmorContents()) != null ? itemStackArray.length : 0);
    }

    public static final double getFireProtectionFactor(@NotNull Entity $this$getFireProtectionFactor) {
        Intrinsics.checkNotNullParameter($this$getFireProtectionFactor, "<this>");
        if (!($this$getFireProtectionFactor instanceof LivingEntity)) {
            return 0.0;
        }
        return (double)FireProtectionLevelKt.getFireProtectionLevel($this$getFireProtectionFactor) / (double)FireProtectionLevelKt.getMaxFireProtectionLevel($this$getFireProtectionFactor);
    }

    public static final int getFireProtectionLevel(@NotNull ItemStack $this$getFireProtectionLevel) {
        Intrinsics.checkNotNullParameter($this$getFireProtectionLevel, "<this>");
        return $this$getFireProtectionLevel.getEnchantmentLevel(Enchantment.FIRE_PROTECTION);
    }

    public static final double getFireProtectionFactor(@NotNull ItemStack $this$getFireProtectionFactor) {
        Intrinsics.checkNotNullParameter($this$getFireProtectionFactor, "<this>");
        return (double)FireProtectionLevelKt.getFireProtectionLevel($this$getFireProtectionFactor) / (double)Enchantment.FIRE_PROTECTION.getMaxLevel();
    }
}

