/*
 * Decompiled with CFR 0.152.
 */
package dev.enderman.minecraft.plugins.fire.better.events.listeners;

import dev.enderman.minecraft.plugins.fire.better.enchantments.fire.protection.FireProtectionLevelKt;
import dev.enderman.minecraft.plugins.fire.better.entity.ExtinguishKt;
import dev.enderman.minecraft.plugins.fire.better.events.fire.IsFireDamageKt;
import dev.enderman.minecraft.plugins.fire.better.utility.armor.LoopArmorKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/enderman/minecraft/plugins/fire/better/events/listeners/EntityBurnListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "(Lorg/bukkit/plugin/java/JavaPlugin;)V", "ignoreFireKey", "Lorg/bukkit/NamespacedKey;", "previousDamageKey", "onEntityBurn", "", "event", "Lorg/bukkit/event/entity/EntityDamageEvent;", "project"})
@SourceDebugExtension(value={"SMAP\nEntityBurnListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityBurnListener.kt\ndev/enderman/minecraft/plugins/fire/better/events/listeners/EntityBurnListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1863#2,2:110\n*S KotlinDebug\n*F\n+ 1 EntityBurnListener.kt\ndev/enderman/minecraft/plugins/fire/better/events/listeners/EntityBurnListener\n*L\n61#1:110,2\n*E\n"})
public final class EntityBurnListener
implements Listener {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final NamespacedKey ignoreFireKey;
    @NotNull
    private final NamespacedKey previousDamageKey;

    public EntityBurnListener(@NotNull JavaPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.ignoreFireKey = new NamespacedKey((Plugin)this.plugin, "ignore_fire");
        this.previousDamageKey = new NamespacedKey((Plugin)this.plugin, "previous_durability");
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public final void onEntityBurn(@NotNull EntityDamageEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.isCancelled()) {
            return;
        }
        if (!IsFireDamageKt.isFireDamage(event)) {
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(entity, "getEntity(...)");
        Entity entity2 = entity;
        if (entity2 instanceof Creeper && !((Creeper)entity2).isPowered()) {
            ((Creeper)entity2).ignite();
        }
        PersistentDataContainer persistentDataContainer = entity2.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer container = persistentDataContainer;
        if (Intrinsics.areEqual(container.get(this.ignoreFireKey, PersistentDataType.BOOLEAN), true)) {
            container.remove(this.ignoreFireKey);
            return;
        }
        entity2.setFireTicks(10000);
        List list = entity2.getPassengers();
        Intrinsics.checkNotNullExpressionValue(list, "getPassengers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            it.setFireTicks(10000);
        }
        Entity entity3 = entity2.getVehicle();
        if (entity3 != null) {
            entity3.setFireTicks(10000);
        }
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        double factor = FireProtectionLevelKt.getFireProtectionFactor(entity2);
        if (factor == 1.0) {
            event.setCancelled(true);
            ExtinguishKt.extinguish(entity2);
            return;
        }
        if (factor == 0.0) {
            return;
        }
        double d = event.getFinalDamage();
        double toDeal = d * (1.0 - factor);
        event.setCancelled(true);
        container.set(this.ignoreFireKey, PersistentDataType.BOOLEAN, (Object)true);
        LoopArmorKt.loopDamageableArmorMeta(entity2, arg_0 -> EntityBurnListener.onEntityBurn$lambda$1(this, arg_0));
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> EntityBurnListener.onEntityBurn$lambda$3(entity2, this), 1L);
        ((LivingEntity)entity2).damage(toDeal, event.getDamageSource());
    }

    private static final void onEntityBurn$lambda$1(EntityBurnListener this$0, Damageable meta) {
        Intrinsics.checkNotNullParameter(meta, "meta");
        meta.getPersistentDataContainer().set(this$0.previousDamageKey, PersistentDataType.INTEGER, (Object)meta.getDamage());
    }

    private static final void onEntityBurn$lambda$3$lambda$2(EntityBurnListener this$0, Damageable meta, ItemStack item) {
        Intrinsics.checkNotNullParameter(meta, "meta");
        Intrinsics.checkNotNullParameter(item, "item");
        double itemFactor = FireProtectionLevelKt.getFireProtectionFactor(item);
        if (Random.Default.nextDouble() > itemFactor) {
            return;
        }
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer itemContainer = persistentDataContainer;
        Integer n = (Integer)itemContainer.get(this$0.previousDamageKey, PersistentDataType.INTEGER);
        if (n == null) {
            return;
        }
        int previousDamage = n;
        itemContainer.remove(this$0.previousDamageKey);
        meta.setDamage(previousDamage);
    }

    private static final void onEntityBurn$lambda$3(Entity $entity, EntityBurnListener this$0) {
        LoopArmorKt.loopDamageableArmor($entity, (arg_0, arg_1) -> EntityBurnListener.onEntityBurn$lambda$3$lambda$2(this$0, arg_0, arg_1));
    }
}

