/*
 * Decompiled with CFR 0.152.
 */
package dev.enderman.minecraft.plugins.fire.better.events.listeners;

import dev.enderman.minecraft.plugins.fire.better.entity.ExtinguishKt;
import dev.enderman.minecraft.plugins.fire.better.events.fire.IsFireDamageKt;
import dev.enderman.minecraft.plugins.fire.better.events.listeners.EntityBurnListenerKt;
import dev.enderman.minecraft.plugins.fire.better.events.listeners.EntityCombustListenerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0003J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0003\u00a8\u0006\f"}, d2={"Ldev/enderman/minecraft/plugins/fire/better/events/listeners/EntityCombustListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onEntityCombust", "", "event", "Lorg/bukkit/event/entity/EntityCombustEvent;", "onFireImmuneCombust", "onEntityBurn", "Lorg/bukkit/event/entity/EntityDamageEvent;", "onNonFlammableBurn", "project"})
public final class EntityCombustListener
implements Listener {
    @EventHandler
    private final void onEntityCombust(EntityCombustEvent event) {
        Entity entity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(entity, "getEntity(...)");
        Entity entity2 = entity;
        EntityType entityType = entity2.getType();
        Intrinsics.checkNotNullExpressionValue(entityType, "getType(...)");
        EntityType type = entityType;
        if (!EntityCombustListenerKt.getExtremeCombustionEntities().contains(type)) {
            return;
        }
        entity2.remove();
    }

    @EventHandler
    private final void onFireImmuneCombust(EntityCombustEvent event) {
        Entity entity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(entity, "getEntity(...)");
        Entity entity2 = entity;
        if (!EntityBurnListenerKt.isImmuneToFire(entity2)) {
            return;
        }
        ExtinguishKt.extinguish(entity2);
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOW)
    private final void onEntityBurn(EntityDamageEvent event) {
        if (!IsFireDamageKt.isFireDamage(event)) {
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(entity, "getEntity(...)");
        Entity entity2 = entity;
        if (!EntityBurnListenerKt.isImmuneToFire(entity2)) {
            return;
        }
        ExtinguishKt.extinguish(entity2);
        event.setCancelled(true);
    }

    @EventHandler
    private final void onNonFlammableBurn(EntityDamageEvent event) {
        if (!IsFireDamageKt.isFireDamage(event)) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.FIRE_TICK) {
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(entity, "getEntity(...)");
        Entity entity2 = entity;
        if (!EntityCombustListenerKt.getNonFlammableEntities().contains(entity2.getType())) {
            return;
        }
        ExtinguishKt.extinguish(entity2);
        event.setCancelled(true);
    }
}

