/*
 * Decompiled with CFR 0.152.
 */
package dev.enderman.minecraft.plugins.fire.better.events.listeners;

import dev.enderman.minecraft.plugins.fire.better.InflamityPluginKt;
import dev.enderman.minecraft.plugins.fire.better.events.listeners.EntityIgniteListenerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.BooleanUtils;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Ldev/enderman/minecraft/plugins/fire/better/events/listeners/EntityIgniteListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onEntityIgnite", "", "event", "Lorg/bukkit/event/player/PlayerInteractAtEntityEvent;", "project"})
public final class EntityIgniteListener
implements Listener {
    @EventHandler
    public final void onEntityIgnite(@NotNull PlayerInteractAtEntityEvent event) {
        boolean offHandHolding;
        boolean atLeastOneEmpty;
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.getRightClicked();
        Intrinsics.checkNotNullExpressionValue(entity, "getRightClicked(...)");
        Entity entity2 = entity;
        if (EntityIgniteListenerKt.getNonIgnitableEntities().contains(entity2.getType())) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        ItemStack itemStack = player2.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
        ItemStack heldItem = itemStack;
        ItemStack itemStack2 = player2.getInventory().getItemInOffHand();
        Intrinsics.checkNotNullExpressionValue(itemStack2, "getItemInOffHand(...)");
        ItemStack otherItem = itemStack2;
        boolean bl = atLeastOneEmpty = heldItem.isEmpty() || otherItem.isEmpty();
        if (!atLeastOneEmpty) {
            return;
        }
        boolean mainHandHolding = heldItem.getType() == Material.FLINT_AND_STEEL;
        boolean[] blArray = new boolean[]{mainHandHolding, offHandHolding = otherItem.getType() == Material.FLINT_AND_STEEL};
        boolean oneHandHolding = BooleanUtils.xor((boolean[])blArray);
        if (!oneHandHolding) {
            return;
        }
        entity2.getWorld().playSound(entity2.getLocation(), Sound.ITEM_FLINTANDSTEEL_USE, 1.0f, 1.0f);
        if (mainHandHolding) {
            player2.swingMainHand();
        } else {
            player2.swingOffHand();
        }
        entity2.setFireTicks(10000);
        if (!InflamityPluginKt.getGameModesWithConsequences().contains(player2.getGameMode())) {
            return;
        }
        ItemStack item = mainHandHolding ? heldItem : otherItem;
        ItemMeta itemMeta = item.getItemMeta();
        Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.Damageable");
        Damageable meta = (Damageable)itemMeta;
        int damage = meta.getDamage();
        short maxDamage = Material.FLINT_AND_STEEL.getMaxDurability();
        if (damage == maxDamage - 1) {
            entity2.getWorld().playSound(entity2.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        }
        item.damage(1, (LivingEntity)player2);
        if (entity2 instanceof Mob && InflamityPluginKt.getGameModesWithConsequences().contains(player2.getGameMode())) {
            ((Mob)entity2).setTarget((LivingEntity)player2);
        }
    }
}

