/*
 * Decompiled with CFR 0.152.
 */
package dev.enderman.minecraft.plugins.fire.better.events.listeners;

import dev.enderman.minecraft.plugins.fire.better.entity.IsOnFireKt;
import dev.enderman.minecraft.plugins.fire.better.events.listeners.EntityBurnListenerKt;
import dev.enderman.minecraft.plugins.fire.better.events.listeners.EntityCombustListenerKt;
import dev.enderman.minecraft.plugins.fire.better.fire.FireSpreadKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Candle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.ProjectileSource;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0003\u00a8\u0006\n"}, d2={"Ldev/enderman/minecraft/plugins/fire/better/events/listeners/FireProjectileListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onProjectileShoot", "", "event", "Lorg/bukkit/event/entity/ProjectileLaunchEvent;", "onProjectileHit", "Lorg/bukkit/event/entity/ProjectileHitEvent;", "project"})
public final class FireProjectileListener
implements Listener {
    @EventHandler
    private final void onProjectileShoot(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(projectile, "getEntity(...)");
        Projectile projectile2 = projectile;
        ProjectileSource shooter = projectile2.getShooter();
        if (!(shooter instanceof Entity)) {
            return;
        }
        if (!IsOnFireKt.isOnFire((Entity)shooter)) {
            return;
        }
        if (EntityBurnListenerKt.getFireImmuneEntities().contains(projectile2.getType())) {
            return;
        }
        if (EntityCombustListenerKt.getExtremeCombustionEntities().contains(projectile2.getType())) {
            projectile2.remove();
            return;
        }
        projectile2.setFireTicks(10000);
    }

    @EventHandler
    private final void onProjectileHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(projectile, "getEntity(...)");
        Projectile projectile2 = projectile;
        if (!IsOnFireKt.isOnFire((Entity)projectile2)) {
            return;
        }
        Block block = event.getHitBlock();
        if (block == null) {
            return;
        }
        Block hitBlock = block;
        BlockData blockData = hitBlock.getBlockData();
        Intrinsics.checkNotNullExpressionValue(blockData, "getBlockData(...)");
        BlockData data = blockData;
        Material material = hitBlock.getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        Material type = material;
        String name = type.name();
        if (StringsKt.endsWith$default(name, "_CANDLE", false, 2, null)) {
            try {
                ((Candle)data).setLit(true);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        hitBlock.setBlockData(data);
        FireSpreadKt.attemptFireSpread((Entity)projectile2);
        Block block2 = projectile2.getLocation().getBlock();
        Intrinsics.checkNotNullExpressionValue(block2, "getBlock(...)");
        FireSpreadKt.attemptFireSpread(block2);
        FireSpreadKt.attemptFireSpread(hitBlock);
    }
}

