/*
 * Decompiled with CFR 0.152.
 */
package dev.enderman.minecraft.plugins.fire.better.fire;

import dev.enderman.minecraft.plugins.fire.better.fire.FireSpreadKt;
import dev.enderman.minecraft.plugins.fire.better.utility.block.BlockNeighboursKt;
import dev.enderman.minecraft.plugins.fire.better.utility.box.BoundingBoxIteratorKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\n\u0010\n\u001a\u00020\b*\u00020\t\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\t\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u000e"}, d2={"infiniteBurnBlocks", "", "Lorg/bukkit/Material;", "getInfiniteBurnBlocks", "()Ljava/util/List;", "liquidBlocks", "getLiquidBlocks", "supportsFire", "", "Lorg/bukkit/block/Block;", "canBurn", "attemptFireSpread", "", "Lorg/bukkit/entity/Entity;", "project"})
@SourceDebugExtension(value={"SMAP\nFireSpread.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FireSpread.kt\ndev/enderman/minecraft/plugins/fire/better/fire/FireSpreadKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1755#2,3:47\n*S KotlinDebug\n*F\n+ 1 FireSpread.kt\ndev/enderman/minecraft/plugins/fire/better/fire/FireSpreadKt\n*L\n28#1:47,3\n*E\n"})
public final class FireSpreadKt {
    @NotNull
    private static final List<Material> infiniteBurnBlocks;
    @NotNull
    private static final List<Material> liquidBlocks;

    @NotNull
    public static final List<Material> getInfiniteBurnBlocks() {
        return infiniteBurnBlocks;
    }

    @NotNull
    public static final List<Material> getLiquidBlocks() {
        return liquidBlocks;
    }

    public static final boolean supportsFire(@NotNull Block $this$supportsFire) {
        boolean bl;
        boolean canBurn;
        block4: {
            boolean canBeReplaced;
            Intrinsics.checkNotNullParameter($this$supportsFire, "<this>");
            List<Block> neighbours = BlockNeighboursKt.getNeighbours($this$supportsFire);
            boolean bl2 = canBeReplaced = !$this$supportsFire.getType().isCollidable() && !liquidBlocks.contains($this$supportsFire.getType());
            if (!canBeReplaced) {
                return false;
            }
            canBurn = FireSpreadKt.canBurn($this$supportsFire);
            Iterable $this$any$iv = neighbours;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Block it = (Block)element$iv;
                    boolean bl3 = false;
                    if (!FireSpreadKt.canBurn(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean oneNeighbourFlammable = bl;
        return canBurn || oneNeighbourFlammable;
    }

    public static final boolean canBurn(@NotNull Block $this$canBurn) {
        Intrinsics.checkNotNullParameter($this$canBurn, "<this>");
        return $this$canBurn.getType().isFlammable() || $this$canBurn.getType().isFuel() || $this$canBurn.getType().isBurnable() || infiniteBurnBlocks.contains($this$canBurn.getType());
    }

    public static final void attemptFireSpread(@NotNull Entity $this$attemptFireSpread) {
        Intrinsics.checkNotNullParameter($this$attemptFireSpread, "<this>");
        BoundingBoxIteratorKt.loopBoundingBox($this$attemptFireSpread, attemptFireSpread.1.INSTANCE);
    }

    public static final void attemptFireSpread(@NotNull Block $this$attemptFireSpread) {
        Intrinsics.checkNotNullParameter($this$attemptFireSpread, "<this>");
        if (FireSpreadKt.supportsFire($this$attemptFireSpread)) {
            $this$attemptFireSpread.setType(Material.FIRE);
        }
    }

    static {
        Material[] materialArray = new Material[]{Material.NETHERRACK, Material.WARPED_NYLIUM, Material.CRIMSON_NYLIUM};
        infiniteBurnBlocks = CollectionsKt.listOfNotNull(materialArray);
        materialArray = new Material[]{Material.LAVA, Material.WATER};
        liquidBlocks = CollectionsKt.listOfNotNull(materialArray);
    }
}

