/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.seedlessplace;

import com.mrbysco.seedlessplace.SeedlessPlaceMod;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class SeedlessConfig {
    private static final Map<Item, Item> SEED_REPLICA_MAP = new HashMap<Item, Item>();
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        SeedlessConfig.refreshCache(config.getType());
    }

    private static void refreshCache(ModConfig.Type type) {
        if (type == ModConfig.Type.COMMON) {
            for (String entry : (List)SeedlessConfig.COMMON.seedReplicas.get()) {
                String[] parts = entry.split(",");
                if (parts.length == 2) {
                    try {
                        ResourceLocation crop = ResourceLocation.m_135820_((String)parts[0]);
                        if (crop == null) {
                            SeedlessPlaceMod.LOGGER.error("Invalid crop item in seed replica entry: {}", (Object)entry);
                            continue;
                        }
                        Item cropItem = (Item)ForgeRegistries.ITEMS.getValue(crop);
                        ResourceLocation seed = ResourceLocation.m_135820_((String)parts[1]);
                        if (seed == null) {
                            SeedlessPlaceMod.LOGGER.error("Invalid seed item in seed replica entry: {}", (Object)entry);
                            continue;
                        }
                        Item seedItem = (Item)ForgeRegistries.ITEMS.getValue(seed);
                        if (cropItem == null || seedItem == null) continue;
                        SEED_REPLICA_MAP.put(cropItem, seedItem);
                    }
                    catch (Exception e) {
                        SeedlessPlaceMod.LOGGER.error("Error parsing seed replica entry: {}", (Object)entry, (Object)e);
                    }
                    continue;
                }
                SeedlessPlaceMod.LOGGER.error("Invalid seed replica entry: {}", (Object)entry);
            }
        }
    }

    @NotNull
    public static ItemStack getReplica(ItemStack stack) {
        if (SEED_REPLICA_MAP.containsKey(stack.m_41720_())) {
            return SEED_REPLICA_MAP.get(stack.m_41720_()).m_7968_();
        }
        return ItemStack.f_41583_;
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        SeedlessPlaceMod.LOGGER.debug("Loaded A Seedless Place's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        SeedlessPlaceMod.LOGGER.warn("Seedless A Place's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> seedReplicas;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Seedless settings").push("seedless");
            String[] conversions = new String[]{"minecraft:wheat,minecraft:wheat_seeds", "minecraft:beetroot,minecraft:beetroot_seeds", "minecraft:melon_slice,minecraft:melon_seeds"};
            this.seedReplicas = builder.comment(new String[]{"A list of crop item to seed item conversions in the format 'crop_item,seed_item'.", "Example: 'minecraft:wheat,minecraft:wheat_seeds' makes wheat behave like wheat seeds when placed.", "Add your own conversions as needed. Default is wheat to wheat seeds.", "Note: Use the item registry names."}).defineListAllowEmpty("seedReplicas", () -> List.of(conversions), o -> o instanceof String);
            builder.pop();
        }
    }
}

