/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.seedlessplace;

import com.mojang.logging.LogUtils;
import com.mrbysco.seedlessplace.SeedlessConfig;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="seedlessplace")
public class SeedlessPlaceMod {
    public static final String MOD_ID = "seedlessplace";
    public static final Logger LOGGER = LogUtils.getLogger();

    public SeedlessPlaceMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SeedlessConfig.commonSpec, "aseedlessplace.toml");
        eventBus.register(SeedlessConfig.class);
        MinecraftForge.EVENT_BUS.addListener(this::onRightClick);
    }

    private void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemStack = event.getItemStack();
        ItemStack replica = SeedlessConfig.getReplica(itemStack);
        if (replica.m_41619_()) {
            return;
        }
        UseOnContext context = new UseOnContext(event.getLevel(), event.getEntity(), event.getHand(), replica, event.getHitVec());
        InteractionResult result = replica.m_41661_(context);
        if (result.m_19077_()) {
            itemStack.m_41774_(1);
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }
}

