/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.jei;

import com.github.minecraftschurlimods.bibliocraft.client.jei.SpriteWidget;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableRecipe;
import com.github.minecraftschurlimods.bibliocraft.init.BCItems;
import com.github.minecraftschurlimods.bibliocraft.init.BCRecipes;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.Translations;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;

public class PrintingTableRecipeCategory
extends AbstractRecipeCategory<RecipeHolder<PrintingTableRecipe>> {
    public static final RecipeType<RecipeHolder<PrintingTableRecipe>> TYPE = RecipeType.createRecipeHolderType((ResourceLocation)BCRecipes.PRINTING_TABLE.getId());
    private static final ResourceLocation LEVEL = BCUtil.bcLoc("level");
    private static final int LEVEL_X = 98;
    private static final int LEVEL_Y = 24;
    private static final int LEVEL_SIZE = 9;

    public PrintingTableRecipeCategory(IGuiHelper guiHelper) {
        super(TYPE, Translations.PRINTING_TABLE_CATEGORY, guiHelper.createDrawableItemLike(BCItems.PRINTING_TABLE), 147, 54);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<PrintingTableRecipe> holder, IFocusGroup focuses) {
        PrintingTableRecipe recipe = (PrintingTableRecipe)holder.value();
        Pair<List<Ingredient>, Ingredient> ingredients = recipe.getDisplayIngredients();
        List left = (List)ingredients.getFirst();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                IRecipeSlotBuilder slot = builder.addInputSlot(j * 18 + 1, i * 18 + 1).setStandardSlotBackground();
                if (i * 3 + j >= left.size()) continue;
                slot.addIngredients((Ingredient)left.get(i * 3 + j));
            }
        }
        builder.addInputSlot(74, 19).setStandardSlotBackground().addIngredients((Ingredient)ingredients.getSecond());
        builder.addOutputSlot(126, 19).setOutputSlotBackground().addItemStack(recipe.getResultItem());
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<PrintingTableRecipe> holder, IFocusGroup focuses) {
        super.createRecipeExtras(builder, holder, focuses);
        PrintingTableRecipe recipe = (PrintingTableRecipe)holder.value();
        builder.addRecipePlusSign().setPosition(57, 21);
        builder.addAnimatedRecipeArrow(recipe.getDuration()).setPosition(95, 20);
        ((ITextWidget)builder.addText((FormattedText)Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{recipe.getDuration() / 20}), this.getWidth() - 57, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.TOP)).setTextAlignment(HorizontalAlignment.RIGHT).setColor(-8355712);
        ((ITextWidget)builder.addText((FormattedText)Component.translatable((String)"gui.bibliocraft.printing_table.mode", (Object[])new Object[]{Component.translatable((String)recipe.getMode().getTranslationKey())}), this.getWidth() - 57, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM)).setTextAlignment(HorizontalAlignment.RIGHT).setColor(-8355712);
        if (recipe.canHaveExperienceCost()) {
            builder.addWidget((IRecipeWidget)new SpriteWidget(LEVEL, 98, 24, 10, 9, 9));
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<PrintingTableRecipe> recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, recipe, recipeSlotsView, mouseX, mouseY);
        if (mouseX >= 98.0 && mouseX < 107.0 && mouseY >= 24.0 && mouseY < 33.0) {
            tooltip.add((FormattedText)Translations.REQUIRES_EXPERIENCE);
        }
    }
}

