/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.model;

import com.github.minecraftschurlimods.bibliocraft.client.model.DynamicBlockModel;
import com.github.minecraftschurlimods.bibliocraft.content.table.TableBlock;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class TableModel
extends DynamicBlockModel {
    public static final IGeometryLoader<Geometry> LOADER = (jsonObject, context) -> {
        HashMap<TableBlock.Type, BlockModel> map = new HashMap<TableBlock.Type, BlockModel>();
        for (TableBlock.Type type : TableBlock.Type.values()) {
            map.put(type, (BlockModel)context.deserialize((JsonElement)GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)type.getSerializedName()), BlockModel.class));
        }
        return new Geometry(map);
    };
    private final Map<TableBlock.Type, BakedModel> baseMap;

    public TableModel(boolean useAmbientOcclusion, boolean isGui3d, boolean usesBlockLight, TextureAtlasSprite particle, Map<TableBlock.Type, BakedModel> baseMap) {
        super(useAmbientOcclusion, isGui3d, usesBlockLight, particle);
        this.baseMap = baseMap;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        TableBlock.Type type = TableBlock.Type.NONE;
        if (state != null && state.hasProperty(TableBlock.TYPE)) {
            type = (TableBlock.Type)((Object)state.getValue(TableBlock.TYPE));
        }
        return this.baseMap.get(type).getQuads(state, side, rand, extraData, renderType);
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        return this.baseMap.get(TableBlock.Type.NONE).applyTransform(transformType, poseStack, applyLeftHandTransform);
    }

    public static class Geometry
    implements IUnbakedGeometry<Geometry> {
        private final Map<TableBlock.Type, BlockModel> baseMap;

        public Geometry(Map<TableBlock.Type, BlockModel> baseMap) {
            this.baseMap = baseMap;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
            SimpleModelState simpleState = new SimpleModelState(modelState.getRotation(), modelState.isUvLocked());
            boolean useBlockLight = context.useBlockLight();
            HashMap<TableBlock.Type, BakedModel> newBaseMap = new HashMap<TableBlock.Type, BakedModel>();
            this.baseMap.forEach((arg_0, arg_1) -> Geometry.lambda$bake$0(newBaseMap, baker, spriteGetter, (ModelState)simpleState, useBlockLight, arg_0, arg_1));
            return new TableModel(context.useAmbientOcclusion(), context.isGui3d(), useBlockLight, spriteGetter.apply(context.getMaterial("particle")), newBaseMap);
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.baseMap.forEach((k, v) -> v.resolveParents(modelGetter));
        }

        private static /* synthetic */ void lambda$bake$0(Map newBaseMap, ModelBaker baker, Function spriteGetter, ModelState simpleState, boolean useBlockLight, TableBlock.Type k, BlockModel v) {
            newBaseMap.put(k, v.bake(baker, v, spriteGetter, simpleState, useBlockLight));
        }
    }

    public static class Builder
    extends CustomLoaderBuilder<BlockModelBuilder> {
        private final Map<TableBlock.Type, JsonObject> modelMap = new HashMap<TableBlock.Type, JsonObject>();
        private ResourceLocation particle;

        public Builder(BlockModelBuilder parent, ExistingFileHelper existingFileHelper) {
            super(BCUtil.bcLoc("table"), (ModelBuilder)parent, existingFileHelper, false);
        }

        public Builder withModelForType(TableBlock.Type type, JsonObject model) {
            this.modelMap.put(type, model);
            return this;
        }

        public Builder withParticle(ResourceLocation particle) {
            this.particle = particle;
            return this;
        }

        public JsonObject toJson(JsonObject json) {
            if (this.particle == null) {
                throw new IllegalStateException("Block particle was not specified!");
            }
            JsonObject textures = new JsonObject();
            textures.addProperty("particle", this.particle.toString());
            json.add("textures", (JsonElement)textures);
            this.modelMap.forEach((k, v) -> json.add(k.getSerializedName(), (JsonElement)v));
            return super.toJson(json);
        }
    }
}

