/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen;

import com.github.minecraftschurlimods.bibliocraft.client.widget.SpriteButton;
import com.github.minecraftschurlimods.bibliocraft.content.clipboard.CheckboxState;
import com.github.minecraftschurlimods.bibliocraft.content.clipboard.ClipboardContent;
import com.github.minecraftschurlimods.bibliocraft.content.clipboard.ClipboardSyncPacket;
import com.github.minecraftschurlimods.bibliocraft.init.BCDataComponents;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ClipboardScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = BCUtil.bcLoc("textures/gui/clipboard.png");
    private final ItemStack stack;
    private final InteractionHand hand;
    private ClipboardContent data;
    private final CheckboxButton[] checkboxes = new CheckboxButton[9];
    private final EditBox[] lines = new EditBox[9];
    private EditBox titleBox;
    private PageButton forwardButton;
    private PageButton backButton;

    public ClipboardScreen(ItemStack stack, InteractionHand hand) {
        super(stack.getHoverName());
        this.stack = stack;
        this.hand = hand;
        this.data = (ClipboardContent)stack.get(BCDataComponents.CLIPBOARD_CONTENT);
    }

    public void onClose() {
        super.onClose();
        this.stack.set(BCDataComponents.CLIPBOARD_CONTENT, (Object)this.data);
        PacketDistributor.sendToServer((CustomPacketPayload)new ClipboardSyncPacket(this.data, this.hand), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void init() {
        int x = (this.width - 192) / 2;
        this.titleBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.getMinecraft().font, x + 57, 14, 72, 8, (Component)Component.empty()));
        this.titleBox.setTextColor(0);
        this.titleBox.setBordered(false);
        this.titleBox.setTextShadow(false);
        this.titleBox.setResponder(e -> {
            this.data = this.data.setTitle((String)e);
        });
        for (int i = 0; i < 9; ++i) {
            int j = i;
            this.checkboxes[i] = (CheckboxButton)this.addRenderableWidget((GuiEventListener)new CheckboxButton(x + 30, 15 * i + 26, e -> {
                ArrayList<ClipboardContent.Page> pages = new ArrayList<ClipboardContent.Page>(this.data.pages());
                ClipboardContent.Page page = (ClipboardContent.Page)pages.get(this.data.active());
                ArrayList<CheckboxState> checkboxes = new ArrayList<CheckboxState>(page.checkboxes());
                checkboxes.set(j, ((CheckboxButton)e).getState());
                pages.set(this.data.active(), page.setCheckboxes(checkboxes));
                this.data = this.data.setPages(pages);
            }));
            this.lines[i] = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.getMinecraft().font, x + 45, 15 * i + 28, 109, 8, (Component)Component.empty()));
            this.lines[i].setTextColor(0);
            this.lines[i].setBordered(false);
            this.lines[i].setTextShadow(false);
            this.lines[i].setResponder(e -> {
                ArrayList<ClipboardContent.Page> pages = new ArrayList<ClipboardContent.Page>(this.data.pages());
                ClipboardContent.Page page = (ClipboardContent.Page)pages.get(this.data.active());
                ArrayList<String> lines = new ArrayList<String>(page.lines());
                lines.set(j, (String)e);
                pages.set(this.data.active(), page.setLines(lines));
                this.data = this.data.setPages(pages);
            });
        }
        this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(x + 116, 159, true, $ -> {
            this.data = this.data.nextPage();
            this.updateContents();
        }, false));
        this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(x + 43, 159, false, $ -> {
            this.data = this.data.prevPage();
            this.updateContents();
        }, false));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, $ -> this.onClose()).bounds(this.width / 2 - 100, 196, 200, 20).build());
        this.updateContents();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.blit(BACKGROUND, (this.width - 192) / 2, 2, 0, 0, 192, 192);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY < 0.0 && this.forwardButton.visible) {
            this.forwardButton.onPress();
            return true;
        }
        if (scrollY > 0.0 && this.backButton.visible) {
            this.backButton.onPress();
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return switch (keyCode) {
            case 266 -> {
                this.backButton.onPress();
                yield true;
            }
            case 267 -> {
                this.forwardButton.onPress();
                yield true;
            }
            default -> false;
        };
    }

    private void updateContents() {
        this.backButton.visible = this.data.active() > 0;
        this.titleBox.setValue(this.data.title());
        ClipboardContent.Page page = this.data.pages().get(this.data.active());
        for (int i = 0; i < this.checkboxes.length; ++i) {
            this.checkboxes[i].setState(page.checkboxes().get(i));
            this.lines[i].setValue(page.lines().get(i));
        }
    }

    private static class CheckboxButton
    extends SpriteButton {
        private static final ResourceLocation CHECK_TEXTURE = BCUtil.bcLoc("check");
        private static final ResourceLocation X_TEXTURE = BCUtil.bcLoc("x");
        private CheckboxState state = CheckboxState.EMPTY;

        public CheckboxButton(int x, int y, Button.OnPress onPress) {
            super(x, y, 14, 14, onPress);
        }

        public CheckboxState getState() {
            return this.state;
        }

        public void setState(CheckboxState state) {
            this.state = state;
        }

        public void onClick(double mouseX, double mouseY, int button) {
            this.state = switch (this.state) {
                default -> throw new MatchException(null, null);
                case CheckboxState.EMPTY -> CheckboxState.CHECK;
                case CheckboxState.CHECK -> CheckboxState.X;
                case CheckboxState.X -> CheckboxState.EMPTY;
            };
            super.onClick(mouseX, mouseY, button);
        }

        @Override
        @Nullable
        protected ResourceLocation getSprite() {
            return switch (this.state) {
                default -> throw new MatchException(null, null);
                case CheckboxState.EMPTY -> null;
                case CheckboxState.CHECK -> CHECK_TEXTURE;
                case CheckboxState.X -> X_TEXTURE;
            };
        }
    }
}

