/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen;

import com.github.minecraftschurlimods.bibliocraft.client.screen.BCScreenWithToggleableSlots;
import com.github.minecraftschurlimods.bibliocraft.client.widget.ExperienceBarButton;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableInputPacket;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableMenu;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableMode;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import com.github.minecraftschurlimods.bibliocraft.util.Translations;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class PrintingTableScreen
extends BCScreenWithToggleableSlots<PrintingTableMenu> {
    private static final ResourceLocation BACKGROUND = BCUtil.bcLoc("textures/gui/printing_table.png");
    private static final ResourceLocation EXPERIENCE_BAR_BACKGROUND = BCUtil.bcLoc("experience_bar_background");
    private static final ResourceLocation EXPERIENCE_BAR_PROGRESS = BCUtil.bcLoc("experience_bar_progress");
    private static final ResourceLocation PROGRESS = BCUtil.bcLoc("printing_table_progress");
    private Button modeButton;
    private Button experienceBarButton;

    public PrintingTableScreen(PrintingTableMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title, BACKGROUND);
    }

    protected void init() {
        this.leftPos = (this.width - 192) / 2;
        this.topPos = (this.height - 192) / 2;
        PrintingTableBlockEntity blockEntity = (PrintingTableBlockEntity)((PrintingTableMenu)this.menu).getBlockEntity();
        this.modeButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), $ -> {
            blockEntity.setMode(switch (blockEntity.getMode()) {
                default -> throw new MatchException(null, null);
                case PrintingTableMode.BIND -> PrintingTableMode.CLONE;
                case PrintingTableMode.CLONE -> PrintingTableMode.MERGE;
                case PrintingTableMode.MERGE -> PrintingTableMode.BIND;
            });
            this.setModeButtonMessage();
            this.experienceBarButton.visible = blockEntity.getMode() == PrintingTableMode.CLONE;
            PacketDistributor.sendToServer((CustomPacketPayload)new PrintingTableInputPacket(blockEntity.getBlockPos(), blockEntity.getMode()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }).bounds(this.leftPos + 81, this.topPos + 6, 82, 20).build());
        this.setModeButtonMessage();
        this.experienceBarButton = (Button)this.addRenderableWidget((GuiEventListener)new ExperienceBarButton(Translations.PRINTING_TABLE_ADD_EXPERIENCE, this.leftPos + 81, this.topPos + 65, 82, 5, EXPERIENCE_BAR_BACKGROUND, EXPERIENCE_BAR_PROGRESS, () -> BCUtil.getLevelForExperience(blockEntity.getExperience()), () -> {
            if (blockEntity.getExperienceCost() <= 0) {
                return Float.valueOf(0.0f);
            }
            if (blockEntity.isExperienceFull()) {
                return Float.valueOf(1.0f);
            }
            int experience = blockEntity.getExperience();
            int level = BCUtil.getLevelForExperience(experience);
            float experienceForLevel = BCUtil.getExperienceForLevel(level);
            float experienceForNextLevel = BCUtil.getExperienceForLevel(level + 1);
            return Float.valueOf(Mth.clamp((float)(((float)experience - experienceForLevel) / (experienceForNextLevel - experienceForLevel)), (float)0.0f, (float)1.0f));
        }, $ -> {
            int experienceToGive;
            if (blockEntity.isExperienceFull()) {
                return;
            }
            int experienceCost = blockEntity.getExperienceCost();
            LocalPlayer player = ClientUtil.getPlayer();
            int n = experienceToGive = player.isCreative() ? experienceCost : Math.min(player.totalExperience, experienceCost);
            if (experienceToGive > 0) {
                blockEntity.addExperience(experienceToGive);
                player.giveExperiencePoints(-experienceToGive);
                PacketDistributor.sendToServer((CustomPacketPayload)new PrintingTableInputPacket(blockEntity.getBlockPos(), experienceToGive), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }));
        this.experienceBarButton.visible = blockEntity.getMode() == PrintingTableMode.CLONE;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.renderBg(graphics, partialTicks, x, y);
        float progress = ((PrintingTableBlockEntity)((PrintingTableMenu)this.menu).getBlockEntity()).getProgress();
        int width = progress == 1.0f ? 0 : Mth.ceil((float)(progress * 24.0f));
        graphics.blitSprite(PROGRESS, 24, 16, 0, 0, this.leftPos + 110, this.topPos + 35, width, 16);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        int experienceCost = ((PrintingTableBlockEntity)((PrintingTableMenu)this.menu).getBlockEntity()).getLevelCost();
        if (experienceCost > 0) {
            ClientUtil.renderXpText("" + experienceCost, graphics, this.leftPos + 122, this.topPos + 39);
        }
    }

    private void setModeButtonMessage() {
        this.modeButton.setMessage((Component)Component.translatable((String)"gui.bibliocraft.printing_table.mode", (Object[])new Object[]{Component.translatable((String)((PrintingTableBlockEntity)((PrintingTableMenu)this.menu).getBlockEntity()).getMode().getTranslationKey())}));
    }
}

