/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.widget;

import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import com.github.minecraftschurlimods.bibliocraft.util.FormattedLine;
import com.github.minecraftschurlimods.bibliocraft.util.Translations;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import org.joml.Matrix4f;

public class FormattedTextArea
extends AbstractWidget {
    private final Font font = ClientUtil.getFont();
    private final List<FormattedLine> lines;
    private int cursorX = 0;
    private int cursorY = 0;
    private int highlightX = 0;
    private long focusedTimestamp = Util.getMillis();
    private Consumer<FormattedLine> onLineChange;

    public FormattedTextArea(int x, int y, int width, int height, List<FormattedLine> lines) {
        super(x, y, width, height, Translations.FANCY_TEXT_AREA_NARRATION);
        this.lines = new ArrayList<FormattedLine>(lines);
    }

    public static void renderLines(List<FormattedLine> lines, PoseStack stack, MultiBufferSource bufferSource, int x, int y, int width) {
        int i = y;
        for (FormattedLine line : lines) {
            FormattedTextArea.renderLine(line, stack, bufferSource, x, i, width);
            i += line.size();
        }
    }

    public static void renderLine(FormattedLine line, PoseStack poseStack, MultiBufferSource bufferSource, int x, int y, int width, int cursor, DrawCursor drawCursor) {
        String text = line.text();
        Style style = line.style();
        int size = line.size();
        FormattedLine.Mode mode = line.mode();
        int color = 0xFF000000 | (style.getColor() == null ? 0 : style.getColor().getValue());
        float scale = FormattedTextArea.getScale(size);
        int textX = x + FormattedTextArea.getLineLeftX(line, scale, width);
        FormattedCharSequence formattedText = FormattedTextArea.format(text, style);
        FormattedTextArea.drawText(poseStack, bufferSource, formattedText, textX, y, color, size, mode);
        Font font = ClientUtil.getFont();
        if (drawCursor == DrawCursor.VERTICAL) {
            int textWidth = font.width(FormattedTextArea.format(text.substring(0, cursor), style));
            FormattedTextArea.fill(poseStack, bufferSource, RenderType.guiOverlay(), textX + (int)((float)(textWidth - 1) * scale), y - 1, textX + (int)((float)textWidth * scale), (int)((float)y + 9.0f * scale + 1.0f), color);
        } else if (drawCursor == DrawCursor.HORIZONTAL) {
            FormattedTextArea.drawText(poseStack, bufferSource, FormattedTextArea.format("_", style), (float)textX + (float)font.width(formattedText) * scale, y, color, size, mode);
        }
    }

    public static void renderLine(FormattedLine line, PoseStack poseStack, MultiBufferSource bufferSource, int x, int y, int width) {
        FormattedTextArea.renderLine(line, poseStack, bufferSource, x, y, width, 0, DrawCursor.NONE);
    }

    private static void fill(PoseStack stack, MultiBufferSource bufferSource, RenderType renderType, float minX, float minY, float maxX, float maxY, int color) {
        Matrix4f matrix4f = stack.last().pose();
        if (minX < maxX) {
            float x = minX;
            minX = maxX;
            maxX = x;
        }
        if (minY < maxY) {
            float y = minY;
            minY = maxY;
            maxY = y;
        }
        VertexConsumer vc = bufferSource.getBuffer(renderType);
        vc.addVertex(matrix4f, minX, minY, 0.0f).setColor(color);
        vc.addVertex(matrix4f, minX, maxY, 0.0f).setColor(color);
        vc.addVertex(matrix4f, maxX, maxY, 0.0f).setColor(color);
        vc.addVertex(matrix4f, maxX, minY, 0.0f).setColor(color);
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource guiBuffer = (MultiBufferSource.BufferSource)bufferSource;
            RenderSystem.disableDepthTest();
            guiBuffer.endBatch();
            RenderSystem.enableDepthTest();
        }
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int x = this.getX();
        int y = this.getY() + 1;
        for (int i = 0; i < this.lines.size(); ++i) {
            this.renderLine(graphics, i, x, y);
            y += this.lines.get(i).size();
        }
    }

    private void renderLine(GuiGraphics graphics, int index, int x, int y) {
        boolean cursorBlink;
        FormattedLine line = this.lines.get(index);
        String text = line.text();
        boolean bl = cursorBlink = (Util.getMillis() - this.focusedTimestamp) / 300L % 2L == 0L;
        DrawCursor draw = !this.isFocused() ? DrawCursor.NONE : (this.cursorY == index && this.cursorX < text.length() ? DrawCursor.VERTICAL : (this.cursorY == index ? DrawCursor.HORIZONTAL : DrawCursor.NONE));
        FormattedTextArea.renderLine(line, graphics.pose(), (MultiBufferSource)graphics.bufferSource(), x, y, this.width, this.cursorX, cursorBlink ? DrawCursor.NONE : draw);
        if (draw != DrawCursor.NONE && this.cursorX != this.highlightX) {
            int min = Math.clamp((long)Math.min(this.cursorX, this.highlightX), 0, text.length());
            int max = Math.clamp((long)Math.max(this.cursorX, this.highlightX), 0, text.length());
            Style style = line.style();
            float scale = FormattedTextArea.getScale(line.size());
            int textX = x + FormattedTextArea.getLineLeftX(line, scale, this.width);
            int minWidth = (int)((float)this.font.width(FormattedTextArea.format(text.substring(0, min), style)) * scale);
            int maxWidth = (int)((float)this.font.width(FormattedTextArea.format(text.substring(0, max), style)) * scale);
            graphics.fill(RenderType.guiTextHighlight(), textX + minWidth - 1, y - 1, textX + maxWidth - 1, (int)((float)y + 9.0f * scale + 1.0f), -16776961);
        }
    }

    private static void drawText(PoseStack poseStack, MultiBufferSource bufferSource, FormattedCharSequence text, float x, float y, int color, int size, FormattedLine.Mode mode) {
        Font font = ClientUtil.getFont();
        float scale = FormattedTextArea.getScale(size);
        poseStack.pushPose();
        poseStack.translate(x, y, 0.0f);
        poseStack.scale(scale, scale, 1.0f);
        if (mode == FormattedLine.Mode.GLOWING) {
            int outlineColor = color == 0 ? -988212 : FastColor.ARGB32.color((int)255, (int)((int)((double)FastColor.ARGB32.red((int)color) * 0.4)), (int)((int)((double)FastColor.ARGB32.green((int)color) * 0.4)), (int)((int)((double)FastColor.ARGB32.blue((int)color) * 0.4)));
            font.drawInBatch8xOutline(text, 0.0f, 0.0f, color, outlineColor, poseStack.last().pose(), bufferSource, 0xF000F0);
        } else {
            font.drawInBatch(text, 0.0f, 0.0f, color, mode == FormattedLine.Mode.SHADOW, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        poseStack.popPose();
    }

    private static FormattedCharSequence format(String text, Style style) {
        return FormattedCharSequence.forward((String)text, (Style)style);
    }

    private static float getScale(int size) {
        return (float)(size - 2) / 8.0f;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isActive() || !this.isFocused()) {
            return false;
        }
        FormattedLine line = this.lines.get(this.cursorY);
        String text = line.text();
        int min = Math.clamp((long)Math.min(this.cursorX, this.highlightX), 0, text.length());
        int max = Math.clamp((long)Math.max(this.cursorX, this.highlightX), 0, text.length());
        switch (keyCode) {
            case 257: 
            case 264: 
            case 335: {
                if (Screen.hasShiftDown()) {
                    this.moveCursor(text.length(), this.cursorY, true);
                } else if (this.cursorY < this.getEffectiveMaxLines()) {
                    this.moveCursor(this.getCursorXForNewLine(this.cursorY, this.cursorY + 1), this.cursorY + 1, false);
                }
                return true;
            }
            case 265: {
                if (Screen.hasShiftDown()) {
                    this.moveCursor(0, this.cursorY, true);
                } else if (this.cursorY > 0) {
                    this.moveCursor(this.getCursorXForNewLine(this.cursorY, this.cursorY - 1), this.cursorY - 1, false);
                }
                return true;
            }
            case 263: {
                this.moveCursor(Screen.hasControlDown() ? this.getWordPosition(-1) : Math.max(0, this.cursorX - 1), this.cursorY, Screen.hasShiftDown());
                return true;
            }
            case 262: {
                this.moveCursor(Screen.hasControlDown() ? this.getWordPosition(1) : Math.min(text.length(), this.cursorX + 1), this.cursorY, Screen.hasShiftDown());
                return true;
            }
            case 259: {
                if (this.highlightX != this.cursorX) {
                    this.deleteHighlight();
                } else if (this.cursorX > 0) {
                    int x = Screen.hasControlDown() ? this.getWordPosition(-1) : this.cursorX - 1;
                    this.lines.set(this.cursorY, line.withText(text.substring(0, x) + text.substring(this.cursorX)));
                    this.moveCursor(x, this.cursorY, false);
                }
                return true;
            }
            case 261: {
                if (this.highlightX != this.cursorX) {
                    this.deleteHighlight();
                } else if (this.cursorX < this.lines.get(this.cursorY).text().length()) {
                    int x = Screen.hasControlDown() ? this.getWordPosition(1) : this.cursorX + 1;
                    this.lines.set(this.cursorY, line.withText(text.substring(0, this.cursorX) + text.substring(x)));
                }
                return true;
            }
            case 268: {
                this.moveCursor(0, this.cursorY, Screen.hasShiftDown());
                return true;
            }
            case 269: {
                this.moveCursor(text.length(), this.cursorY, Screen.hasShiftDown());
                return true;
            }
        }
        if (Screen.isSelectAll((int)keyCode)) {
            this.cursorX = text.length();
            this.highlightX = 0;
            return true;
        }
        if (Screen.isCopy((int)keyCode)) {
            ClientUtil.getMc().keyboardHandler.setClipboard(text.substring(min, max));
            return true;
        }
        if (Screen.isPaste((int)keyCode) || keyCode == 260) {
            this.insertText(ClientUtil.getMc().keyboardHandler.getClipboard());
            return true;
        }
        if (Screen.isCut((int)keyCode)) {
            ClientUtil.getMc().keyboardHandler.setClipboard(text.substring(min, max));
            this.deleteHighlight();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private int getWordPosition(int numWords) {
        String text = this.lines.get(this.cursorY).text();
        int x = this.cursorX;
        int abs = Math.abs(numWords);
        boolean reverse = numWords < 0;
        for (int i = 0; i < abs; ++i) {
            if (!reverse) {
                int length = text.length();
                if ((x = text.indexOf(32, x)) == -1) {
                    x = length;
                    continue;
                }
                while (x < length && text.charAt(x) == ' ') {
                    ++x;
                }
                continue;
            }
            while (x > 0 && text.charAt(x - 1) == ' ') {
                --x;
            }
            while (x > 0 && text.charAt(x - 1) != ' ') {
                --x;
            }
        }
        return x;
    }

    private void moveCursor(int x, int y, boolean highlight) {
        int oldY = this.cursorY;
        this.cursorX = x;
        this.cursorY = y;
        if (y != oldY) {
            this.onLineChange.accept(this.lines.get(y));
        }
        if (!highlight) {
            this.highlightX = this.cursorX;
        }
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (!(this.isActive() && this.isFocused() && StringUtil.isAllowedChatCharacter((char)codePoint))) {
            return false;
        }
        String oldText = this.lines.get(this.cursorY).text();
        return this.tryEdit(() -> this.insertText(Character.toString(codePoint)), () -> this.lines.set(this.cursorY, this.lines.get(this.cursorY).withText(oldText)));
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        this.focusedTimestamp = Util.getMillis();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int index;
        if (!this.isMouseOver(mouseX, mouseY)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        mouseX -= (double)this.getX();
        mouseY -= (double)this.getY();
        if (!Screen.hasShiftDown() || !this.isFocused()) {
            this.cursorY = this.lines.size() - 1;
            int y = 0;
            for (int i = 0; i < this.lines.size(); ++i) {
                if ((y += this.lines.get(i).size()) > this.height) {
                    this.cursorY = i - 1;
                    break;
                }
                if (!((double)y > mouseY)) continue;
                this.cursorY = i;
                break;
            }
        }
        FormattedLine line = this.lines.get(this.cursorY);
        this.onLineChange.accept(line);
        float scale = FormattedTextArea.getScale(line.size());
        int startX = FormattedTextArea.getLineLeftX(line, scale, this.width);
        int targetWidth = (int)(mouseX - (double)startX);
        int width = 0;
        int prevWidth = -1;
        for (index = 0; Math.abs(targetWidth - width) < Math.abs(targetWidth - prevWidth) && index < line.text().length(); ++index) {
            prevWidth = width;
            width += (int)((float)this.font.width(FormattedTextArea.format(String.valueOf(line.text().charAt(index)), line.style())) * scale);
        }
        this.cursorX = Mth.clamp((int)index, (int)0, (int)line.text().length());
        if (!Screen.hasShiftDown() && this.isFocused()) {
            this.highlightX = this.cursorX;
        }
        this.setFocused(true);
        return true;
    }

    public void setOnLineChange(Consumer<FormattedLine> onLineChange) {
        this.onLineChange = onLineChange;
    }

    public List<FormattedLine> getLines() {
        return this.lines;
    }

    public void toggleStyle(Function<Style, Boolean> styleGetter, BiFunction<Style, Boolean, Style> styleSetter) {
        FormattedLine line = this.lines.get(this.cursorY);
        Style style = line.style();
        boolean oldValue = styleGetter.apply(style);
        this.tryEdit(() -> this.lines.set(this.cursorY, line.withStyle((Style)styleSetter.apply(style, !oldValue))), () -> this.lines.set(this.cursorY, line.withStyle((Style)styleSetter.apply(style, oldValue))));
    }

    public void setColor(int color) {
        FormattedLine line = this.lines.get(this.cursorY);
        this.lines.set(this.cursorY, line.withStyle(line.style().withColor(color)));
    }

    public void setSize(int size) {
        int oldValue = this.lines.get(this.cursorY).size();
        this.tryEdit(() -> this.lines.set(this.cursorY, this.lines.get(this.cursorY).withSize(size)), () -> this.lines.set(this.cursorY, this.lines.get(this.cursorY).withSize(oldValue)));
    }

    public int getSize() {
        return this.lines.get(this.cursorY).size();
    }

    public void toggleAlignment() {
        FormattedLine line = this.lines.get(this.cursorY);
        FormattedLine.Alignment oldValue = line.alignment();
        this.tryEdit(() -> this.lines.set(this.cursorY, line.withAlignment(switch (oldValue) {
            default -> throw new MatchException(null, null);
            case FormattedLine.Alignment.LEFT -> FormattedLine.Alignment.CENTER;
            case FormattedLine.Alignment.CENTER -> FormattedLine.Alignment.RIGHT;
            case FormattedLine.Alignment.RIGHT -> FormattedLine.Alignment.LEFT;
        })), () -> this.lines.set(this.cursorY, line.withAlignment(oldValue)));
    }

    public FormattedLine.Alignment getAlignment() {
        return this.lines.get(this.cursorY).alignment();
    }

    public void toggleMode() {
        FormattedLine line = this.lines.get(this.cursorY);
        FormattedLine.Mode oldValue = line.mode();
        this.tryEdit(() -> this.lines.set(this.cursorY, line.withMode(switch (oldValue) {
            default -> throw new MatchException(null, null);
            case FormattedLine.Mode.NORMAL -> FormattedLine.Mode.SHADOW;
            case FormattedLine.Mode.SHADOW -> FormattedLine.Mode.GLOWING;
            case FormattedLine.Mode.GLOWING -> FormattedLine.Mode.NORMAL;
        })), () -> this.lines.set(this.cursorY, line.withMode(oldValue)));
    }

    public FormattedLine.Mode getMode() {
        return this.lines.get(this.cursorY).mode();
    }

    private boolean isValid() {
        int y = 0;
        for (FormattedLine line : this.lines) {
            int size = line.size();
            y += size;
            if (line.text().isEmpty()) continue;
            if (y > this.height) {
                return false;
            }
            float textWidth = (float)this.font.width(FormattedTextArea.format(line.text(), line.style())) * FormattedTextArea.getScale(size);
            if (!(textWidth > (float)(this.width - 2))) continue;
            return false;
        }
        return true;
    }

    private boolean tryEdit(Runnable edit, Runnable revert) {
        edit.run();
        if (this.isValid()) {
            return true;
        }
        revert.run();
        return false;
    }

    private void deleteHighlight() {
        if (this.highlightX == this.cursorX) {
            return;
        }
        FormattedLine line = this.lines.get(this.cursorY);
        String text = line.text();
        int min = Math.clamp((long)Math.min(this.cursorX, this.highlightX), 0, text.length());
        int max = Math.clamp((long)Math.max(this.cursorX, this.highlightX), 0, text.length());
        this.lines.set(this.cursorY, line.withText(text.substring(0, min) + text.substring(max)));
        this.moveCursor(min, this.cursorY, false);
    }

    private void insertText(String s) {
        int oldCursor;
        int oldHighlight;
        String oldText;
        String text = StringUtil.filterText((String)s);
        if (!this.tryEdit(() -> {
            this.deleteHighlight();
            FormattedLine line = this.lines.get(this.cursorY);
            this.lines.set(this.cursorY, line.withText(line.text().substring(0, this.cursorX) + text + line.text().substring(this.cursorX)));
        }, () -> this.lambda$insertText$11(oldText = this.lines.get(this.cursorY).text(), oldHighlight = this.highlightX, oldCursor = this.cursorX))) {
            return;
        }
        this.cursorX += text.length();
        this.highlightX = this.cursorX;
    }

    private int getCursorXForNewLine(int oldIndex, int newIndex) {
        FormattedLine oldLine = this.lines.get(oldIndex);
        FormattedLine newLine = this.lines.get(newIndex);
        float scale = (float)newLine.size() / (float)oldLine.size();
        int targetWidth = this.font.width(FormattedTextArea.format(oldLine.text().substring(0, this.cursorX), oldLine.style()));
        int index = 0;
        int width = 0;
        int prevWidth = -1;
        while (Math.abs(targetWidth - width) < Math.abs(targetWidth - prevWidth)) {
            if (index >= newLine.text().length()) {
                return index;
            }
            prevWidth = width;
            width += (int)((float)this.font.width(FormattedTextArea.format(String.valueOf(newLine.text().charAt(index)), newLine.style())) * scale);
            ++index;
        }
        return index - 1;
    }

    private static int getLineLeftX(FormattedLine line, float scale, int width) {
        int textWidth = (int)((float)ClientUtil.getFont().width(FormattedTextArea.format(line.text(), line.style())) * scale);
        return switch (line.alignment()) {
            default -> throw new MatchException(null, null);
            case FormattedLine.Alignment.LEFT -> 1;
            case FormattedLine.Alignment.CENTER -> width / 2 - textWidth / 2;
            case FormattedLine.Alignment.RIGHT -> width - 1 - textWidth;
        };
    }

    private int getEffectiveMaxLines() {
        int size = 0;
        for (int i = 0; i < this.lines.size(); ++i) {
            FormattedLine line = this.lines.get(i);
            if ((size += line.size()) <= this.height) continue;
            return i - 1;
        }
        return this.lines.size() - 1;
    }

    private /* synthetic */ void lambda$insertText$11(String oldText, int oldHighlight, int oldCursor) {
        this.lines.set(this.cursorY, this.lines.get(this.cursorY).withText(oldText));
        this.highlightX = oldHighlight;
        this.cursorX = oldCursor;
    }

    public static enum DrawCursor {
        NONE,
        VERTICAL,
        HORIZONTAL;

    }
}

