/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.clock;

import com.github.minecraftschurlimods.bibliocraft.content.clock.AbstractClockBlock;
import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GrandfatherClockBlock
extends AbstractClockBlock {
    private static final VoxelShape X_SHAPE_TOP = ShapeUtil.combine(Shapes.box((double)0.3125, (double)0.0, (double)0.25, (double)0.6875, (double)0.875, (double)0.75), Shapes.box((double)0.3125, (double)0.875, (double)0.25, (double)0.375, (double)0.9375, (double)0.3125), Shapes.box((double)0.3125, (double)0.875, (double)0.4375, (double)0.375, (double)0.9375, (double)0.5625), Shapes.box((double)0.3125, (double)0.875, (double)0.6875, (double)0.375, (double)0.9375, (double)0.75), Shapes.box((double)0.625, (double)0.875, (double)0.25, (double)0.6875, (double)0.9375, (double)0.3125), Shapes.box((double)0.625, (double)0.875, (double)0.4375, (double)0.6875, (double)0.9375, (double)0.5625), Shapes.box((double)0.625, (double)0.875, (double)0.6875, (double)0.6875, (double)0.9375, (double)0.75));
    private static final VoxelShape Z_SHAPE_TOP = ShapeUtil.rotate(X_SHAPE_TOP, Rotation.CLOCKWISE_90);
    private static final VoxelShape X_SHAPE_BOTTOM = ShapeUtil.combine(Shapes.box((double)0.3125, (double)0.0625, (double)0.25, (double)0.6875, (double)1.0, (double)0.75), Shapes.box((double)0.3125, (double)0.0, (double)0.25, (double)0.4375, (double)0.0625, (double)0.375), Shapes.box((double)0.3125, (double)0.0, (double)0.625, (double)0.4375, (double)0.0625, (double)0.75), Shapes.box((double)0.5625, (double)0.0, (double)0.25, (double)0.6875, (double)0.0625, (double)0.375), Shapes.box((double)0.5625, (double)0.0, (double)0.625, (double)0.6875, (double)0.0625, (double)0.75));
    private static final VoxelShape Z_SHAPE_BOTTOM = ShapeUtil.rotate(X_SHAPE_BOTTOM, Rotation.CLOCKWISE_90);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    public GrandfatherClockBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? X_SHAPE_TOP : Z_SHAPE_TOP;
        }
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? X_SHAPE_BOTTOM : Z_SHAPE_BOTTOM;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (!(facing.getAxis() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (facing == Direction.UP) || facingState.is((Block)this) && facingState.getValue(HALF) != half)) {
            return Blocks.AIR.defaultBlockState();
        }
        return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        return pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(context) ? (BlockState)((BlockState)BCUtil.nonNull(super.getStateForPlacement(context)).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER) : null;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (state.getValue(HALF) != DoubleBlockHalf.UPPER) {
            return super.canSurvive(state, level, pos);
        }
        BlockState blockstate = level.getBlockState(pos.below());
        if (state.getBlock() != this) {
            return super.canSurvive(state, level, pos);
        }
        return blockstate.is((Block)this) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockPos above = pos.above();
        level.setBlock(above, DoublePlantBlock.copyWaterloggedFrom((LevelReader)level, (BlockPos)above, (BlockState)((BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER))), 3);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            if (player.isCreative()) {
                BlockPos newPos;
                BlockState newState;
                if (state.getValue(HALF) == DoubleBlockHalf.UPPER && (newState = level.getBlockState(newPos = pos.below())).is(state.getBlock()) && newState.getValue(HALF) == DoubleBlockHalf.LOWER) {
                    level.setBlock(newPos, newState.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 35);
                    level.levelEvent(player, 2001, newPos, Block.getId((BlockState)newState));
                }
            } else {
                GrandfatherClockBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity be, ItemStack stack) {
        super.playerDestroy(level, player, pos, Blocks.AIR.defaultBlockState(), be, stack);
    }

    public long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.below(state.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), (int)pos.getZ());
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.UPPER ? new ClockBlockEntity(pos, state) : null;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return state.getValue(HALF) == DoubleBlockHalf.UPPER ? super.getTicker(level, state, blockEntityType) : null;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            if (level.getBlockState(pos.above()).getBlock() instanceof GrandfatherClockBlock) {
                pos = pos.above();
            } else {
                return InteractionResult.PASS;
            }
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }
}

