/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.printingtable;

import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableCloningRecipe;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableRecipe;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableRecipeInput;
import com.github.minecraftschurlimods.bibliocraft.init.BCRecipes;
import com.github.minecraftschurlimods.bibliocraft.init.BCTags;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.CodecUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class PrintingTableCloningWithEnchantmentsRecipe
extends PrintingTableCloningRecipe {
    public static final MapCodec<PrintingTableCloningWithEnchantmentsRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").forGetter(e -> e.ingredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(e -> e.result), (App)Codec.INT.fieldOf("duration").forGetter(e -> e.duration), (App)NumberProviders.CODEC.optionalFieldOf("experience_cost").forGetter(e -> e.experienceCost)).apply((Applicative)inst, PrintingTableCloningWithEnchantmentsRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PrintingTableCloningWithEnchantmentsRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), e -> e.ingredients, (StreamCodec)ItemStack.STREAM_CODEC, e -> e.result, (StreamCodec)ByteBufCodecs.INT, e -> e.duration, (StreamCodec)CodecUtil.toStreamCodec(NumberProviders.CODEC).apply(ByteBufCodecs::optional), e -> e.experienceCost, PrintingTableCloningWithEnchantmentsRecipe::new);
    private final Optional<NumberProvider> experienceCost;

    public PrintingTableCloningWithEnchantmentsRecipe(List<Ingredient> ingredients, ItemStack result, int duration, Optional<NumberProvider> experienceCost) {
        super(List.of(DataComponents.STORED_ENCHANTMENTS), ingredients, result, duration);
        this.experienceCost = experienceCost;
    }

    @Override
    public boolean matches(PrintingTableRecipeInput input, Level level) {
        if (!super.matches(input, level)) {
            return false;
        }
        ItemStack stack = input.right();
        if (!stack.has(DataComponents.STORED_ENCHANTMENTS)) {
            return false;
        }
        return BCUtil.nonNull((ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS)).keySet().stream().noneMatch(e -> e.is(BCTags.Enchantments.PRINTING_TABLE_CLONING_BLACKLIST));
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return BCRecipes.PRINTING_TABLE_CLONING_WITH_ENCHANTMENTS.get();
    }

    @Override
    public int getExperienceLevelCost(ItemStack stack, ServerLevel level) {
        return this.experienceCost.map(e -> e.getInt(new LootContext.Builder(new LootParams(level, Map.of(LootContextParams.TOOL, stack), Map.of(), 0.0f)).create(Optional.empty()))).orElse(0);
    }

    @Override
    public boolean canHaveExperienceCost() {
        return this.experienceCost.isPresent();
    }

    public static class Builder
    extends PrintingTableRecipe.Builder {
        private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
        private NumberProvider experienceCost = null;

        public Builder(ItemStack result, int duration) {
            super(result, duration);
        }

        public Builder addIngredient(Ingredient ingredient) {
            this.ingredients.add(ingredient);
            return this;
        }

        public Builder experienceCost(NumberProvider experienceCost) {
            this.experienceCost = experienceCost;
            return this;
        }

        @Override
        public PrintingTableCloningWithEnchantmentsRecipe build() {
            return new PrintingTableCloningWithEnchantmentsRecipe(this.ingredients, this.result, this.duration, Optional.ofNullable(this.experienceCost));
        }
    }
}

