/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util.block;

import com.github.minecraftschurlimods.bibliocraft.util.block.BCItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class BCBlockEntity
extends BlockEntity
implements Container {
    private static final String ITEMS_TAG = "items";
    protected final BCItemHandler items;
    private LockCode lockKey = LockCode.NO_LOCK;

    public BCBlockEntity(BlockEntityType<?> type, int containerSize, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.items = new BCItemHandler(containerSize, this);
    }

    public LockCode getLockKey() {
        return this.lockKey;
    }

    public void setLockKey(LockCode lockKey) {
        this.lockKey = lockKey;
        this.setChanged();
        this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public int getContainerSize() {
        return this.items.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.items.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return slot < this.getContainerSize() ? this.items.getStackInSlot(slot) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int count) {
        return slot < this.getContainerSize() ? this.items.getStackInSlot(slot).split(count) : ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        if (slot < this.getContainerSize()) {
            ItemStack stack = this.items.getStackInSlot(slot);
            this.items.setStackInSlot(slot, ItemStack.EMPTY);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot < this.getContainerSize()) {
            this.items.setStackInSlot(slot, stack);
        }
    }

    public boolean stillValid(Player player) {
        BlockPos pos = this.getBlockPos();
        return this.level().getBlockEntity(pos) == this && player.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) <= 64.0;
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.items.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.lockKey = LockCode.fromTag((CompoundTag)tag);
        if (tag.contains(ITEMS_TAG)) {
            this.items.deserializeNBT(registries, tag.getCompound(ITEMS_TAG));
        }
        this.requestModelDataUpdate();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.lockKey.addToTag(tag);
        tag.put(ITEMS_TAG, (Tag)this.items.serializeNBT(registries));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public IItemHandler getCapability(@Nullable Direction side) {
        return this.items;
    }

    public Level level() {
        return this.level;
    }
}

