#version 120

uniform sampler2D colortex0;

varying vec2 texcoord;

// Yumuşak tonemap
vec3 softTonemap(vec3 color) {

    
    // Daha yumuşak kontrast (önceki 2 faktörü çok sertti)
    color = (color - 0.3) * 1 + 0.3;
    color = clamp(color, 0.0, 1.0);
    
    return color;
}

void main() {
    vec3 color = texture2D(colortex0, texcoord).rgb;
    
    // Yumuşak tonemap
    color = softTonemap(color);

    gl_FragColor = vec4(color, 1.0);
}