#version 120

uniform sampler2D texture;
uniform sampler2D lightmap;

varying vec2 texcoord;
varying vec2 lmcoord;
varying vec4 glcolor;
varying vec3 normal;

// Yumuşak lighting
float smoothLight(float light) {
    float levels = 6.0;
    float stepped = floor(light * levels) / levels;
    float nextStep = ceil(light * levels) / levels;
    float blend = smoothstep(0.3, 0.7, fract(light * levels));
    return mix(stepped, nextStep, blend);
}

void main() {
    vec4 albedo = texture2D(texture, texcoord) * glcolor;
    
    if (albedo.a < 0.1) {
        discard;
    }
    
    // Eldeki itemler için özel aydınlatma
    float blockLight = smoothLight(lmcoord.x);
    vec3 blockColor = vec3(1.0, 0.75, 0.5) * blockLight;
    
    float skyLight = smoothLight(lmcoord.y);
    vec3 skyColor = vec3(0.7, 0.8, 1.0) * skyLight;
    
    // Daha dengeli ambient (terrain ile tutarlı)
    vec3 ambient = vec3(0.2);
    
    vec3 lighting = blockColor + skyColor + ambient;
    lighting = clamp(lighting, 0.0, 1.2);
    
    // Normal shading
    vec3 worldNormal = normalize(normal);
    float shade = dot(worldNormal, normalize(vec3(0.2, 1.0, 0.5))) * 0.25 + 0.75;
    
    vec3 finalColor = albedo.rgb * lighting * shade;
    
    // Hafif saturation (terrain ile tutarlı)
    vec3 gray = vec3(dot(finalColor, vec3(0.299, 0.587, 0.114)));
    finalColor = mix(gray, finalColor, 1.05);
    
    gl_FragData[0] = vec4(finalColor, albedo.a);
}