#version 120

uniform sampler2D texture;
uniform sampler2D lightmap;

varying vec2 texcoord;
varying vec2 lmcoord;
varying vec4 glcolor;
varying vec3 normal;

// Yumuşak cartoon lighting
float smoothLight(float light) {
    float levels = 6.0;
    float stepped = floor(light * levels) / levels;
    float nextStep = ceil(light * levels) / levels;
    float blend = smoothstep(0.3, 0.7, fract(light * levels));
    return mix(stepped, nextStep, blend);
}

void main() {
    // Texture sampling
    vec4 color = texture2D(texture, texcoord) * glcolor;
    
    // Alpha test
    if (color.a < 0.1) {
        discard;
    }
    
    // Lightmap uygula - BURAYI EKSİK BIRAKMIŞSINIZ
    // Block light (meşale, lava vs.)
    float blockLight = smoothLight(lmcoord.x);
    vec3 blockColor = vec3(1.0, 0.75, 0.5) * blockLight;
    
    // Sky light (gün ışığı)
    float skyLight = smoothLight(lmcoord.y);
    vec3 skyColor = vec3(0.7, 0.8, 1.0) * skyLight;
    
    // Ambient light (karanlıkta tamamen siyah olmasın)
    vec3 ambient = vec3(0.15);
    
    // Toplam aydınlatma
    vec3 lighting = blockColor + skyColor + ambient;
    lighting = clamp(lighting, 0.0, 1.2);
    
    // Normal-based shading (hafif 3D efekti)
    vec3 worldNormal = normalize(normal);
    float normalShade = dot(worldNormal, normalize(vec3(0.2, 1.0, 0.5))) * 0.25 + 0.75;
    
    // Final renk
    vec3 finalColor = color.rgb * lighting * normalShade;
    
    // Hafif renk doygunluğu
    float luma = dot(finalColor, vec3(0.299, 0.587, 0.114));
    finalColor = mix(vec3(luma), finalColor, 1.05);
    
    // Output
    gl_FragData[0] = vec4(finalColor, color.a);
}