#version 120

varying vec2 texcoord;
varying vec2 lmcoord;
varying vec4 glcolor;
varying vec3 normal;

void main() {
    // Texture coordinates
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
    
    // Lightmap coordinates
    lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
    
    // Vertex color
    glcolor = gl_Color;
    
    // Normal (shading için)
    normal = normalize(gl_NormalMatrix * gl_Normal);
    
    // Position
    gl_Position = ftransform();
}