package net.mehvahdjukaar.every_compat.common_classes;

import com.google.gson.JsonObject;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@SuppressWarnings("unused")
public class RecipeUtility {

    /**
     * Create Stonecutting Recipe that use tag as an ingredient
     */
    public static void stonecuttingWithTagRecipe(class_2248 output, class_2960 recipeLoc, class_2960 tagResLoc,
                                                 class_2960 newRecipeLoc, ServerDynamicResourcesHandler handler, class_3300 manager) {
        if (Objects.nonNull(output)) {
            try (InputStream recipeStream = manager.method_14486(recipeLoc)
                    .orElseThrow(() -> new FileNotFoundException("Failed to get " + recipeLoc)).method_14482()) {
                JsonObject recipe = RPUtils.deserializeJson(recipeStream);

                // Editing the recipe
                recipe.getAsJsonObject("ingredient").addProperty("tag", tagResLoc.toString());
                recipe.addProperty("result", Utils.getID(output).toString());

                // Adding to the resources
                handler.dynamicPack.addJson(newRecipeLoc, recipe, ResType.RECIPES);

            } catch (IOException e) {
                handler.getLogger().error("Failed to generate the recipe @ {} : {}", recipeLoc, e);
            }
        }
    }
}
