package net.mehvahdjukaar.every_compat.dynamicpack;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.misc.StrOpt;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class ExtraTextureGenerator {

    private static final Gson GSON = new Gson();


    // only works for wood.
    public record RecolorableTexture(List<Text> textures, boolean mergePalette, class_2248 block) {

        public static final Codec<RecolorableTexture> CODEC = RecordCodecBuilder.create(instance -> instance.group(
                Text.TEXT_CODEC.listOf().fieldOf("textures").forGetter(RecolorableTexture::textures),
                StrOpt.of(Codec.BOOL, "merge_palette", true).forGetter(RecolorableTexture::mergePalette),
                class_7923.field_41175.method_39673().fieldOf("planks_block").forGetter(RecolorableTexture::block)
        ).apply(instance, RecolorableTexture::new));
    }

    public record Text(class_2960 text, @Nullable class_2960 mask) {
        public static final Codec<Text> TEXT_CODEC = RecordCodecBuilder.create(instance -> instance.group(
                class_2960.field_25139.fieldOf("texture").forGetter(Text::text),
                StrOpt.of(class_2960.field_25139, "mask").forGetter(t -> Optional.ofNullable(t.mask))
        ).apply(instance, (a, b) -> new Text(a, b.orElse(null))));
    }

    public static void generateExtraTextures(DynClientResourcesGenerator generator, class_3300 manager) {
        Map<class_2960, JsonElement> map = new HashMap();
        class_4309.method_51148(manager, "recolorable_textures", GSON, map);
        var extraTextures = new ArrayList<RecolorableTexture>();
        map.forEach((id, json) -> {

            RecolorableTexture modifier = RecolorableTexture.CODEC.decode(JsonOps.INSTANCE, json)
                    .getOrThrow(false, errorMsg -> EveryCompat.LOGGER.warn("Failed to load recolorable texture {}: {}", id, errorMsg))
                    .getFirst();
            extraTextures.add(modifier);
        });

        for (var v : extraTextures) {

            WoodType baseWood = WoodTypeRegistry.INSTANCE.getBlockTypeOf(v.block);
            SimpleEntrySet.Builder<WoodType, class_2248> dummy = SimpleEntrySet.builder(WoodType.class, "dummy",
                    () -> v.block, () -> baseWood,
                    w -> null);

            for (var t : v.textures) {
                if (t.mask != null) dummy.addTextureM(t.text, t.mask);
                else dummy.addTexture(t.text);
            }
            if (v.mergePalette) dummy.useMergedPalette();

            dummy.build().generateTextures(null, generator, manager);
        }
    }
}
