package net.mehvahdjukaar.every_compat.modules.beautiful_campfires;

import com.google.gson.JsonObject;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1761;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_3922;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.ToIntFunction;

import static net.mehvahdjukaar.every_compat.common_classes.TagUtility.getATagOrCreateANew;

//SUPPORT: v1.0.0+
//NOTE: The Project ID is 1085950
public class BeautifulCampfiresModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_3922> campfires;
    public final SimpleEntrySet<WoodType, class_3922> soul_campfires;

    public BeautifulCampfiresModule(String modId) {
        super(modId, "bc");
        class_5321<class_1761> tab = class_7706.field_40197;

        campfires = SimpleEntrySet.builder(WoodType.class, "campfire",
                        getModBlock("acacia_campfire", class_3922.class), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new class_3922(true, 1, copyProperties(15))
                )
                .addTile(() -> class_2591.field_17380)
                .addTextureM(modRes("item/acacia_campfire"), EveryCompat.res("item/bc/campfire_m"))
                .addTextureM(modRes("item/acacia_soul_campfire"), EveryCompat.res("item/bc/campfire_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_23799, class_7924.field_41254)
                .setTabKey(tab)
                //RECIPES: Manully created below
                .build();
        this.addEntry(campfires);

        soul_campfires = SimpleEntrySet.builder(WoodType.class, "soul_campfire",
                        getModBlock("acacia_soul_campfire", class_3922.class), () -> WoodTypeRegistry.getValue("acacia"),
                        w -> new class_3922(true, 2, copyProperties(10))
                )
                .addTile(() -> class_2591.field_17380)
                //TEXTURE: using acacia_soul_campfire above
                .createPaletteFromChild("log")
                .addTextureM(modRes("block/acacia_campfire_log_lit"), EveryCompat.res("block/bc/campfire_log_lit_m"))
                .addTextureM(modRes("block/acacia_soul_campfire_log_lit"), EveryCompat.res("block/bc/campfire_log_lit_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_23799, class_7924.field_41254)
                .addTag(class_3481.field_22465, class_7924.field_41254)
                .setTabKey(tab)
                //RECIPES: Manully created below
                .build();
        this.addEntry(soul_campfires);

    }

    public class_4970.class_2251 copyProperties(int pLightValue) {
        return class_4970.class_2251.method_9637()
                .method_31710(class_3620.field_16017)
                .method_51368(class_2766.field_12651)
                .method_9632(2.0F)
                .method_9626(class_2498.field_11547)
                .method_9631(litBlockEmission(pLightValue))
                .method_22488()
                .method_50013();
    }

    private static @NotNull ToIntFunction<class_2680> litBlockEmission(int pLightValue) {
        return (state) -> (Boolean)state.method_11654(class_2741.field_12548) ? pLightValue : 0;
    }

    @Override
    // RECIPES
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, class_3300 manager) {
        super.addDynamicServerResources(handler, manager);
        class_2960 campfireLoc = modRes("acacia_campfire");
        class_2960 soulCampfireLoc = modRes("acacia_soul_campfire");

        campfires.blocks.forEach((wood, block) ->{
            createRecipe("campfire", wood, block, campfireLoc, handler, manager);
            createRecipe("soul_campfire", wood, soul_campfires.blocks.get(wood), soulCampfireLoc,
                    handler, manager);
        });

    }

    public void createRecipe(String recipeName, WoodType woodType, class_2248 output, class_2960 recipeLoc,
                             ServerDynamicResourcesHandler handler, class_3300 manager) {

        try (InputStream recipeStream = manager.method_14486(ResType.RECIPES.getPath(recipeLoc))
                .orElseThrow(() -> new FileNotFoundException("File not found @ " + recipeLoc)).method_14482()) {

            JsonObject recipe = RPUtils.deserializeJson(recipeStream);

            // Editing the recipe
            recipe.getAsJsonObject("key").getAsJsonObject("L")
                    .addProperty("tag", getATagOrCreateANew("logs", "caps", woodType, handler, manager).toString());

            recipe.getAsJsonObject("result").addProperty("item", Utils.getID(output).toString());

            // Adding to resources
            handler.dynamicPack.addJson(
                    EveryCompat.res(shortenedId() +"/"+ woodType.getAppendableId() +"_"+ recipeName),
                    recipe,
                    ResType.RECIPES
            );

        }
        catch (IOException e) {
            handler.getLogger().error("Failed to generate the {} recipe for {} : {}", recipeName, woodType.getId(), e);
        }

    }

    @Override
    // TEXTURES
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, class_3300 manager) {
        super.addDynamicClientResources(handler, manager);

        String campfirePath = "block/acacia_campfire_log";
        class_2960 campfireImage = modRes(campfirePath);
        class_2960 targetLogMask = EveryCompat.res("block/bc/campfire_log_m"); // Focus on the log part
        class_2960 targetPlankMask = EveryCompat.res("block/bc/campfire_plank_m"); // Focus on the plank part

        try (TextureImage textureImage = TextureImage.open(manager, campfireImage);
             TextureImage targetLogImage = TextureImage.open(manager, targetLogMask);
             TextureImage targetPlankImage = TextureImage.open(manager, targetPlankMask)
        ) {
            campfires.blocks.forEach((wood, block) -> {
                class_2960 id = Utils.getID(block);

                try (
                        TextureImage plankTexture = TextureImage.open(manager,
                                RPUtils.findFirstBlockTextureLocation(manager, wood.planks));
                        TextureImage logTexture = TextureImage.open(manager,
                                RPUtils.findFirstBlockTextureLocation(manager, wood.log, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE))
                ) {
                    class_2960 newResLoc = EveryCompat.res(BlockTypeResTransformer.replaceTypeNoNamespace(campfirePath, wood, id, "acacia"));

                    // Recoloring the log part
                    Respriter respriterLog = Respriter.masked(textureImage, targetLogImage);

                    TextureImage recoloredLog = respriterLog.recolorWithAnimationOf(logTexture);

                    // Recoloring the plank part
                    Respriter respriterPlank = Respriter.masked(recoloredLog, targetPlankImage);

                    TextureImage finishedImage = respriterPlank.recolorWithAnimationOf(plankTexture);

                    // Adding to the resource
                    handler.dynamicPack.addAndCloseTexture(newResLoc, finishedImage);

                } catch (IOException e) {
                    handler.getLogger().error("Failed to open log/plank texture file: ", e);
                }
            });
        } catch (IOException e) {
            handler.getLogger().error("Failed to open texture file: ", e);
        }

    }
}