package net.mehvahdjukaar.every_compat.modules.camp_chair;

import dlovin.smalls.campchair.core.blocks.CampChairBlock;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_7706;
import net.minecraft.class_7924;

public class CampChairModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, CampChairBlock> campChairs;

    public CampChairModule(String modId) {
        super(modId, "cc");

        campChairs = SimpleEntrySet.builder(WoodType.class, "camp_chair",
                        getModBlock("oak_camp_chair", CampChairBlock.class), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new CampChairBlock(BlockBehaviour.Properties.of()
                                .mapColor(w.getColor())
                                .sound(w.getSound())
                                .strength(2.0F, 3.0F).sound(SoundType.WOOD)))
                .addTag(modRes("camp_chairs"), class_7924.field_41254)
                .addTag(modRes("camp_chairs"), class_7924.field_41197)
                .setTabKey(class_7706.field_41061)
                .defaultRecipe()
                .build();

        this.addEntry(campChairs);
    }

}
