package net.mehvahdjukaar.every_compat.modules.decorative_blocks;

import com.mojang.datafixers.util.Pair;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.core.DBBlocks;
import lilypuree.decorative_blocks.items.SeatItem;
import lilypuree.decorative_blocks.items.SupportItem;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_7924;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

//SUPPORT: v4.1.3+
public class DecorativeBlocksModule extends SimpleModule {

    public final Map<WoodType, DBWoodType> wtConversion = new HashMap<>();
    public final SimpleEntrySet<WoodType, class_2248> beams;
    public final SimpleEntrySet<WoodType, class_2248> palisades;
    public final SimpleEntrySet<WoodType, class_2248> supports;
    public final SimpleEntrySet<WoodType, class_2248> seats;

    public DecorativeBlocksModule(String modId) {
        super(modId, "db");
        class_2960 tab = modRes("general");

        beams = SimpleEntrySet.builder(WoodType.class, "beam",
                        getModBlock("oak_beam"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> DBBlocks.createDecorativeBlock(wtConversion.get(w), WoodDecorativeBlockTypes.BEAM)
                )
                .requiresChildren("stripped_log") //REASON: recipes
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_35571, class_7924.field_41254)
                .addTag(class_3481.field_15475, class_7924.field_41254)
                .addTag(class_3481.field_23210, class_7924.field_41254)
                .addTag(modRes("beams"), class_7924.field_41254)
                .addTag(modRes("beams_that_burn"), class_7924.field_41254)
                .addTag(class_3489.field_15539, class_7924.field_41197)
                .addTag(class_3489.field_23212, class_7924.field_41197)
                .addTag(modRes("beams"), class_7924.field_41197)
                .addTag(modRes("beams_that_burn"), class_7924.field_41197)
                .defaultRecipe()
                .setTabKey(tab)
                .setPalette(this::makeDBPalette)
                .addTexture(modRes("block/oak_beam_end"))
                .addTexture(modRes("block/oak_beam_side"))
                .build();
        this.addEntry(beams);


        palisades = SimpleEntrySet.builder(WoodType.class, "palisade",
                        getModBlock("oak_palisade"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> DBBlocks.createDecorativeBlock(wtConversion.get(w), WoodDecorativeBlockTypes.PALISADE)
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(class_3481.field_15504, class_7924.field_41254)
                .addTag(modRes("palisades"), class_7924.field_41254)
                .addTag(modRes("palisades_that_burn"), class_7924.field_41254)
                .addTag(modRes("palisades"), class_7924.field_41197)
                .addTag(modRes("palisades_that_burn"), class_7924.field_41197)
                .defaultRecipe()
                .setTabKey(tab)
                .setPalette(this::makeDBPalette)
                .addTexture(modRes("block/oak_palisade_end"))
                .addTexture(modRes("block/oak_palisade_side"))
                .build();
        this.addEntry(palisades);


        supports = SimpleEntrySet.builder(WoodType.class, "support",
                        getModBlock("oak_support"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> DBBlocks.createDecorativeBlock(wtConversion.get(w), WoodDecorativeBlockTypes.SUPPORT)
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("supports"), class_7924.field_41254)
                .addTag(modRes("supports_that_burn"), class_7924.field_41254)
                .addTag(modRes("supports"), class_7924.field_41197)
                .addTag(modRes("supports_that_burn"), class_7924.field_41197)
                .addCustomItem((w, b, p) -> new SupportItem(b, p))
                .defaultRecipe()
                .setTabKey(tab)
                .setPalette(this::makeDBPalette)
                .addTexture(modRes("block/oak_support_end"))
                .addTexture(modRes("block/oak_support_side"))
                .build();
        this.addEntry(supports);


        seats = SimpleEntrySet.builder(WoodType.class, "seat",
                        getModBlock("oak_seat"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> DBBlocks.createDecorativeBlock(wtConversion.get(w), WoodDecorativeBlockTypes.SEAT)
                )
                .requiresChildren("fence", "slab") //REASON: recipes
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("seats_that_burn"), class_7924.field_41254)
                .addTag(modRes("seats"), class_7924.field_41254)
                .addTag(modRes("seats"), class_7924.field_41197)
                .defaultRecipe()
                .addCustomItem((w, b, p) -> new SeatItem(b, p))
                .setTabKey(tab)
                .setPalette(this::makeDBPalette)
                .addTexture(modRes("block/oak_seat"))
                .build();
        this.addEntry(seats);

    }

    public Pair<List<Palette>, McMetaFile> makeDBPalette(WoodType woodType, class_3300 manager) {
        try (TextureImage plankTexture = TextureImage.open(manager,
                RPUtils.findFirstBlockTextureLocation(manager, woodType.planks))) {

            List<Palette> targetPalette = SpriteUtils.extrapolateSignBlockPalette(plankTexture);
            return Pair.of(targetPalette, plankTexture.getMcMeta());
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public <T extends BlockType> void registerBlocks(Class<T> typeClass,
                                                     Registrator<class_2248> registry, Collection<T> types) {
        if (typeClass == WoodType.class) {
            types.forEach(w -> wtConversion.put((WoodType) w, new DBWoodType((WoodType) w)));
        }
        super.registerBlocks(typeClass, registry, types);
    }

}