package net.mehvahdjukaar.every_compat.modules.fabric.architect_palette;

import com.slomaxonical.architectspalette.blocks.RailingBlock;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.block.ModStairBlock;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2544;
import net.minecraft.class_3481;
import net.minecraft.class_7924;

//SUPPORT: v1.3.6+
public class ArchitectsPaletteModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> railings;
    public final SimpleEntrySet<WoodType, class_2248> boards;
    public final SimpleEntrySet<WoodType, class_2248> boardStairs;
    public final SimpleEntrySet<WoodType, class_2248> boardWalls;
    public final SimpleEntrySet<WoodType, class_2248> boardSlabs;

    public ArchitectsPaletteModule(String modId) {
        super(modId, "ap");

        railings = SimpleEntrySet.builder(WoodType.class, "railing",
                        getModBlock("oak_railing"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new RailingBlock(Utils.copyPropertySafe(w.planks)))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .defaultRecipe()
                //.setTabKey(() -> CreativeModeTabs.BUILDING_BLOCKS)
                .build();
        this.addEntry(railings);

        boardSlabs = SimpleEntrySet.builder(WoodType.class, "board_slab",
                        getModBlock("oak_board_slab"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new class_2482(Utils.copyPropertySafe(w.planks)))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15469, class_7924.field_41254)
                .addTag(class_3481.field_15469, class_7924.field_41197)
                .defaultRecipe()
                .copyParentDrop()
                //.setTabKey(() -> CreativeModeTabs.BUILDING_BLOCKS)
                .createPaletteFromPlanks(p -> {

                    while (p.size() > 7) {
                        p.remove(p.getDarkest());
                    }

                    var col = p.getColorAtSlope(0.5f);
                    int ind = p.indexOf(col);
                    var lab = col.lab();
                    PaletteColor newC = new PaletteColor(lab.withLuminance(lab.luminance() * 1.03f));
                    float dl = p.get(ind + 1).luminance() - newC.luminance();
                    p.set(ind, newC);
                    PaletteColor before = p.get(ind - 1);
                    //lighten the other main plank mask if its too dark
                    if (newC.luminance() - before.luminance() > dl * 1.5) {
                        PaletteColor newBefore = new PaletteColor(before.lab().withLuminance(
                                (before.luminance() * 0.6f + (newC.luminance() + dl) * 0.4f)));
                        p.set(ind - 1, newBefore);
                    }

                })
                .addTexture(modRes("block/oak_boards"))
                .addTexture(modRes("block/oak_boards_odd"))
                .build();
        this.addEntry(boardSlabs);


        boardWalls = SimpleEntrySet.builder(WoodType.class, "board_wall",
                        getModBlock("oak_board_wall"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new class_2544(Utils.copyPropertySafe(w.planks)))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15504, class_7924.field_41254)
                .addTag(class_3481.field_15504, class_7924.field_41197)
                .defaultRecipe()
                //.setTabKey(() -> CreativeModeTabs.BUILDING_BLOCKS)
                .build();
        this.addEntry(boardWalls);

        boards = SimpleEntrySet.builder(WoodType.class, "boards",
                        getModBlock("oak_boards"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new class_2248(Utils.copyPropertySafe(w.planks)))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .defaultRecipe()
                //.setTabKey(() -> CreativeModeTabs.BUILDING_BLOCKS)
                .build();
        this.addEntry(boards);

        boardStairs = SimpleEntrySet.builder(WoodType.class, "board_stairs",
                        getModBlock("oak_board_stairs"), () -> WoodTypeRegistry.OAK_TYPE,
                        w -> new ModStairBlock(() -> boards.blocks.get(w), Utils.copyPropertySafe(w.planks)))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15459, class_7924.field_41254)
                .addTag(class_3481.field_15459, class_7924.field_41197)
                .defaultRecipe()
                //.setTabKey(() -> CreativeModeTabs.BUILDING_BLOCKS)
                .addCondition(boards.blocks::containsKey)
                .build();
        this.addEntry(boardStairs);
    }

}
