package net.mehvahdjukaar.every_compat.modules.hearth_and_home;

import com.starfish_studios.hearth_and_home.HearthAndHome;
import com.starfish_studios.hearth_and_home.block.LatticeBlock;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_7924;

// SUPPORT v2.0.1
public class HearthAndHomeModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> sanded_wood;
    public final SimpleEntrySet<WoodType, class_2248> parquet;
    public final SimpleEntrySet<WoodType, class_2248> trim;
    public final SimpleEntrySet<WoodType, class_2248> vertical_trim;
    public final SimpleEntrySet<WoodType, class_2248> lattice;

    public HearthAndHomeModule(String modId) {
        super(modId, "hnhome");
        var tab = (PlatHelper.getPlatform().isForge()) ? modRes(HearthAndHome.MOD_ID) : modRes("tab");

        sanded_wood = SimpleEntrySet.builder(WoodType.class, "sanded_wood",
                        getModBlock("oak_sanded_wood"), () -> WoodTypeRegistry.getValue(new class_2960("oak")),
                        w -> new class_2248(Utils.copyPropertySafe(w.planks)))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("sanded_wood"), class_7924.field_41254)
                .addTag(modRes("sanded_wood"), class_7924.field_41197)
                .addTexture(modRes("block/sanded_wood/oak"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(sanded_wood);

        parquet = SimpleEntrySet.builder(WoodType.class, "parquet",
                        getModBlock("oak_parquet"), () -> WoodTypeRegistry.getValue(new class_2960("oak")),
                        w -> new class_2248(Utils.copyPropertySafe(w.planks)))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("parquet"), class_7924.field_41254)
                .addTag(modRes("parquet"), class_7924.field_41197)
                .addTexture(modRes("block/parquet/oak"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(parquet);

        trim = SimpleEntrySet.builder(WoodType.class, "trim",
                        getModBlock("oak_trim"), () -> WoodTypeRegistry.getValue(new class_2960("oak")),
                        w -> new class_2248(Utils.copyPropertySafe(w.planks)))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("trims"), class_7924.field_41254)
                .addTag(modRes("trims"), class_7924.field_41197)
                .addTexture(modRes("block/trim/oak"))
                .defaultRecipe()
                .addRecipe(modRes("oak_trim_from_oak_vertical_trim"))
                .setTabKey(tab)
                .build();
        this.addEntry(trim);

        vertical_trim = SimpleEntrySet.builder(WoodType.class, "vertical_trim",
                        getModBlock("oak_vertical_trim"), () -> WoodTypeRegistry.getValue(new class_2960("oak")),
                        w -> new class_2248(Utils.copyPropertySafe(w.planks)))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("trims"), class_7924.field_41254)
                .addTag(modRes("trims"), class_7924.field_41197)
                .addTexture(modRes("block/trim/oak"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(vertical_trim);

        lattice = SimpleEntrySet.builder(WoodType.class, "lattice",
                        getModBlock("oak_lattice"), () -> WoodTypeRegistry.getValue(new class_2960("oak")),
                        w -> new LatticeBlock(Utils.copyPropertySafe(w.planks).method_22488()))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("lattices"), class_7924.field_41254)
                .addTag(modRes("lattices"), class_7924.field_41197)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .addTexture(modRes("block/lattice/oak"))
                .addTexture(modRes("block/lattice/oak_bar"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(lattice);
    }
}
