package net.mehvahdjukaar.every_compat.modules.more_beautiful_torches;

import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_1827;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2458;
import net.minecraft.class_2459;
import net.minecraft.class_2527;
import net.minecraft.class_2555;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_7924;
import net.minecraft.world.level.block.*;


//SUPPORT: v3.0.0+
public class MoreBeautifulTorches extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> log_wall_torch,
                                                 log_torch;
    public final SimpleEntrySet<WoodType, class_2248> log_soul_wall_torch,
                                                 log_soul_torch;
    public final SimpleEntrySet<WoodType, class_2248> log_redstone_wall_torch,
                                                 log_redstone_torch;

    public final SimpleEntrySet<WoodType, class_2248> planks_wall_torch,
                                                 planks_torch;
    public final SimpleEntrySet<WoodType, class_2248> planks_soul_wall_torch,
                                                 planks_soul_torch;
    public final SimpleEntrySet<WoodType, class_2248> planks_redstone_wall_torch,
                                                 planks_redstone_torch;

    public final SimpleEntrySet<WoodType, class_2248> stripped_wall_torch,
                                                 stripped_torch;
    public final SimpleEntrySet<WoodType, class_2248> stripped_soul_wall_torch,
                                                 stripped_soul_torch;
    public final SimpleEntrySet<WoodType, class_2248> stripped_redstone_wall_torch,
                                                 stripped_redstone_torch;


    public MoreBeautifulTorches(String modId) {
        super(modId, "mbt");
        class_2960 tab = (PlatHelper.Platform.FABRIC.isFabric())
                ? modRes("goldenfoods_tab")
                : modRes("morebeautifultorches_tab");

        log_wall_torch = SimpleEntrySet.builder(WoodType.class, "log_wall_torch",
                        getModBlock("oak_log_wall_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2555(class_4970.class_2251.method_9630(class_2246.field_10099), class_2398.field_11240)
                )
                .addTextureM(modRes("block/oak_log_torch"), EveryCompat.res("block/common_torch_m"))
                .addTag(new class_2960("dangerclose:torch_burn_danger"), class_7924.field_41254)
                .noTab()
                .noItem()
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(log_wall_torch);

        log_torch = SimpleEntrySet.builder(WoodType.class, "log_torch",
                        getModBlock("oak_log_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2527(class_4970.class_2251.method_9630(class_2246.field_10336), class_2398.field_11240)
                )
                //TEXTURES: wall_torch
                .addTag(new class_2960("dangerclose:torch_burn_danger"), class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((w, b, p) -> new class_1827(b, log_wall_torch.blocks.get(w), p, class_2350.field_11033))
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(log_torch);

        log_soul_wall_torch = SimpleEntrySet.builder(WoodType.class, "log_soul_wall_torch",
                        getModBlock("oak_log_soul_wall_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2555(class_4970.class_2251.method_9630(class_2246.field_22093), class_2398.field_22246)
                )
                .setRenderType(RenderLayer.CUTOUT)
                .addTag(new class_2960("dangerclose:torch_burn_danger"), class_7924.field_41254)
                .addTextureM(modRes("block/oak_log_soul_torch"), EveryCompat.res("block/common_torch_m"))
                .noTab()
                .noItem()
                .build();
        this.addEntry(log_soul_wall_torch);

        log_soul_torch = SimpleEntrySet.builder(WoodType.class, "log_soul_torch",
                        getModBlock("oak_log_soul_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2527(class_4970.class_2251.method_9630(class_2246.field_22092), class_2398.field_22246)
                )
                //TEXTURES: soul_wall_torch
                .addTag(new class_2960("dangerclose:torch_burn_danger"), class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((w, b, p) -> new class_1827(b, log_soul_wall_torch.blocks.get(w), p, class_2350.field_11033))
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(log_soul_torch);

        log_redstone_wall_torch = SimpleEntrySet.builder(WoodType.class, "log_redstone_wall_torch",
                        getModBlock("oak_log_redstone_wall_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2458(class_4970.class_2251.method_9630(class_2246.field_10301))
                )
                .addTextureM(modRes("block/oak_log_redstone_torch"), EveryCompat.res("block/common_redstone_torch_m"))
                .addTextureM(modRes("block/oak_log_redstone_torch_off"), EveryCompat.res("block/common_torch_m"))
                .noTab()
                .noItem()
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(log_redstone_wall_torch);

        log_redstone_torch = SimpleEntrySet.builder(WoodType.class, "log_redstone_torch",
                        getModBlock("oak_log_redstone_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2459(class_4970.class_2251.method_9630(class_2246.field_10523))
                )
                //TEXTURES: redstone_wall_torch
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((w, b, p) -> new class_1827(b, log_redstone_wall_torch.blocks.get(w), p, class_2350.field_11033))
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(log_redstone_torch);

//!!--PLANKS--
        planks_wall_torch = SimpleEntrySet.builder(WoodType.class, "planks_wall_torch",
                        getModBlock("oak_planks_wall_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2555(class_4970.class_2251.method_9630(class_2246.field_10099), class_2398.field_11240)
                )
                .addTextureM(modRes("block/oak_planks_torch"), EveryCompat.res("block/common_torch_m"))
                .addTag(new class_2960("dangerclose:torch_burn_danger"), class_7924.field_41254)
                .noTab()
                .noItem()
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(planks_wall_torch);

        planks_torch = SimpleEntrySet.builder(WoodType.class, "planks_torch",
                        getModBlock("oak_planks_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2527(class_4970.class_2251.method_9630(class_2246.field_10336), class_2398.field_11240)
                )
                //TEXTURES: planks_wall_torch
                .addTag(new class_2960("dangerclose:torch_burn_danger"), class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((s, b, p) -> new class_1827(b, planks_wall_torch.blocks.get(s), p, class_2350.field_11033))
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(planks_torch);

        planks_soul_wall_torch = SimpleEntrySet.builder(WoodType.class, "planks_soul_wall_torch",
                        getModBlock("oak_planks_soul_wall_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2555(class_4970.class_2251.method_9630(class_2246.field_22093), class_2398.field_22246)
                )
                .addTextureM(modRes("block/oak_planks_soul_torch"), EveryCompat.res("block/common_torch_m"))
                .addTag(new class_2960("dangerclose:torch_burn_danger"), class_7924.field_41254)
                .noTab()
                .noItem()
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(planks_soul_wall_torch);

        planks_soul_torch = SimpleEntrySet.builder(WoodType.class, "planks_soul_torch",
                        getModBlock("oak_planks_soul_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2527(class_4970.class_2251.method_9630(class_2246.field_22092), class_2398.field_22246)
                )
                //TEXTURES: planks_soul_wall_torch
                .addTag(new class_2960("dangerclose:torch_burn_danger"), class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((s, b, p) -> new class_1827(b, planks_soul_wall_torch.blocks.get(s), p, class_2350.field_11033))
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(planks_soul_torch);

        planks_redstone_wall_torch = SimpleEntrySet.builder(WoodType.class, "planks_redstone_wall_torch",
                        getModBlock("oak_planks_redstone_wall_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2458(class_4970.class_2251.method_9630(class_2246.field_10301))
                )
                .addTextureM(modRes("block/oak_planks_redstone_torch"), EveryCompat.res("block/common_redstone_torch_m"))
                .addTextureM(modRes("block/oak_planks_redstone_torch_off"), EveryCompat.res("block/common_torch_m"))
                .noTab()
                .noItem()
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(planks_redstone_wall_torch);

        planks_redstone_torch = SimpleEntrySet.builder(WoodType.class, "planks_redstone_torch",
                        getModBlock("oak_planks_redstone_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2459(class_4970.class_2251.method_9630(class_2246.field_10523))
                )
                //TEXTURES: planks_redstone_wall_torch
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((w, b, p) -> new class_1827(b, planks_redstone_wall_torch.blocks.get(w), p, class_2350.field_11033))
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(planks_redstone_torch);

//!!--STRIPPED-LOG--
        stripped_wall_torch = SimpleEntrySet.builder(WoodType.class, "log_wall_torch", "stripped",
                        getModBlock("stripped_oak_log_wall_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2555(class_4970.class_2251.method_9630(class_2246.field_10099), class_2398.field_11240)
                )
                .requiresChildren("stripped_log") //REASON: textures
                .createPaletteFromChild("stripped_log")
                .addTextureM(modRes("block/stripped_oak_log_torch"), EveryCompat.res("block/common_torch_m"))
                .addTag(new class_2960("dangerclose:torch_burn_danger"), class_7924.field_41254)
                .noTab()
                .noItem()
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(stripped_wall_torch);

        stripped_torch = SimpleEntrySet.builder(WoodType.class, "log_torch", "stripped",
                        getModBlock("stripped_oak_log_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2527(class_4970.class_2251.method_9630(class_2246.field_10336), class_2398.field_11240)
                )
                //TEXTURES: stripped_wall_torch
                .requiresChildren("stripped_log") //REASON: recipes
                .addTag(new class_2960("dangerclose:torch_burn_danger"), class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((s, b, p) -> new class_1827(b, stripped_wall_torch.blocks.get(s), p, class_2350.field_11033))
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(stripped_torch);

        stripped_soul_wall_torch = SimpleEntrySet.builder(WoodType.class, "log_soul_wall_torch", "stripped",
                        getModBlock("stripped_oak_log_soul_wall_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2555(class_4970.class_2251.method_9630(class_2246.field_22093), class_2398.field_22246)
                )
                .requiresChildren("stripped_log") //REASON: textures
                .createPaletteFromChild("stripped_log")
                .addTextureM(modRes("block/stripped_oak_log_soul_torch"), EveryCompat.res("block/common_torch_m"))
                .addTag(new class_2960("dangerclose:torch_burn_danger"), class_7924.field_41254)
                .noTab()
                .noItem()
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(stripped_soul_wall_torch);

        stripped_soul_torch = SimpleEntrySet.builder(WoodType.class, "log_soul_torch", "stripped",
                        getModBlock("stripped_oak_log_soul_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2527(class_4970.class_2251.method_9630(class_2246.field_22092), class_2398.field_22246)
                )
                //TEXTURES: stripped_soul_wall_torch
                .requiresChildren("stripped_log") //REASON: recipes
                .addTag(new class_2960("dangerclose:torch_burn_danger"), class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((s, b, p) -> new class_1827(b, stripped_soul_wall_torch.blocks.get(s), p, class_2350.field_11033))
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(stripped_soul_torch);

        stripped_redstone_wall_torch = SimpleEntrySet.builder(WoodType.class, "log_redstone_wall_torch", "stripped",
                        getModBlock("stripped_oak_log_redstone_wall_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2458(class_4970.class_2251.method_9630(class_2246.field_10301))
                )
                .requiresChildren("stripped_log") //REASON: textures
                .createPaletteFromChild("stripped_log")
                .addTextureM(modRes("block/stripped_oak_log_redstone_torch"), EveryCompat.res("block/common_redstone_torch_m"))
                .addTextureM(modRes("block/stripped_oak_log_redstone_torch_off"), EveryCompat.res("block/common_torch_m"))
                .noTab()
                .noItem()
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(stripped_redstone_wall_torch);

        stripped_redstone_torch = SimpleEntrySet.builder(WoodType.class, "log_redstone_torch", "stripped",
                        getModBlock("stripped_oak_log_redstone_torch"), () -> WoodTypeRegistry.OAK_TYPE,
                        woodType -> new class_2459(class_4970.class_2251.method_9630(class_2246.field_10523))
                )
                //TEXTURES: stripped_redstone_wall_torch
                .requiresChildren("stripped_log") //REASON: recipes
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((w, b, p) -> new class_1827(b, stripped_redstone_wall_torch.blocks.get(w), p, class_2350.field_11033))
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(stripped_redstone_torch);

    }
}