package net.mehvahdjukaar.every_compat.modules.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.client.model.DrawerModelGeometry;
import org.apache.commons.io.IOUtils;
import org.joml.Vector3f;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_793;

public class ModDrawersGeometry {
    private static boolean geometryDataLoaded = false;

    public static void loadGeometryData(StorageDrawersModule module, class_3300 manager) {
        if (geometryDataLoaded)
            return;

        geometryDataLoaded = true;

        populateGeometryData(modLoc("models/block/geometry/full_drawers_icon_area_1.json"),
                modLoc("models/block/geometry/full_drawers_count_area_1.json"),
                modLoc("models/block/geometry/full_drawers_ind_area_1.json"),
                modLoc("models/block/geometry/full_drawers_indbase_area_1.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, false).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/full_drawers_icon_area_2.json"),
                modLoc("models/block/geometry/full_drawers_count_area_2.json"),
                modLoc("models/block/geometry/full_drawers_ind_area_2.json"),
                modLoc("models/block/geometry/full_drawers_indbase_area_2.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, false).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/full_drawers_icon_area_4.json"),
                modLoc("models/block/geometry/full_drawers_count_area_4.json"),
                modLoc("models/block/geometry/full_drawers_ind_area_4.json"),
                modLoc("models/block/geometry/full_drawers_indbase_area_4.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, false).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/half_drawers_icon_area_1.json"),
                modLoc("models/block/geometry/half_drawers_count_area_1.json"),
                modLoc("models/block/geometry/half_drawers_ind_area_1.json"),
                modLoc("models/block/geometry/half_drawers_indbase_area_1.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, true).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/half_drawers_icon_area_2.json"),
                modLoc("models/block/geometry/half_drawers_count_area_2.json"),
                modLoc("models/block/geometry/half_drawers_ind_area_2.json"),
                modLoc("models/block/geometry/half_drawers_indbase_area_2.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, true).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/half_drawers_icon_area_4.json"),
                modLoc("models/block/geometry/half_drawers_count_area_4.json"),
                modLoc("models/block/geometry/half_drawers_ind_area_4.json"),
                modLoc("models/block/geometry/half_drawers_indbase_area_4.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, true).toArray(BlockDrawers[]::new)
        );

        populateGeometryData(modLoc("models/block/geometry/full_comp_drawers_icon_area_2.json"),
                modLoc("models/block/geometry/full_comp_drawers_count_area_2.json"),
                modLoc("models/block/geometry/full_comp_drawers_ind_area_2.json"),
                modLoc("models/block/geometry/full_comp_drawers_indbase_area_2.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, false).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/full_comp_drawers_icon_area_3.json"),
                modLoc("models/block/geometry/full_comp_drawers_count_area_3.json"),
                modLoc("models/block/geometry/full_comp_drawers_ind_area_3.json"),
                modLoc("models/block/geometry/full_comp_drawers_indbase_area_3.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, false).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/half_comp_drawers_icon_area_2.json"),
                modLoc("models/block/geometry/half_comp_drawers_count_area_2.json"),
                modLoc("models/block/geometry/half_comp_drawers_ind_area_2.json"),
                modLoc("models/block/geometry/half_comp_drawers_indbase_area_2.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, true).toArray(BlockDrawers[]::new)
        );
        populateGeometryData(modLoc("models/block/geometry/half_comp_drawers_icon_area_3.json"),
                modLoc("models/block/geometry/half_comp_drawers_count_area_3.json"),
                modLoc("models/block/geometry/half_comp_drawers_ind_area_3.json"),
                modLoc("models/block/geometry/half_comp_drawers_indbase_area_3.json"), manager,
                module.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, true).toArray(BlockDrawers[]::new)
        );
    }

    //FORGE use StorageDrawers.rl() and FABRIC use ModConstants.loc()
    private static class_2960 modLoc(String path) {
        return new class_2960("storagedrawers", path);
    }

    private static void populateGeometryData(class_2960 locationIcon,
                                             class_2960 locationCount,
                                             class_2960 locationInd,
                                             class_2960 locationIndBase, class_3300 manager,
                                             BlockDrawers... blocks) {
        class_793 slotInfo = getBlockModel(locationIcon, manager);
        class_793 countInfo = getBlockModel(locationCount, manager);
        class_793 indInfo = getBlockModel(locationInd, manager);
        class_793 indBaseInfo = getBlockModel(locationIndBase, manager);
        for (BlockDrawers block : blocks) {
            if (block == null)
                continue;

            for (int i = 0; i < block.getDrawerCount(); i++) {
                Vector3f from = slotInfo.method_3433().get(i).field_4228;
                Vector3f to = slotInfo.method_3433().get(i).field_4231;
                block.labelGeometry[i] = new class_238(from.x(), from.y(), from.z(), to.x(), to.y(), to.z());
            }
            for (int i = 0; i < block.getDrawerCount(); i++) {
                Vector3f from = countInfo.method_3433().get(i).field_4228;
                Vector3f to = countInfo.method_3433().get(i).field_4231;
                block.countGeometry[i] = new class_238(from.x(), from.y(), from.z(), to.x(), to.y(), to.z());
            }
            for (int i = 0; i < block.getDrawerCount(); i++) {
                Vector3f from = indInfo.method_3433().get(i).field_4228;
                Vector3f to = indInfo.method_3433().get(i).field_4231;
                block.indGeometry[i] = new class_238(from.x(), from.y(), from.z(), to.x(), to.y(), to.z());
            }
            for (int i = 0; i < block.getDrawerCount(); i++) {
                Vector3f from = indBaseInfo.method_3433().get(i).field_4228;
                Vector3f to = indBaseInfo.method_3433().get(i).field_4231;
                block.indBaseGeometry[i] = new class_238(from.x(), from.y(), from.z(), to.x(), to.y(), to.z());
            }
        }
    }

    private static class_793 getBlockModel(class_2960 location, class_3300 manager) {
        class_3298 iresource;
        Reader reader = null;
        try {
//            iresource = Minecraft.getInstance().getResourceManager().getResourceOrThrow(location);
//            reader = new InputStreamReader(iresource.open(), StandardCharsets.UTF_8);
            iresource =  manager.getResourceOrThrow(location);
            reader = new InputStreamReader(iresource.method_14482(), StandardCharsets.UTF_8);
            return class_793.method_3437(reader);
        } catch (IOException e) {
            return null;
        } finally {
            IOUtils.closeQuietly(reader);
        }
    }

}