/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ErrorMessageScreen
extends Screen {
    private final Screen lastScreen;
    private final Component text;
    private int ticksUntilEnable;
    private MultiLineLabel message = MultiLineLabel.EMPTY;
    private Button exitButton;
    private static final Component TITLE = Component.translatable((String)"gui.everycomp.error_screen.title").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD);

    public ErrorMessageScreen(Screen screen, int ticksUntilEnable, Component title, Component text) {
        super(title);
        this.lastScreen = screen;
        this.ticksUntilEnable = ticksUntilEnable;
        this.text = text;
    }

    @NotNull
    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration((Component[])new Component[]{super.getNarrationMessage(), this.text});
    }

    protected void init() {
        super.init();
        this.exitButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.quit"), pressed -> this.onClose()).bounds((this.width - 150) / 2, this.height * 5 / 6, 150, 20).build());
        this.exitButton.active = false;
        this.message = MultiLineLabel.create((Font)this.font, (Component)this.text, (int)(this.width - 50));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 30, 0xFFFFFF);
        this.message.renderCentered(graphics, this.width / 2, 55);
    }

    public void tick() {
        super.tick();
        if (--this.ticksUntilEnable <= 0) {
            this.exitButton.active = true;
        }
    }

    public boolean shouldCloseOnEsc() {
        return this.ticksUntilEnable <= 0;
    }

    public void onClose() {
        throw new RuntimeException("Every Compat encountered an error loading a module. Look at error below.");
    }

    public static ErrorMessageScreen create(Screen screen, List<String> mods) {
        return new ErrorMessageScreen(screen, 40, TITLE, (Component)Component.translatable((String)"gui.everycomp.error_screen.message", (Object[])new Object[]{Component.literal((String)String.join((CharSequence)", ", mods)).withStyle(ChatFormatting.GOLD)}));
    }
}

