/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import java.util.ArrayList;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class UtilityTexture {
    public static class_2960 modifyTexturePath(String baseTexturePath, String prefix, String shortenedId, String oldTypeName, BlockType blockType) {
        String infix = shortenedId + "/" + blockType.getNamespace() + "/";
        return EveryCompat.res(prefix + infix + baseTexturePath.substring(prefix.length()).replace(oldTypeName, blockType.getTypeName()));
    }

    public static void generateLogTexture(class_2960 baseTextureLoc, class_2960 logMaskLoc, class_2960 planksMaskLoc, String shortenedId, String oldTypeName, PaletteStrategy logPaletteStrategy, ResourceSink sink, class_3300 manager) {
        try (TextureImage mainTexture = TextureImage.open((class_3300)manager, (class_2960)baseTextureLoc);
             TextureImage logMask = TextureImage.open((class_3300)manager, (class_2960)logMaskLoc);
             TextureImage planksMask = TextureImage.open((class_3300)manager, (class_2960)planksMaskLoc);){
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                class_2960 newResLoc = UtilityTexture.modifyTexturePath(baseTextureLoc.method_12832(), "block/", shortenedId, oldTypeName, (BlockType)woodType);
                sink.addTextureIfNotPresent(manager, newResLoc, () -> {
                    try {
                        PaletteStrategy.PaletteAndAnimation logPalette = logPaletteStrategy.getPaletteAndAnimation((BlockType)woodType, manager);
                        PaletteStrategy.PaletteAndAnimation planksPalette = PaletteStrategies.PLANKS_STANDARD.getPaletteAndAnimation((BlockType)woodType, manager);
                        Respriter planksResprite = Respriter.masked((TextureImage)mainTexture, (TextureImage)logMask);
                        TextureImage recoloredInner = planksResprite.recolorWithAnimation(planksPalette.palette(), planksPalette.animation());
                        Respriter logResprite = Respriter.masked((TextureImage)recoloredInner, (TextureImage)planksMask);
                        return logResprite.recolorWithAnimation(logPalette.palette(), logPalette.animation());
                    }
                    catch (Exception e) {
                        EveryCompat.LOGGER.error("Failed to generate log texture: {} for {} - {}", (Object)baseTextureLoc, (Object)woodType.getId(), (Object)e);
                        return mainTexture;
                    }
                });
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to generate log texture: ", (Throwable)e);
        }
    }

    public static void applyLogAndswapPlanksTexture(class_2960 baseTextureLoc, class_2960 logMaskLoc, class_2960 planksMaskLoc, String shortenedId, String oldTypeName, ResourceSink sink, class_3300 manager) {
        try (TextureImage mainTexture = TextureImage.open((class_3300)manager, (class_2960)baseTextureLoc);
             TextureImage logMask = TextureImage.open((class_3300)manager, (class_2960)logMaskLoc);
             TextureImage planksMask = TextureImage.open((class_3300)manager, (class_2960)planksMaskLoc);){
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                class_2960 newPath = UtilityTexture.modifyTexturePath(baseTextureLoc.method_12832(), "block/", shortenedId, oldTypeName, (BlockType)woodType);
                sink.addTextureIfNotPresent(manager, newPath, () -> {
                    TextureImage textureImage;
                    block8: {
                        TextureImage logTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)woodType.log, CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                        try {
                            PaletteStrategy.PaletteAndAnimation planksPalette = PaletteStrategies.PLANKS_REMOVE_DARKEST.getPaletteAndAnimation((BlockType)woodType, manager);
                            TextureImage croppedTexture = logTexture.makeCopyWithMetadata(logTexture.getMcMeta());
                            TextureOps.applyMask((TextureImage)croppedTexture, (TextureImage)planksMask);
                            TextureOps.applyOverlay((TextureImage)mainTexture, (TextureImage[])new TextureImage[]{croppedTexture});
                            Respriter planksResprite = Respriter.masked((TextureImage)mainTexture, (TextureImage)logMask);
                            textureImage = planksResprite.recolorWithAnimation(planksPalette.palette(), planksPalette.animation());
                            if (logTexture == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (logTexture != null) {
                                    try {
                                        logTexture.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                EveryCompat.LOGGER.error("Failed to apply overlays & generate texture: {} for {} - {}", (Object)baseTextureLoc, (Object)woodType.getId(), (Object)e);
                                return mainTexture;
                            }
                        }
                        logTexture.close();
                    }
                    return textureImage;
                });
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to generate texture with logOverlay: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyLogAndGenerateTexture(class_2960 baseTextureLoc, class_2960 maskLoc, String shortenedId, String oldTypeName, ResourceSink sink, class_3300 manager) {
        try (TextureImage baseTexture = TextureImage.open((class_3300)manager, (class_2960)baseTextureLoc);
             TextureImage mask = TextureImage.open((class_3300)manager, (class_2960)maskLoc);){
            ArrayList<TextureImage> imagesToClose = new ArrayList<TextureImage>();
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                class_2960 newResLoc = UtilityTexture.modifyTexturePath(baseTextureLoc.method_12832(), "block/", shortenedId, oldTypeName, (BlockType)woodType);
                try {
                    TextureImage logTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)woodType.log, CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                    try {
                        TextureImage mainTexture = baseTexture.makeCopy();
                        TextureImage logOverlay = logTexture.makeCopy();
                        TextureOps.applyMask((TextureImage)logOverlay, (TextureImage)mask);
                        TextureOps.applyOverlay((TextureImage)mainTexture, (TextureImage[])new TextureImage[]{logOverlay});
                        sink.addTextureIfNotPresent(manager, newResLoc, () -> mainTexture);
                        imagesToClose.add(mainTexture);
                        imagesToClose.add(logOverlay);
                    }
                    finally {
                        if (logTexture == null) continue;
                        logTexture.close();
                    }
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to apply overlays to texture: {} for {} - {}", (Object)baseTextureLoc, (Object)woodType.getId(), (Object)e);
                }
                finally {
                    imagesToClose.forEach(TextureImage::close);
                }
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to generate texture: ", (Throwable)e);
        }
    }
}

