package net.mehvahdjukaar.every_compat.modules.decorative_blocks;


import lilypuree.decorative_blocks.blocks.types.IWoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.class_2248;

public class DBWoodType implements IWoodType {

    private final WoodType woodType;

    public DBWoodType(WoodType type){
        this.woodType = type;
    }

    public WoodType type() {
        return woodType;
    }

    @Override
    public String namespace() {
        return woodType.getNamespace();
    }

    @Override
    public class_2248 getLog() {
        return woodType.log;
    }

    @Override
    public class_2248 getStrippedLog() {
        return woodType.getBlockOfThis("stripped_log");
    }

    @Override
    public class_2248 getSlab() {
        return woodType.getBlockOfThis("slab");
    }

    @Override
    public class_2248 getFence() {
        return woodType.getBlockOfThis("fence");
    }

    @Override
    public class_2248 getPlanks() {
        return woodType.planks;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isFlammable() {
        return woodType.canBurn();
    }
}