package net.mehvahdjukaar.every_compat.modules.fabric.create;

import com.simibubi.create.CreateClient;
import com.simibubi.create.content.decoration.palettes.ConnectedGlassPaneBlock;
import com.simibubi.create.content.decoration.palettes.WindowBlock;
import com.simibubi.create.foundation.block.connected.*;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.modules.create.CreateAbstractModule;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

// SUPPORT: v0.5.1+
public class CreateModule extends CreateAbstractModule {

    public CreateModule(String modId) {
        super(modId);
    }

    protected WindowBlock makeWindow(WoodType w) {
        return new WindowBlock(Utils.copyPropertySafe(class_2246.field_10033)
                .method_26235((s, l, ps, t) -> false)
                .method_26236((s, l, ps) -> false)
                .method_26243((s, l, ps) -> false)
                .method_26245((s, l, ps) -> false),
                false);
    }

    @Override
    protected class_2248 makeConnectedGlassPane(WoodType woodType) {
        return new ConnectedGlassPaneBlock(Utils.copyPropertySafe(class_2246.field_10285));
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void onClientSetup() {
        super.onClientSetup();
        CreateClientModule.clientStuff(this);
    }

    @Environment(EnvType.CLIENT)
    private static class CreateClientModule {
        private static void clientStuff(CreateModule module) {
            module.windows.blocks.forEach((woodType, block) -> {
                String path = woodType.createFullIdWith("", "block", module.shortenedId(), "palettes/", "window");

                CTSpriteShiftEntry spriteShift = CTSpriteShifter.getCT(AllCTTypes.VERTICAL,
                        EveryCompat.res(path), EveryCompat.res(path + "_connected"));

                CreateClient.MODEL_SWAPPER.getCustomBlockModels().register(Utils.getID(block),
                        model -> new CTModel(model, new HorizontalCTBehaviour(spriteShift)));
                CreateClient.MODEL_SWAPPER.getCustomBlockModels().register(Utils.getID(module.windowPanes.blocks.get(woodType)),
                        model -> new CTModel(model, new GlassPaneCTBehaviour(spriteShift)));
            });
        }
    }

}