package net.mehvahdjukaar.every_compat.modules.lieonlion;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.every_compat.common_classes.CompatTrappedChestBlock;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1761;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import java.util.function.Consumer;

import static net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture.generateChestTexture;

//SUPPORT: v1.5.6+
public class MoreChestVariantsModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> chests;
    public final SimpleEntrySet<WoodType, class_2248> trappedChests;

    public MoreChestVariantsModule(String modID) {
        super(modID, "mcv");
        class_5321<class_1761> functionalTab = class_7706.field_40197;
        class_5321<class_1761> redstoneTab = class_7706.field_40198;

        String namespace = (PlatHelper.getPlatform().isForge()) ? "forge" : "c";

        chests = SimpleEntrySet.builder(WoodType.class, "chest",
                        getModBlock("oak_chest"), () -> VanillaWoodTypes.OAK,
                        w -> new CompatChestBlock(this::getChestTile,
                                Utils.copyPropertySafe(class_2246.field_10034).method_31710(class_3620.field_15996))
                )
                .addModelTransform(m -> m.addModifier((s, blockId, woodType) ->
                    s.replace("\"lolmcv:entity/chest/oak\"",
                            "\""+woodType.createFullIdWith(EveryCompat.MOD_ID, "entity/chest", shortenedId(), "", "chest")+"\"" )
                ))
                .addTile(MoreChestBlockEntity::new)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_23800, class_7924.field_41254)
                .addTag(new class_2960("lieonstudio:chests/wooden"), class_7924.field_41254)
                .addTag(new class_2960("lieonstudio:chests/normal"), class_7924.field_41254)
                .addTag(new class_2960(namespace, "chests"), class_7924.field_41254)
                .addTag(new class_2960(namespace, "chests/wooden"), class_7924.field_41254)
                .addTag(new class_2960("quad", "cats_on_blocks/sit"), class_7924.field_41254)
                .addTag(new class_2960("quad", "fuel/wood"), class_7924.field_41197)
                .addTag(new class_2960(namespace, "chests"), class_7924.field_41197)
                .addTag(new class_2960(namespace, "chests/wooden"), class_7924.field_41197)
                .addTag(new class_2960("lieonstudio:chests/normal"), class_7924.field_41197)
                .addTag(new class_2960("lieonstudio:chests/wooden"), class_7924.field_41197)
                .setTabKey(functionalTab)
                .defaultRecipe()
                .build();
        this.addEntry(chests);

        trappedChests = SimpleEntrySet.builder(WoodType.class, "trapped_chest",
                        getModBlock("oak_trapped_chest"), () -> VanillaWoodTypes.OAK,
                        w -> new CompatTrappedChestBlock(this::getTrappedTile,
                                Utils.copyPropertySafe(class_2246.field_10380).method_31710(class_3620.field_15996))
                )
                .addModelTransform(m -> m.addModifier((s, blockId, woodType) ->
                    s.replace("\"lolmcv:entity/chest/trapped/oak\"",
                            "\""+woodType.createFullIdWith(EveryCompat.MOD_ID, "entity/chest", shortenedId(), "", "trapped_chest")+"\"" )
                ))
                .addTile(MoreTrappedBlockEntity::new)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_23800, class_7924.field_41254)
                .addTag(new class_2960("lieonstudio:chests/wooden"), class_7924.field_41254)
                .addTag(new class_2960("lieonstudio:chests/trapped"), class_7924.field_41254)
                .addTag(new class_2960(namespace, "chests"), class_7924.field_41254)
                .addTag(new class_2960(namespace, "chests/wooden"), class_7924.field_41254)
                .addTag(new class_2960("quad", "fuel/wood"), class_7924.field_41197)
                .addTag(new class_2960("lieonstudio:chests/trapped"), class_7924.field_41197)
                .addTag(new class_2960("lieonstudio:chests/wooden"), class_7924.field_41197)
                .addTag(new class_2960(namespace, "chests"), class_7924.field_41197)
                .addTag(new class_2960(namespace, "chests/wooden"), class_7924.field_41197)
                .setTabKey(redstoneTab)
                .defaultRecipe()
                .build();
        this.addEntry(trappedChests);

    }

    // GetTile ---------------------------------------------------------------------------------------------------------
    private class_2591<? extends class_2595> getChestTile() {
        return chests.getTile(CompatChestBlockEntity.class);
    }

    private class_2591<? extends class_2595> getTrappedTile() {
        return trappedChests.getTile(CompatChestBlockEntity.class);
    }

    // BlockEntity -----------------------------------------------------------------------------------------------------
    private class MoreChestBlockEntity extends CompatChestBlockEntity {
        public MoreChestBlockEntity(class_2338 pos, class_2680 state) {
            super(chests.getTile(), pos, state);
        }
    }

    private class MoreTrappedBlockEntity extends CompatChestBlockEntity {
        public MoreTrappedBlockEntity(class_2338 pos, class_2680 state) {
            super(trappedChests.getTile(), pos, state);
        }
    }

    // Registry --------------------------------------------------------------------------------------------------------
    @Override
    @Environment(EnvType.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, chests.getTile(CompatChestBlockEntity.class), shortenedId());
        CompatChestBlockRenderer.register(event, trappedChests.getTile(CompatChestBlockEntity.class), shortenedId());
    }

    // Textures
    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);

        executor.accept((manager, sink) -> {
            trappedChests.blocks.forEach((wood, block) -> {
                // SINGLE
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/oak"),
                        EveryCompat.res("entity/mcv_chest_normal_m"),
                        EveryCompat.res("entity/mcv_chest_normal_o"),
                        EveryCompat.res("entity/mcv_trapped_normal_o"), 0
                );
                // LEFT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/oak_left"),
                        EveryCompat.res("entity/mcv_chest_left_m"),
                        EveryCompat.res("entity/mcv_chest_left_o"),
                        EveryCompat.res("entity/mcv_trapped_left_o"), 0
                );
                // RIGHT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/oak_right"),
                        EveryCompat.res("entity/mcv_chest_right_m"),
                        EveryCompat.res("entity/mcv_chest_right_o"),
                        EveryCompat.res("entity/mcv_trapped_right_o"), 0
                );

                // MODEL BLOCK
                String path = shortenedId() + "/" + wood.getAppendableId() + "_chest";
                String trapped_path = shortenedId() + "/" + wood.getAppendableId() + "_trapped_chest";

            });

        });
    }

}
