/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.beautiful_campfires;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_3922;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class BeautifulCampfiresModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, class_3922> campfires;
    public final SimpleEntrySet<WoodType, class_3922> soul_campfires;

    public BeautifulCampfiresModule(String modId) {
        super(modId, "bc");
        class_5321 tab = class_7706.field_40197;
        this.campfires = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "campfire", this.getModBlock("acacia_campfire", class_3922.class), () -> VanillaWoodTypes.ACACIA, w -> new class_3922(true, 1, this.copyProperties(15))).addTile(() -> class_2591.field_17380).addTextureM(this.modRes("item/acacia_campfire"), EveryCompat.res("item/bc/campfire_m"))).addTextureM(this.modRes("item/acacia_soul_campfire"), EveryCompat.res("item/bc/campfire_m"))).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(class_3481.field_23799, class_7924.field_41254)).setTabKey(tab)).build();
        this.addEntry(this.campfires);
        this.soul_campfires = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "soul_campfire", this.getModBlock("acacia_soul_campfire", class_3922.class), () -> VanillaWoodTypes.ACACIA, w -> new class_3922(true, 2, this.copyProperties(10))).addTile(() -> class_2591.field_17380).addTextureM(this.modRes("block/acacia_campfire_log_lit"), EveryCompat.res("block/bc/campfire_log_lit_m"), PaletteStrategies.LOG_SIDE_STANDARD)).addTextureM(this.modRes("block/acacia_soul_campfire_log_lit"), EveryCompat.res("block/bc/campfire_log_lit_m"), PaletteStrategies.LOG_SIDE_STANDARD)).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(class_3481.field_23799, class_7924.field_41254)).addTag(class_3481.field_22465, class_7924.field_41254)).setTabKey(tab)).build();
        this.addEntry(this.soul_campfires);
    }

    public class_4970.class_2251 copyProperties(int pLightValue) {
        return class_4970.class_2251.method_9637().method_31710(class_3620.field_16017).method_51368(class_2766.field_12651).method_9632(2.0f).method_9626(class_2498.field_11547).method_9631(BeautifulCampfiresModule.litBlockEmission(pLightValue)).method_22488().method_50013();
    }

    @NotNull
    private static ToIntFunction<class_2680> litBlockEmission(int pLightValue) {
        return state -> (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? pLightValue : 0;
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, handler) -> {
            class_2960 campfireLoc = this.modRes("acacia_campfire");
            class_2960 soulCampfireLoc = this.modRes("acacia_soul_campfire");
            this.campfires.blocks.forEach((wood, block) -> {
                this.createRecipe("campfire", (WoodType)wood, (class_2248)block, campfireLoc, handler, manager);
                this.createRecipe("soul_campfire", (WoodType)wood, (class_2248)this.soul_campfires.blocks.get(wood), soulCampfireLoc, handler, manager);
            });
        });
    }

    public void createRecipe(String recipeName, WoodType woodType, class_2248 output, class_2960 recipeLoc, ResourceSink handler, class_3300 manager) {
        try (InputStream recipeStream = ((class_3298)manager.method_14486(ResType.RECIPES.getPath(recipeLoc)).orElseThrow(() -> new FileNotFoundException("File not found @ " + recipeLoc))).method_14482();){
            JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
            recipe.getAsJsonObject("key").getAsJsonObject("L").addProperty("tag", TagUtility.getATagOrCreateANew("logs", "caps", (BlockType)woodType, handler, manager).toString());
            recipe.getAsJsonObject("result").addProperty("item", Utils.getID((class_2248)output).toString());
            handler.addJson(EveryCompat.res(this.shortenedId() + "/" + woodType.getAppendableId() + "_" + recipeName), (JsonElement)recipe, ResType.RECIPES);
        }
        catch (IOException e) {
            EveryCompat.LOGGER.error("Failed to generate the {} recipe for {} : {}", (Object)recipeName, (Object)woodType.getId(), (Object)e);
        }
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept(this::makeCampfireTextures);
    }

    private void makeCampfireTextures(class_3300 manager, ResourceSink sink) {
        String campfirePath = "block/acacia_campfire_log";
        class_2960 campfireImage = this.modRes(campfirePath);
        class_2960 targetLogMask = EveryCompat.res("block/bc/campfire_log_m");
        class_2960 targetPlankMask = EveryCompat.res("block/bc/campfire_plank_m");
        try (TextureImage textureImage = TextureImage.open((class_3300)manager, (class_2960)campfireImage);
             TextureImage targetLogImage = TextureImage.open((class_3300)manager, (class_2960)targetLogMask);
             TextureImage targetPlankImage = TextureImage.open((class_3300)manager, (class_2960)targetPlankMask);){
            Respriter respriterLog = Respriter.masked((TextureImage)textureImage, (TextureImage)targetLogImage);
            this.campfires.blocks.forEach((wood, block) -> {
                class_2960 id = Utils.getID((class_2248)block);
                try (TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));
                     TextureImage logTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.log, CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));){
                    String newPath = BlockTypeResTransformer.replaceTypeNoNamespace((String)campfirePath, (BlockType)wood, (class_2960)id, (String)"acacia");
                    sink.addTextureIfNotPresent(manager, newPath, () -> {
                        try (TextureImage recoloredLog = respriterLog.recolorWithAnimationOf(logTexture);){
                            Respriter respriterPlank = Respriter.masked((TextureImage)recoloredLog, (TextureImage)targetPlankImage);
                            TextureImage textureImage = respriterPlank.recolorWithAnimationOf(plankTexture);
                            return textureImage;
                        }
                    });
                }
                catch (IOException e) {
                    EveryCompat.LOGGER.error("Failed to open log/plank texture file: ", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            EveryCompat.LOGGER.error("Failed to open texture file: ", (Throwable)e);
        }
    }
}

