package net.mehvahdjukaar.every_compat.modules.neoforge.workshop;

import moonfather.workshop_for_handsome_adventurer.blocks.*;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import moonfather.workshop_for_handsome_adventurer.items.BlockItemEx;
import moonfather.workshop_for_handsome_adventurer.items.WorkstationPlacerItem;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.neoforge.EveryCompatForge;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

import static net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys.STRIPPED_LOG;

//SUPPORT: v1.31.2+
public class WorkshopForHandsomeAdventurerModule extends SimpleModule {
    private static final ResourceLocation TAG_FORGE_WORKBENCH = ResourceLocation.fromNamespaceAndPath("c", "workbench");
    private static final ResourceLocation TAG_PACKINGTAPE_BLACKLIST = ResourceLocation.fromNamespaceAndPath("packingtape", "te_blacklist");
    public final SimpleEntrySet<WoodType, Block> double_bookshelves, open_double_bookshelves, min_bookshelves, open_min_bookshelves, lantern_bookshelves;
    public final SimpleEntrySet<WoodType, Block> simple_tables, potionshelves1, dual_table_parts_bl, dual_table_parts_br, dual_table_parts_tl, dual_table_parts_tr;
    public final SimpleEntrySet<WoodType, Block> framed_toolracks, pframed_toolracks, double_toolracks, single_toolracks;
    public final ItemOnlyEntrySet<WoodType, Item> station_placers;

    public WorkshopForHandsomeAdventurerModule(String modId) {
        super(modId, "wfha");
        ResourceLocation tab = modRes(modId);

        double_bookshelves = SimpleEntrySet.builder(WoodType.class, "", "book_shelf_double",
                        getModBlock("book_shelf_double_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new BookShelf.Dual("double")
                )
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .addTag(TAG_PACKINGTAPE_BLACKLIST, Registries.BLOCK)
                .addRecipe(modRes("book_shelf_double_spruce"))
                .setTabKey(tab)
                .addTile(Registration.BOOK_SHELF_BE)
                .addCustomItem((wood, block, prop) -> new BlockItemEx( block, prop))
                .build();
        this.addEntry(double_bookshelves);

        open_double_bookshelves = SimpleEntrySet.builder(WoodType.class, "", "book_shelf_open_double",
                        getModBlock("book_shelf_open_double_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new BookShelf.Dual("open_double")
                )
                .addTile(Registration.BOOK_SHELF_BE)
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .addTag(TAG_PACKINGTAPE_BLACKLIST, Registries.BLOCK)
                .addRecipe(modRes("book_shelf_open_double_spruce"))
                .setTabKey(tab)
                .addCustomItem((wood, block, prop) -> new BlockItemEx(block, prop))
                .build();
        this.addEntry(open_double_bookshelves);

        min_bookshelves = SimpleEntrySet.builder(WoodType.class, "", "book_shelf_minimal",
                        getModBlock("book_shelf_minimal_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new BookShelf.TopSimple("minimal")
                )
                .addTile(Registration.BOOK_SHELF_BE)
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .addTag(TAG_PACKINGTAPE_BLACKLIST, Registries.BLOCK)
                .defaultRecipe()
                .setTabKey(tab)
                .addCustomItem((wood, block, prop) -> new BlockItemEx(block, prop))
                .build();
        this.addEntry(min_bookshelves);

        open_min_bookshelves = SimpleEntrySet.builder(WoodType.class, "", "book_shelf_open_minimal",
                        getModBlock("book_shelf_open_minimal_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new BookShelf.TopSimple("open_minimal")
                )
                .addTile(Registration.BOOK_SHELF_BE)
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .addTag(TAG_PACKINGTAPE_BLACKLIST, Registries.BLOCK)
                .addRecipe(modRes("book_shelf_open_minimal_spruce"))
                .addRecipe(modRes("book_shelf_open_minimal_from_double_spruce"))
                .setTabKey(tab)
                .addCustomItem((wood, block, prop) -> new BlockItemEx(block, prop))
                .build();
        this.addEntry(open_min_bookshelves);

        lantern_bookshelves = SimpleEntrySet.builder(WoodType.class, "", "book_shelf_with_lanterns",
                        getModBlock("book_shelf_with_lanterns_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new BookShelf.TopWithLanterns("with_lanterns")
                )
                .addTile(Registration.BOOK_SHELF_BE)
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .addTag(TAG_PACKINGTAPE_BLACKLIST, Registries.BLOCK)
                .defaultRecipe()
                .setTabKey(tab)
                .addCustomItem((wood, block, prop) -> new BlockItemEx(block, prop))
                .build();
        this.addEntry(lantern_bookshelves);

        simple_tables = SimpleEntrySet.builder(WoodType.class, "", "simple_table",
                        getModBlock("simple_table_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        (w) -> new SimpleTable()
                )
                .requiresChildren(STRIPPED_LOG)
                .addTile(Registration.SIMPLE_TABLE_BE)
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .addTag(TAG_FORGE_WORKBENCH, Registries.BLOCK)
                .addTag(TAG_FORGE_WORKBENCH, Registries.ITEM)
                .setTabKey(tab)
                .addRecipe(modRes("simple_table_normal_spruce"))
                .addRecipe(modRes("simple_table_replacement_spruce"))
                .addCustomItem((wood, block, prop) -> new BlockItemEx(block, prop))
                .build();
        this.addEntry(simple_tables);

        framed_toolracks = SimpleEntrySet.builder(WoodType.class, "", "tool_rack_framed",
                        getModBlock("tool_rack_framed_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new DualToolRack(6, "framed")
                )
                .addTile(Registration.TOOL_RACK_BE)
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .addTag(TAG_PACKINGTAPE_BLACKLIST, Registries.BLOCK)
                .setTabKey(tab)
                .defaultRecipe()
                .copyParentDrop()
                .addCustomItem((wood, block, prop) -> new BlockItemEx(block, prop))
                .build();
        this.addEntry(framed_toolracks);

        pframed_toolracks = SimpleEntrySet.builder(WoodType.class, "", "tool_rack_pframed",
                        getModBlock("tool_rack_pframed_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new DualToolRack(6, "pframed")
                )
                .addTile(Registration.TOOL_RACK_BE)
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .addTag(TAG_PACKINGTAPE_BLACKLIST, Registries.BLOCK)
                .setTabKey(tab)
                .defaultRecipe()
                .copyParentDrop()
                .addCustomItem((wood, block, prop) -> new BlockItemEx(block, prop))
                .build();
        this.addEntry(pframed_toolracks);

        double_toolracks = SimpleEntrySet.builder(WoodType.class, "", "tool_rack_double",
                        getModBlock("tool_rack_double_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new DualToolRack(6, "double")
                )
                .addTile(Registration.TOOL_RACK_BE)
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .addTag(TAG_PACKINGTAPE_BLACKLIST, Registries.BLOCK)
                .setTabKey(tab)
                .defaultRecipe()
                .copyParentDrop()
                .addCustomItem((wood, block, prop) -> new BlockItemEx(block, prop))
                .build();
        this.addEntry(double_toolracks);

        single_toolracks = SimpleEntrySet.builder(WoodType.class, "", "tool_rack_single",
                        getModBlock("tool_rack_single_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new ToolRack(2, "single")
                )
                .addTile(Registration.TOOL_RACK_BE)
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .addTag(TAG_PACKINGTAPE_BLACKLIST, Registries.BLOCK)
                .setTabKey(tab)
                .defaultRecipe()
                .addRecipe(modRes("tool_rack_single_from_multi_spruce"))
                .addCustomItem((wood, block, prop) -> new BlockItemEx(block, prop))
                .build();
        this.addEntry(single_toolracks);

        potionshelves1 = SimpleEntrySet.builder(WoodType.class, "", "potion_shelf",
                        getModBlock("potion_shelf_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new PotionShelf()
                )
                .addTile(Registration.POTION_SHELF_BE)
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .addTag(TAG_PACKINGTAPE_BLACKLIST, Registries.BLOCK)
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((wood, block, prop) -> new BlockItemEx(block, prop))
                .build();
        this.addEntry(potionshelves1);

        dual_table_parts_tr = SimpleEntrySet.builder(WoodType.class, "", "dual_table_top_right",
                        getModBlock("dual_table_top_right_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new AdvancedTableTopSecondary()
                )
                .requiresChildren(STRIPPED_LOG)
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .noItem().noTab()
                .build();
        this.addEntry(dual_table_parts_tr);

        dual_table_parts_tl = SimpleEntrySet.builder(WoodType.class, "", "dual_table_top_left",
                        getModBlock("dual_table_top_left_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new AdvancedTableTopSecondary()
                )
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .noItem().noTab()
                .requiresChildren(STRIPPED_LOG)
                .build();
        this.addEntry(dual_table_parts_tl);

        dual_table_parts_br = SimpleEntrySet.builder(WoodType.class, "", "dual_table_bottom_right",
                        getModBlock("dual_table_bottom_right_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new AdvancedTableBottomSecondary()
                )
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .noItem().noTab()
                .requiresChildren(STRIPPED_LOG)
                .build();
        this.addEntry(dual_table_parts_br);

        dual_table_parts_bl = SimpleEntrySet.builder(WoodType.class, "", "dual_table_bottom_left",
                        getModBlock("dual_table_bottom_left_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new AdvancedTableBottomPrimary()
                )
                .addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)
                .addTag(TAG_PACKINGTAPE_BLACKLIST, Registries.BLOCK)
                .requiresChildren(STRIPPED_LOG)
                .noItem().noTab()
                .addTile(Registration.DUAL_TABLE_BE)
                .build();
        this.addEntry(dual_table_parts_bl);

        station_placers = ItemOnlyEntrySet.builder(WoodType.class,"", "workstation_placer",
                        getModItem("workstation_placer_spruce"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new WorkstationPlacerItem(w.getTypeName(), new Item.Properties())
                )
                .requiresFromMap(dual_table_parts_bl.blocks)
                .noTab()
                .addRecipe(modRes("workstation_placer_spruce"))
                .build();
        this.addEntry(station_placers);

    }

    @Override
    // TAGS
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);

        // we need to generate tag file for supported planks
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(modRes("supported_planks"));
        executor.accept((manager, sink) -> {
            simple_tables.blocks.forEach((w, value) -> tagBuilder.add(Utils.getID(w.planks.asItem())));
            sink.addTag(tagBuilder, Registries.ITEM);
        });
    }

    @Override
    public void onModInit() {
        EveryCompatForge.getModEventBus().addListener(WorkshopForHandsomeAdventurerModule::sendIMC);
    }

    public static void sendIMC(final InterModEnqueueEvent event) {
        ArrayList<String> blacklist = new ArrayList<>();
        for (WoodType w : WoodTypeRegistry.INSTANCE) {
            if (!w.getNamespace().equals("minecraft")) {
                // we need to tell carry on not to break our multiblock structures
                blacklist.add(MessageFormat.format("{0}:wfha/{1}/tool_rack_double_{2}", EveryCompat.MOD_ID, w.getNamespace(), w.getTypeName()));
                blacklist.add(MessageFormat.format("{0}:wfha/{1}/tool_rack_framed_{2}", EveryCompat.MOD_ID, w.getNamespace(), w.getTypeName()));
                blacklist.add(MessageFormat.format("{0}:wfha/{1}/tool_rack_pframed_{2}", EveryCompat.MOD_ID, w.getNamespace(), w.getTypeName()));
                if (w.getBlockOfThis("stripped_log") != null) {
                    blacklist.add(MessageFormat.format("{0}:wfha/{1}/dual_table_bottom_left_{2}", EveryCompat.MOD_ID, w.getNamespace(), w.getTypeName()));
                    blacklist.add(MessageFormat.format("{0}:wfha/{1}/dual_table_bottom_right_{2}", EveryCompat.MOD_ID, w.getNamespace(), w.getTypeName()));
                    blacklist.add(MessageFormat.format("{0}:wfha/{1}/dual_table_top_left_{2}", EveryCompat.MOD_ID, w.getNamespace(), w.getTypeName()));
                    blacklist.add(MessageFormat.format("{0}:wfha/{1}/dual_table_top_right_{2}", EveryCompat.MOD_ID, w.getNamespace(), w.getTypeName()));
                    // we need to register things for the workstation placer item - so that it knows what blocks to use
//                    ExternalWoodSupport.registerHostMod(w.getTypeName(), EveryCompat.MOD_ID);
//                    ExternalWoodSupport.registerPrefix(w.getTypeName(), "wfha/" + w.getNamespace() + "/");
                }
            }
        }
        for (String block : blacklist) {
            InterModComms.sendTo("carryon", "blacklistBlock", () -> block);
        }
    }

    @Override
    public List<String> getAlreadySupportedMods() {
        return List.of("biomesoplenty");
    }
}
