/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.neoforge.just_a_raft;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrbysco.justaraftmod.entities.RaftType;
import com.mrbysco.justaraftmod.items.RaftItem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.ItemOnlyEntrySet;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.UtilityTag;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;

public class JustARaftModule
extends SimpleModule {
    public final ItemOnlyEntrySet<WoodType, Item> rafts;
    public final Map<WoodType, RaftType> raftTypes = new HashMap<WoodType, RaftType>();

    public JustARaftModule(String modId) {
        super(modId, "jar");
        ResourceLocation tab = this.modRes("tab");
        this.rafts = ((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)((ItemOnlyEntrySet.Builder)ItemOnlyEntrySet.builder(WoodType.class, "raft", this.getModItem("oak_raft"), () -> VanillaWoodTypes.OAK, woodType -> new RaftItem(this.getRaftType((WoodType)woodType), new Item.Properties())).addTextureM(this.modRes("entity/raft/oak_raft"), EveryCompat.res("entity/raft/oak_raft_m"), PaletteStrategies.LOG_SIDE_STANDARD)).addTag(this.modRes("rafts"), Registries.ITEM)).setTabKey(tab)).build();
        this.addEntry(this.rafts);
    }

    private RaftType getRaftType(WoodType w) {
        String name = this.shortenedId() + "/" + w.getAppendableId();
        return this.raftTypes.computeIfAbsent(w, woodType -> RaftType.registerRaftType((RaftType)new RaftType(w.planks, (Holder)DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)EveryCompat.res(name + "_raft")), name, EveryCompat.res("textures/entity/raft/" + name + "_raft.png"))));
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> {
            ResourceLocation recipeLoc = ResType.RECIPES.getPath(this.modRes("oak_raft"));
            this.rafts.items.forEach((wood, item) -> {
                try (InputStream recipeStrem = ((Resource)manager.getResource(recipeLoc).orElseThrow(() -> new FileNotFoundException("Failed to open the recipe @ " + String.valueOf(recipeLoc)))).open();){
                    JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStrem);
                    recipe.getAsJsonObject("key").getAsJsonObject("L").addProperty("tag", UtilityTag.getATagOrCreateANew("logs", "caps", (BlockType)wood, sink, manager).toString());
                    recipe.getAsJsonObject("result").addProperty("id", Utils.getID((Item)item).toString());
                    String newRecipeLoc = this.shortenedId() + "/" + wood.getAppendableId() + "_raft";
                    sink.addJson(EveryCompat.res(newRecipeLoc), (JsonElement)recipe, ResType.RECIPES);
                }
                catch (IOException e) {
                    EveryCompat.LOGGER.error("Failed to generate recipes for {} : {}", item, (Object)e);
                }
            });
        });
    }
}

