/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompatClient;
import net.mehvahdjukaar.every_compat.api.AbstractSimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.api.TextureInfo;
import net.mehvahdjukaar.every_compat.misc.ModelConfiguration;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.item.BlockTypeBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleEntrySet<T extends BlockType, B extends Block>
extends AbstractSimpleEntrySet<T, B, Item> {
    protected final Supplier<@Nullable B> baseBlock;
    protected final Function<T, @Nullable B> blockFactory;
    @Nullable
    protected final @Nullable TriFunction<T, B, // Could not load outer class - annotation placement on inner may be incorrect
    Item.Properties, @Nullable Item> itemFactory;
    @Nullable
    protected final ITileHolder<?> tileHolder;
    protected final LootTableMode lootMode;
    @Nullable
    protected final Object renderType;
    protected ModelConfiguration modelConfiguration;
    protected static final boolean YEET_JSONS = true;
    protected static final Set<Block> SIMPLE_DROPS = new HashSet<Block>();

    @Deprecated(forRemoval=true)
    public SimpleEntrySet(Class<T> type, String name, String prefix, Function<T, B> blockSupplier, Supplier<@Nullable B> baseBlock, Supplier<T> baseType, @NotNull Supplier<ResourceKey<CreativeModeTab>> tab, TabAddMode tabMode, LootTableMode lootMode, @Nullable TriFunction<T, B, Item.Properties, Item> itemFactory, @Nullable ITileHolder<?> tileFactory, @Nullable Object renderType, BiFunction<T, ResourceManager, PaletteStrategy.PaletteAndAnimation> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergedPalette, boolean copyTint, Predicate<T> condition) {
        this(type, name, prefix, blockSupplier, baseBlock, baseType, tab, tabMode, lootMode, itemFactory, tileFactory, renderType, paletteSupplier, extraTransform, mergedPalette, copyTint, condition, ModelConfiguration.EMPTY);
    }

    public SimpleEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, B> blockSupplier, Supplier<@Nullable B> baseBlock, Supplier<T> baseType, @NotNull Supplier<ResourceKey<CreativeModeTab>> tab, TabAddMode tabMode, LootTableMode lootMode, @Nullable TriFunction<T, B, Item.Properties, Item> itemFactory, @Nullable ITileHolder<?> tileFactory, @Nullable Object renderType, @Nullable BiFunction<T, ResourceManager, PaletteStrategy.PaletteAndAnimation> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergedPalette, boolean copyTint, Predicate<T> condition, ModelConfiguration modelConfig) {
        super(type, name, prefix, baseType, tab, tabMode, paletteSupplier, extraTransform, mergedPalette, copyTint, condition);
        this.blockFactory = blockSupplier;
        this.tileHolder = tileFactory;
        this.lootMode = lootMode;
        this.baseBlock = baseBlock;
        this.itemFactory = itemFactory;
        this.renderType = renderType;
        this.modelConfiguration = modelConfig;
    }

    public <E extends BlockEntity> BlockEntityType<E> getTile(Class<E> tileClass) {
        Preconditions.checkNotNull(this.tileHolder, (Object)"Entry set has no tile entity!");
        return this.tileHolder.get();
    }

    public BlockEntityType<?> getTile() {
        Preconditions.checkNotNull(this.tileHolder, (Object)"Entry set has no tile entity!");
        return this.tileHolder.get();
    }

    public B getBaseBlock() {
        return (B)((Block)this.baseBlock.get());
    }

    @Override
    public void addTranslations(SimpleModule module, AfterLanguageLoadEvent lang) {
        this.blocks.forEach((w, v) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)("block_type." + module.getModId() + "." + this.typeName), (BlockType)w, (Block)v));
    }

    @Override
    public void registerBlocks(SimpleModule module, Registrator<Block> registry, Collection<T> types) {
        Block block;
        B base = this.getBaseBlock();
        if (base == null || base == Blocks.AIR) {
            throw new UnsupportedOperationException("Base block cant be null (" + this.typeName + " for " + module.modId + " module)");
        }
        String childKey = this.getChildKey(module);
        if (childKey.contains("minecraft")) {
            childKey = childKey.replace("minecraft:", "");
        }
        for (BlockType w : types) {
            String name = this.getBlockName(w);
            String fullName = module.shortenedId() + "/" + w.getNamespace() + "/" + name;
            String entrySetId = module.getModId() + ":" + this.typeName;
            if (module.isEntryAlreadyRegistered(entrySetId, name, w, (Registry<?>)BuiltInRegistries.BLOCK) || !this.condition.test(w) || (block = (Block)this.blockFactory.apply(w)) == null) continue;
            this.blocks.put(w, block);
            ResourceLocation resourceLocation = module.makeMyRes(fullName);
            if (resourceLocation.toString().equals("minecraft:air")) {
                throw new UnsupportedOperationException("Attempted to register a Block of wood type " + String.valueOf(w) + " from module " + String.valueOf(this) + " has an invalid item name. How?");
            }
            registry.register(resourceLocation, (Object)block);
            w.addChild(childKey, (Object)block);
            if (this.lootMode != LootTableMode.DROP_SELF) continue;
            SIMPLE_DROPS.add(block);
        }
        try {
            ((BlockType)this.baseType.get()).addChild(childKey, base);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashSet<String> alreadySupportedMods = new HashSet<String>(module.getAlreadySupportedMods());
        alreadySupportedMods.add(module.modId);
        String[] possibleNamespaces = (String[])alreadySupportedMods.toArray(String[]::new);
        for (BlockType w : Objects.requireNonNull(BlockSetAPI.getTypeRegistry(this.getTypeClass())).getValues()) {
            if (this.items.containsKey(w) || w.getChild(childKey) != null) continue;
            String path = this.getBlockName(w);
            block = SimpleEntrySet.getOptionalBlock(path, w.getNamespace());
            if (block == null) {
                block = SimpleEntrySet.getOptionalBlock(path, possibleNamespaces);
            }
            if (block == null || w.getChildKey((Object)block) != null) continue;
            try {
                w.addChild(childKey, (Object)block);
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    private static Block getOptionalBlock(String path, String ... namespaces) {
        for (String namespace : namespaces) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
            Optional i = BuiltInRegistries.BLOCK.getOptional(id);
            if (!i.isPresent()) continue;
            return (Block)i.get();
        }
        return null;
    }

    @NotNull
    public String getBlockName(T w) {
        String name;
        if (this.prefix != null) {
            name = this.prefix + "_" + w.getTypeName();
            if (!this.postfix.isEmpty()) {
                name = name + "_" + this.postfix;
            }
        } else {
            name = w.getTypeName() + "_" + this.postfix;
        }
        return name;
    }

    @Override
    public void registerItems(SimpleModule module, Registrator<Item> registry) {
        this.blocks.forEach((w, value) -> {
            Object i = this.itemFactory != null ? (Item)this.itemFactory.apply(w, value, (Object)new Item.Properties()) : new BlockTypeBasedBlockItem(value, new Item.Properties(), w);
            if (i != null) {
                this.items.put(w, i);
                registry.register(Utils.getID((Block)value), i);
            }
        });
    }

    @Override
    public void registerTiles(SimpleModule module, Registrator<BlockEntityType<?>> registry) {
        ITileHolder<?> iTileHolder = this.tileHolder;
        if (iTileHolder instanceof NewTileHolder) {
            NewTileHolder nt = (NewTileHolder)iTileHolder;
            BlockEntityType tile = nt.createInstance((Block[])this.blocks.values().toArray(Block[]::new));
            registry.register(module.makeMyRes(module.shortenedId() + "_" + this.getName()), tile);
        }
    }

    @Override
    public void setupExistingTiles() {
        ITileHolder<?> iTileHolder = this.tileHolder;
        if (iTileHolder instanceof ExistingTileHolder) {
            ExistingTileHolder et = (ExistingTileHolder)iTileHolder;
            SimpleModule.appendTileEntityBlocks(et.get(), this.blocks.values());
        }
    }

    @Override
    public void setRenderLayer() {
        for (Map.Entry e : this.blocks.entrySet()) {
            BlockType w = (BlockType)e.getKey();
            Block v = (Block)e.getValue();
            if (this.renderType == null && !w.toString().equals("rats:pirat")) continue;
            EveryCompatClient.registerRenderType(v, w, this.renderType);
        }
    }

    @Override
    public void generateLootTables(SimpleModule module, ResourceManager manager, ResourceSink sink) {
        if (this.lootMode == LootTableMode.COPY_FROM_PARENT) {
            ResourceLocation reg = Utils.getID(this.getBaseBlock());
            ResourcesUtils.addBlockResources(manager, sink, this.blocks, this.makeLootTableTransformer(module, manager), ResType.BLOCK_LOOT_TABLES.getPath(reg));
        } else if (this.lootMode == LootTableMode.DROP_SELF) {
            // empty if block
        }
    }

    @Override
    public void generateModels(SimpleModule module, ResourceManager manager, ResourceSink sink) {
        ResourcesUtils.generateStandardBlockFiles(manager, sink, this.blocks, (BlockType)this.baseType.get(), this.makeModelTransformer(module, manager), this.makeBlockStateTransformer(module, manager), this.modelConfiguration);
        ResourcesUtils.generateStandardItemModels(manager, sink, this.items, (BlockType)this.baseType.get(), this.makeModelTransformer(module, manager), this.modelConfiguration);
    }

    protected BlockTypeResTransformer<T> makeModelTransformer(SimpleModule module, ResourceManager manager) {
        BlockTypeResTransformer modelTransformer = BlockTypeResTransformer.create((String)module.modId, (ResourceManager)manager);
        if (this.extraModelTransform != null) {
            this.extraModelTransform.accept(modelTransformer);
        }
        ResourcesUtils.addBuiltinModelTransformer(modelTransformer, (BlockType)this.baseType.get());
        return modelTransformer;
    }

    protected BlockTypeResTransformer<T> makeBlockStateTransformer(SimpleModule module, ResourceManager manager) {
        String oldTypeName = ((BlockType)this.baseType.get()).getTypeName();
        return BlockTypeResTransformer.create((String)module.modId, (ResourceManager)manager).replaceWithTextureFromChild("minecraft:block/" + oldTypeName + "_planks", "planks").replaceBlockType(oldTypeName).IDReplaceType(oldTypeName);
    }

    protected BlockTypeResTransformer<T> makeLootTableTransformer(SimpleModule module, ResourceManager manager) {
        String oldTypeName = ((BlockType)this.baseType.get()).getTypeName();
        return BlockTypeResTransformer.create((String)module.modId, (ResourceManager)manager).setIDModifier((text, blockId, type) -> BlockTypeResTransformer.replaceFullGenericType((String)text, (BlockType)type, (ResourceLocation)blockId, (String)oldTypeName, null, (int)2)).addModifier((text, blockId, type) -> ResourcesUtils.convertItemIDinText(text, (BlockType)this.baseType.get(), type));
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> builder(Class<T> type, String name, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, null, baseType, baseBlock, blockSupplier);
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> builder(Class<T> type, String name, String prefix, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, prefix, baseType, baseBlock, blockSupplier);
    }

    public static boolean isSimpleDrop(Block block) {
        return SIMPLE_DROPS.contains(block);
    }

    private static /* synthetic */ void lambda$generateLootTables$4(ResourceSink sink, BlockType wood, Block value) {
        sink.addSimpleBlockLootTable(value);
    }

    public static enum LootTableMode {
        DROP_SELF,
        COPY_FROM_PARENT,
        NO_LOOT;

    }

    public static interface ITileHolder<H extends BlockEntity> {
        public BlockEntityType<H> get();

        @OnlyIn(value=Dist.CLIENT)
        default public void registerRenderer(ClientHelper.BlockEntityRendererEvent event, BlockEntityRendererProvider<BlockEntity> renderer) {
            event.register(this.get(), renderer);
        }
    }

    public static class NewTileHolder<H extends BlockEntity>
    implements ITileHolder<H> {
        protected final BiFunction<BlockPos, BlockState, H> tileFactory;
        protected Supplier<BlockEntityRendererProvider<H>> renderer = null;
        protected BlockEntityType<H> tile = null;

        public NewTileHolder(BiFunction<BlockPos, BlockState, H> tileFactory) {
            this.tileFactory = tileFactory;
        }

        @Override
        public BlockEntityType<H> get() {
            return this.tile;
        }

        public BlockEntityType<? extends H> createInstance(Block ... blocks) {
            if (this.tile != null) {
                throw new UnsupportedOperationException("tile has already been created");
            }
            this.tile = PlatHelper.newBlockEntityType(this.tileFactory::apply, (Block[])blocks);
            return this.tile;
        }
    }

    public record ExistingTileHolder<H extends BlockEntity>(Supplier<BlockEntityType<H>> supplier) implements ITileHolder<H>
    {
        @Override
        public BlockEntityType<H> get() {
            return this.supplier.get();
        }
    }

    public static class Builder<T extends BlockType, B extends Block>
    extends AbstractSimpleEntrySet.Builder<Builder<T, B>, T, B, Item> {
        protected final Supplier<@Nullable B> baseBlock;
        protected LootTableMode lootMode = LootTableMode.DROP_SELF;
        protected final Function<T, B> blockFactory;
        @Nullable
        protected TriFunction<T, B, Item.Properties, Item> itemFactory;
        @Nullable
        protected ITileHolder<?> tileHolder;
        @Nullable
        protected Object renderType = null;
        protected ModelConfiguration modelConfig = ModelConfiguration.EMPTY;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<B> baseBlock, Function<T, B> blockFactory) {
            super(type, name, prefix, baseType);
            this.baseBlock = baseBlock;
            this.blockFactory = blockFactory;
        }

        public SimpleEntrySet<T, B> build() {
            if (this.tab == null && PlatHelper.isDev()) {
                throw new IllegalStateException("Tab for module " + this.name + " was null!");
            }
            SimpleEntrySet<T, B> e = new SimpleEntrySet<T, B>(this.type, this.name, this.prefix, this.blockFactory, this.baseBlock, this.baseType, this.tab, this.tabMode, this.lootMode, this.itemFactory, this.tileHolder, this.renderType, null, this.extraModelTransform, this.useMergedPalette, this.copyTint, this.condition, this.modelConfig);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            for (TextureInfo t : this.textures) {
                if (this.palette != null) {
                    e.textures.add(t.cloneWithPalette((blockType, manager) -> (PaletteStrategy.PaletteAndAnimation)this.palette.apply(blockType, manager)));
                    continue;
                }
                e.textures.add(t);
            }
            return e;
        }

        public <H extends BlockEntity> Builder<T, B> addTile(String idTile) {
            BlockEntityType entityType = (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional(ResourceLocation.parse((String)idTile)).orElseThrow(() -> new NoSuchElementException("BlockEntityType's ID: " + idTile + " not found! ID must be wrong!"));
            this.tileHolder = new ExistingTileHolder(() -> entityType);
            return this;
        }

        public <H extends BlockEntity> Builder<T, B> addTile(Supplier<BlockEntityType<H>> tile) {
            this.tileHolder = new ExistingTileHolder(tile);
            return this;
        }

        public <H extends BlockEntity> Builder<T, B> addTile(BiFunction<BlockPos, BlockState, H> tileFactory) {
            this.tileHolder = new NewTileHolder(tileFactory);
            return this;
        }

        public Builder<T, B> addCustomItem(TriFunction<T, B, Item.Properties, Item> itemFactory) {
            this.itemFactory = itemFactory;
            return this;
        }

        public Builder<T, B> noItem() {
            this.itemFactory = (a, b, c) -> null;
            return this;
        }

        public Builder<T, B> copyParentDrop() {
            this.lootMode = LootTableMode.COPY_FROM_PARENT;
            return this;
        }

        public Builder<T, B> dropSelf() {
            this.lootMode = LootTableMode.DROP_SELF;
            return this;
        }

        public Builder<T, B> noDrops() {
            this.lootMode = LootTableMode.NO_LOOT;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder<T, B> setRenderType(Supplier<Supplier<Object>> renderType) {
            this.renderType = renderType;
            return this;
        }

        public Builder<T, B> setRenderType(RenderLayer renderType) {
            this.renderType = renderType;
            return this;
        }

        public Builder<T, B> defaultRecipe() {
            this.recipes.add(() -> Utils.getID((Block)Objects.requireNonNull((Block)this.baseBlock.get())));
            return this;
        }

        public Builder<T, B> defaultBlockTexture() {
            this.textures.add(TextureInfo.of(Utils.getID((Block)Objects.requireNonNull((Block)this.baseBlock.get())).withPrefix("block/")).build());
            return this;
        }

        public Builder<T, B> defaultItemTexture() {
            this.textures.add(TextureInfo.of(Utils.getID((Block)Objects.requireNonNull((Block)this.baseBlock.get())).withPrefix("item/")).build());
            return this;
        }

        public Builder<T, B> generateBlockModels(ResourceLocation ... blockModels) {
            if (this.modelConfig == ModelConfiguration.EMPTY) {
                this.modelConfig = ModelConfiguration.createNew();
            }
            this.modelConfig.addBlockModel(blockModels);
            return this;
        }

        public Builder<T, B> generateBlockModels(boolean includeInGeneration, ResourceLocation ... blockModels) {
            if (this.modelConfig == ModelConfiguration.EMPTY) {
                this.modelConfig = ModelConfiguration.createNew(includeInGeneration);
            }
            this.modelConfig.addBlockModel(blockModels);
            return this;
        }

        public Builder<T, B> generateItemModels(ResourceLocation ... itemModels) {
            if (this.modelConfig == ModelConfiguration.EMPTY) {
                this.modelConfig = ModelConfiguration.createNew();
            }
            this.modelConfig.addItemModel(itemModels);
            return this;
        }

        public Builder<T, B> generateItemModels(boolean includeInGeneration, ResourceLocation ... itemModels) {
            if (this.modelConfig == ModelConfiguration.EMPTY) {
                this.modelConfig = ModelConfiguration.createNew(includeInGeneration);
            }
            this.modelConfig.addItemModel(itemModels);
            return this;
        }
    }
}

