/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.every_compat.ECNetworking;
import net.mehvahdjukaar.every_compat.ECRegistry;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.every_compat.configs.ModEntriesConfigs;
import net.mehvahdjukaar.every_compat.configs.UnsafeDisablerConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.OtherCompatMod;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcesProvider;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class EveryCompat {
    public static final String MOD_ID = "everycomp";
    public static final Logger LOGGER = LogManager.getLogger((String)"Every Compat");
    private static final Multimap<String, CompatModule> ACTIVE_MODULES = MultimapBuilder.linkedHashKeys().arrayListValues().build();
    private static final List<OtherCompatMod> COMPAT_MODS = new ArrayList<OtherCompatMod>();
    private static final Map<Class<? extends BlockType>, Set<String>> TYPES_TO_CHILD_KEYS = new Object2ObjectOpenHashMap();
    private static final Map<Object, CompatModule> ITEMS_TO_MODULES = new Object2ObjectOpenHashMap();
    private static final Set<String> DEPENDENCIES = new HashSet<String>();
    private static final Set<String> ADDON_IDS = new HashSet<String>();
    private static final Set<CompatModule> ERRORED = new HashSet<CompatModule>();
    static boolean canShowErrorScreen = PlatHelper.getPhysicalSide().isClient();

    public static class_2960 res(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void init() {
        ECConfigs.init();
        UnsafeDisablerConfigs.init();
        ECNetworking.init();
        ECRegistry.init();
        RegHelper.registerDynamicResourceProvider((DynamicResourcesProvider)ServerDynamicResourcesHandler.getInstance());
        RegHelper.addItemsToTabsRegistration(EveryCompat::registerItemsToTabs);
        PlatHelper.addCommonSetup(EveryCompat::setup);
        BlockSetAPI.addDynamicRegistration((String)MOD_ID, r -> ModEntriesConfigs.initEarlyButNotSuperEarly(), (class_2378)class_7923.field_41175);
    }

    public static void setup() {
        for (CompatModule module : ACTIVE_MODULES.values()) {
            if (module == null) continue;
            ServerDynamicResourcesHandler.getInstance().addSupportedNamespaces(module.getServerResourcesNamespaces());
            if (!PlatHelper.getPhysicalSide().isClient()) continue;
            ClientDynamicResourcesHandler.getInstance().addSupportedNamespaces(module.getClientResourcesNamespaces());
        }
        String activeModulesString = ACTIVE_MODULES.keySet().stream().map(key -> {
            int count = ACTIVE_MODULES.get(key).size();
            return count > 1 ? key + "(" + count + ")" : key;
        }).collect(Collectors.joining(", ", "[", "]"));
        LOGGER.info("Every Compat has loaded {} modules: {}", (Object)ACTIVE_MODULES.size(), (Object)activeModulesString);
        if (PlatHelper.isModLoaded((String)"chipped")) {
            LOGGER.warn("Chipped is installed. The mod on its own adds a ludicrous amount of blocks. With Every Compat this can easily explode. You have been warned");
        }
        int newSize = class_7923.field_41175.method_10204();
        int myChildrenSize = ACTIVE_MODULES.values().stream().filter(Objects::nonNull).mapToInt(CompatModule::bloatAmount).sum();
        float p = (float)myChildrenSize / (float)newSize * 100.0f;
        if (myChildrenSize == 0) {
            String log = "\n##########################################################################################################\n#                                                                                                        #\n#  ATTENTION: EVERY COMPAT REGISTERED 0 BLOCK! No Wood mods (Biomes O' Plenty or others) are installed.  #\n#                            You dont need EveryCompat and should remove it.                             #\n#                                                                                                        #\n##########################################################################################################\n";
            LOGGER.error("\n{}", (Object)log);
            return;
        }
        if (p > 25.0f) {
            LOGGER.warn("Registered {} compat blocks making up {}% of total blocks registered", (Object)myChildrenSize, (Object)String.format("%.2f", Float.valueOf(p)));
        } else {
            LOGGER.info("Registered {} compat blocks making up {}% of total blocks registered", (Object)myChildrenSize, (Object)String.format("%.2f", Float.valueOf(p)));
        }
        if (p > 33.0f) {
            Optional<CompatModule> compatbloated = ACTIVE_MODULES.values().stream().max(Comparator.comparing(compatModule -> compatModule != null ? compatModule.bloatAmount() : 0));
            if (compatbloated.isPresent()) {
                CompatModule bloated = compatbloated.get();
                LOGGER.info("Registered {} compat blocks making up {}% of total blocks registered", (Object)myChildrenSize, (Object)String.format("%.2f", Float.valueOf(p)));
                LOGGER.error("Every Compat registered blocks make up more than one third of your registered blocks, taking up memory and load time.");
                LOGGER.error("You might want to uninstall some mods, biggest offender was {} ({} blocks)", (Object)bloated.getModName().toUpperCase(Locale.ROOT), (Object)bloated.bloatAmount());
            } else {
                String log = "\n#######################################################\n#                                                     #\n#     ATTENTION: No supported mods are installed.     #\n#   You dont need EveryCompat and should remove it.   #\n#                                                     #\n#######################################################\n";
                LOGGER.error("\n{}", (Object)log);
            }
        }
        EveryCompat.forAllModules(CompatModule::onModSetup);
        canShowErrorScreen = true;
    }

    public static void forAllModules(Consumer<CompatModule> action) {
        for (CompatModule m : ACTIVE_MODULES.values()) {
            try {
                action.accept(m);
            }
            catch (Throwable e) {
                LOGGER.error("Module for mod {} contains errors. This could mean that the mod has been recently updated and Every Compat needs updating (try downgrading the mod) or that you are using an older version.", (Object)Objects.requireNonNull(m).getModName(), (Object)e);
                if (canShowErrorScreen) {
                    ERRORED.add(m);
                    continue;
                }
                throw e;
            }
        }
    }

    public static void executeOrFail(Runnable r, CompatModule module) {
        try {
            r.run();
        }
        catch (Throwable e) {
            LOGGER.error("Module for mod {} contains errors. This could mean that the mod has been recently updated and Every Compat needs updating (try downgrading the mod) or that you are using an older version.", (Object)Objects.requireNonNull(module).getModName(), (Object)e);
            if (canShowErrorScreen) {
                ERRORED.add(module);
            }
            throw e;
        }
    }

    public static void addItemToModuleMapping(class_1792 item, CompatModule module) {
        ITEMS_TO_MODULES.put(item, module);
    }

    public static CompatModule getModuleOfItem(class_1792 item) {
        return ITEMS_TO_MODULES.get(item);
    }

    public static <T extends BlockType> void trackChildType(Class<T> type, String childId) {
        TYPES_TO_CHILD_KEYS.computeIfAbsent(type, t -> new HashSet()).add(childId);
    }

    public static Collection<String> getChildKeys(Class<? extends BlockType> type) {
        return TYPES_TO_CHILD_KEYS.getOrDefault(type, Set.of());
    }

    public static void addCompatMod(String compatModId, List<String> fromModId, List<String> supportedModId) {
        OtherCompatMod oc = new OtherCompatMod(compatModId, fromModId, supportedModId);
        EveryCompat.addOtherCompatMod(oc);
    }

    public static synchronized void addOtherCompatMod(OtherCompatMod oc) {
        COMPAT_MODS.add(oc);
        DEPENDENCIES.add(oc.modId());
        DEPENDENCIES.addAll(oc.woodsFrom());
        DEPENDENCIES.addAll(oc.blocksFrom());
    }

    public static synchronized void addModule(CompatModule module) {
        ACTIVE_MODULES.put((Object)module.getModId(), (Object)module);
        DEPENDENCIES.add(module.getModId());
        DEPENDENCIES.addAll(module.getAlreadySupportedMods());
        ADDON_IDS.add(module.getMyNamespace());
    }

    public static synchronized void addOptionalModule(String modId, Supplier<Class<? extends CompatModule>> moduleClass) {
        if (PlatHelper.isModLoaded((String)modId) && !UnsafeDisablerConfigs.MODULES_BLACKLIST.get().contains(modId) && !UnsafeDisablerConfigs.ENTRY_SETS_BLACKLIST.get().contains(modId + ":.*")) {
            try {
                Class<? extends CompatModule> klazz = moduleClass.get();
                CompatModule module = EveryCompat.instantiateModuleClass(modId, klazz);
                EveryCompat.addModule(module);
            }
            catch (Throwable t) {
                ERRORED.add(new CompatModule(modId, modId, "unknown"){

                    @Override
                    public int bloatAmount() {
                        return 0;
                    }

                    @Override
                    public Collection<Class<? extends BlockType>> getAffectedTypes() {
                        return List.of();
                    }
                });
            }
        }
    }

    @SafeVarargs
    public static void addMultipleOptional(String modId, Supplier<Class<? extends CompatModule>> ... klazzes) {
        for (Supplier<Class<? extends CompatModule>> klazz : klazzes) {
            EveryCompat.addOptionalModule(modId, klazz);
        }
    }

    @NotNull
    private static CompatModule instantiateModuleClass(String modId, Class<? extends CompatModule> klazz) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        CompatModule module;
        try {
            Constructor<? extends CompatModule> ctor = klazz.getDeclaredConstructor(String.class);
            ctor.setAccessible(true);
            module = ctor.newInstance(modId);
        }
        catch (NoSuchMethodException e) {
            Constructor<? extends CompatModule> noArg = klazz.getDeclaredConstructor(new Class[0]);
            noArg.setAccessible(true);
            module = noArg.newInstance(new Object[0]);
        }
        return module;
    }

    public static Collection<OtherCompatMod> getCompatMods() {
        return COMPAT_MODS;
    }

    public static Collection<String> getDependencies() {
        return DEPENDENCIES;
    }

    public static boolean isMyIdOrAddon(String namespace) {
        return ADDON_IDS.contains(namespace);
    }

    public static Collection<CompatModule> getModulesOfMod(String modId) {
        return ACTIVE_MODULES.get((Object)modId);
    }

    private static void registerItemsToTabs(RegHelper.ItemToTabEvent event) {
        if (ECConfigs.TAB_ENABLED.get().booleanValue()) {
            LinkedHashMap typeToEntrySet = new LinkedHashMap();
            for (BlockTypeRegistry blockTypeRegistry : BlockSetAPI.getRegistries()) {
                for (BlockType type : blockTypeRegistry.getValues()) {
                    EveryCompat.forAllModules(m -> typeToEntrySet.computeIfAbsent(m.getDedicatedTab(), j -> new LinkedHashMap()).computeIfAbsent(type, j -> new ArrayList()).addAll(m.getAllItemsOfType(type)));
                }
            }
            for (Map.Entry entry : typeToEntrySet.entrySet()) {
                for (List ee : ((Map)entry.getValue()).values()) {
                    event.add((class_5321)entry.getKey(), (class_1935[])ee.toArray(class_1935[]::new));
                }
            }
        } else {
            EveryCompat.forAllModules(m -> m.registerItemsToExistingTabs(event));
        }
    }

    public static List<String> getModulesThatErrored() {
        return ERRORED.stream().map(CompatModule::getModName).toList();
    }

    public static void addOtherCompatMod(String compatModId, String fromModId, String supportedModId) {
        EveryCompat.addCompatMod(compatModId, List.of(fromModId), List.of(supportedModId));
    }

    public static void addOtherCompatMod(String compatModId, String fromModId, String ... supportedModId) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, supportedModId);
        EveryCompat.addCompatMod(compatModId, List.of(fromModId), list);
    }

    public static void addOtherCompatMod(String compatModId, List<String> fromModId, String supportedModId) {
        EveryCompat.addCompatMod(compatModId, fromModId, List.of(supportedModId));
    }

    public static void addOtherCompatMod(String compatModId, List<String> fromModId, String ... supportedModId) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, supportedModId);
        EveryCompat.addCompatMod(compatModId, fromModId, list);
    }

    @Deprecated(forRemoval=true)
    public static void addIfLoaded(String modId, Supplier<Function<String, CompatModule>> moduleFactory) {
        if (PlatHelper.isModLoaded((String)modId)) {
            try {
                CompatModule module = moduleFactory.get().apply(modId);
                EveryCompat.addModule(module);
            }
            catch (Throwable e) {
                ERRORED.add(new CompatModule(modId, modId, "unknown"){

                    @Override
                    public int bloatAmount() {
                        return 0;
                    }

                    @Override
                    public Collection<Class<? extends BlockType>> getAffectedTypes() {
                        return List.of();
                    }
                });
            }
        }
    }
}

