package net.mehvahdjukaar.every_compat.misc;

import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import java.util.Map;
import java.util.Set;

public final class ColoringUtils {

    static final Set<class_2960> HARDCODED_NO_TINT = Set.of(
            class_2960.method_60655("regions_unexplored", "flowering"),
            class_2960.method_60655("blue_skies", "cherry"),
            class_2960.method_60655("twilightforest", "beanstalk")
    );

    public static void copyItemTint(ClientHelper.ItemColorEvent event, Map<? extends BlockType, ? extends class_1792> items) {
        items.forEach((type, item) -> {
            event.register((stack, tintIndex) -> {
                        class_1799 parentItem = new class_1799(type.mainChild());
                        if (parentItem.method_7960()) return 1;
                        return event.getColor(parentItem, tintIndex);
                    },
                    item.method_8389());
        });
    }

    public static void copyBlockTint(ClientHelper.ItemColorEvent event, Map<? extends BlockType, ? extends class_2248> blocks) {
        blocks.forEach((type, item) -> {
            event.register((stack, tintIndex) -> {
                        class_1799 parentItem = new class_1799(type.mainChild());
                        if (parentItem.method_7960()) return 1;
                        return event.getColor(parentItem, tintIndex);
                    },
                    item.method_8389());
        });
    }

    public static void copyBlockTint(ClientHelper.BlockColorEvent event, Map<? extends BlockType,? extends class_2248> blocks) {
        blocks.forEach((type, block) -> {
            if (HARDCODED_NO_TINT.contains(type.id)) return;
            event.register((bs, l, p, i) -> {
                if (type.mainChild() instanceof class_2248 bl) {
                    return event.getColor(bl.method_9564(), l, p, i);
                }
                return 1;
            }, block);
        });
    }

}
