package net.mehvahdjukaar.every_compat.modules.variants;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestItem;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2304;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3708;
import net.minecraft.class_3711;
import net.minecraft.class_3712;
import net.minecraft.class_3713;
import net.minecraft.class_3715;
import net.minecraft.class_3716;
import net.minecraft.class_3717;
import net.minecraft.class_3962;
import net.minecraft.class_4481;
import net.minecraft.class_7477;
import net.minecraft.class_7714;
import net.minecraft.class_7924;
import net.minecraft.world.level.block.*;
import java.util.function.Consumer;

import static net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture.generateChestTexture;
import static net.mehvahdjukaar.every_compat.misc.UtilityMisc.simpleAddBlocksToPOI;

//SUPPORT: FABRIC-v2.1+ | NEOFORGE-NOT_AVAILABLE
public class VariantVanillaBlocksModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> barrel;
    public final SimpleEntrySet<WoodType, class_2248> beehive;
    public final SimpleEntrySet<WoodType, class_2248> bookshelves;
    public final SimpleEntrySet<WoodType, class_2248> cartography;
    public final SimpleEntrySet<WoodType, class_2248> chests;
    public final SimpleEntrySet<WoodType, class_2248> chiseledBookshelves;
    public final SimpleEntrySet<WoodType, class_2248> composters;
    public final SimpleEntrySet<WoodType, class_2248> craftingTable;
    public final SimpleEntrySet<WoodType, class_2248> fletchingTable;
    public final SimpleEntrySet<WoodType, class_2248> grindstones;
    public final SimpleEntrySet<WoodType, class_2248> lectern;
    public final SimpleEntrySet<WoodType, class_2248> smithingTable;
    public final SimpleEntrySet<WoodType, class_2248> smoker;

    public VariantVanillaBlocksModule(String modId) {
        super(modId, "vvb", EveryCompat.MOD_ID);
        class_2960 tab = modRes(modId);

        barrel = SimpleEntrySet.builder(WoodType.class, "barrel",
                        getModBlock("oak_barrel"), () -> VanillaWoodTypes.OAK,
                        w -> new class_3708(Utils.copyPropertySafe(class_2246.field_16328))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_23800, class_7924.field_41254)
                .addTag(modRes("barrels"), class_7924.field_41254, class_7924.field_41197)
                .addTag(class_2960.method_60654("c:barrels"), class_7924.field_41254, class_7924.field_41197)
                .addTag(class_2960.method_60654("c:barrels_wooden"), class_7924.field_41254, class_7924.field_41197)
                .addTexture(modRes("block/oak_barrel_bottom"))
                .addTextureM(modRes("block/oak_barrel_side"), EveryCompat.res("block/vanilla_barrel_side_m"))
                .addTextureM(modRes("block/oak_barrel_top"), EveryCompat.res("block/vanilla_barrel_top_m"))
                .addTexture(modRes("block/oak_barrel_top_open"))
                .addTile(() -> class_2591.field_16411)
                .copyParentDrop()
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(barrel);

        beehive = SimpleEntrySet.builder(WoodType.class, "beehive",
                        getModBlock("spruce_beehive"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new class_4481(Utils.copyPropertySafe(class_2246.field_20422))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_20340, class_7924.field_41254)
                .addTag(modRes("beehives"), class_7924.field_41254, class_7924.field_41197)
                .addTexture(modRes("block/spruce_beehive_end"))
                .addTexture(modRes("block/spruce_beehive_front"))
                .addTextureM(modRes("block/spruce_beehive_front_honey"), EveryCompat.res("block/spruce_beehive_front_honey_m"))
                .addTextureM(modRes("block/spruce_beehive_side"), EveryCompat.res("block/spruce_beehive_side_m"))
                .addTile(() -> class_2591.field_20431)
                .copyParentDrop()
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(beehive);

        bookshelves = SimpleEntrySet.builder(WoodType.class, "bookshelf",
                        getModBlock("acacia_bookshelf"), () -> VanillaWoodTypes.ACACIA,
                        w -> new class_2248(Utils.copyPropertySafe(class_2246.field_10504))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_44472, class_7924.field_41254)
                .addTag(modRes("bookshelves"), class_7924.field_41254, class_7924.field_41197)
                .addTag(class_2960.method_60654("c:bookshelves"), class_7924.field_41254, class_7924.field_41197)
                .addTextureM(modRes("block/acacia_bookshelf"), EveryCompat.res("block/acacia_bookshelf_m"))
                .copyParentDrop()
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(bookshelves);

        cartography = SimpleEntrySet.builder(WoodType.class, "cartography_table",
                        getModBlock("oak_cartography_table"), () -> VanillaWoodTypes.OAK,
                        w -> new class_3711(Utils.copyPropertySafe(class_2246.field_16336))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("cartography_tables"), class_7924.field_41254, class_7924.field_41197)
                .addTextureM(modRes("block/oak_cartography_table_side1"), EveryCompat.res("block/vanilla_cartography_table_side1_m"))
                .addTextureM(modRes("block/oak_cartography_table_side2"), EveryCompat.res("block/vanilla_cartography_table_side2_m"))
                .addTexture(modRes("block/oak_cartography_table_side3"))
                .addTextureM(modRes("block/oak_cartography_table_top"), EveryCompat.res("block/vanilla_cartography_table_top_m"))
                .copyParentDrop()
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(cartography);

        chests = SimpleEntrySet.builder(WoodType.class, "chest",
                        getModBlock("acacia_chest"), () -> VanillaWoodTypes.ACACIA,
                        w -> new CompatChestBlock(this::getTile, Utils.copyPropertySafe(w.planks))
                )
                .addTile(VariantChestBlockEntity::new)
                .addModelTransform(m -> m.addModifier((s, blockId, woodType) ->
                                s.replace(
                                        "\"variantvanillablocks:chest/acacia_chest\"",
                                        "\"" + woodType.createFullIdWith(EveryCompat.MOD_ID, "chest", shortenedId(), "", "chest") + "\""
                                )
                        )
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_23800, class_7924.field_41254)
                .addTag(modRes("chests"), class_7924.field_41254, class_7924.field_41197)
                .addTag(class_2960.method_60654("c:chests_wooden"), class_7924.field_41254, class_7924.field_41197)
                .addTag(class_2960.method_60654("c:chests"), class_7924.field_41254, class_7924.field_41197)
                .addCustomItem((w, block, properties) -> new CompatChestItem(block, properties))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(chests);

        chiseledBookshelves = SimpleEntrySet.builder(WoodType.class, "chiseled_bookshelf",
                        getModBlock("acacia_chiseled_bookshelf"), () -> VanillaWoodTypes.ACACIA,
                        w -> new class_7714(Utils.copyPropertySafe(w.planks))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("chiseled_bookshelves"), class_7924.field_41254, class_7924.field_41197)
                .addTexture(modRes("block/acacia_chiseled_bookshelf_empty"))
                .addTextureM(modRes("block/acacia_chiseled_bookshelf_occupied"), EveryCompat.res("block/vanilla_chiseled_bookshelf_occupied_m"))
                .addTexture(modRes("block/acacia_chiseled_bookshelf_side"))
                .addTexture(modRes("block/acacia_chiseled_bookshelf_top"))
                .addTile(() -> class_2591.field_40329)
                .copyParentDrop()
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(chiseledBookshelves);

        composters = SimpleEntrySet.builder(WoodType.class, "composter",
                        getModBlock("oak_composter"), () -> VanillaWoodTypes.OAK,
                        w -> new class_3962(Utils.copyPropertySafe(class_2246.field_17563))
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("composters"), class_7924.field_41254, class_7924.field_41197)
                .addTexture(modRes("block/oak_composter_bottom"))
                .addTexture(modRes("block/oak_composter_side"))
                .addTexture(modRes("block/oak_composter_top"))
                .copyParentDrop()
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(composters);

        craftingTable = SimpleEntrySet.builder(WoodType.class, "crafting_table",
                        getModBlock("spruce_crafting_table"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new class_2304(Utils.copyPropertySafe(w.planks)) {
                        }
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("crafting_tables"), class_7924.field_41254, class_7924.field_41197)
                //TEXTURE: texture is oak_crafting_table's texture
                .addTextureM(EveryCompat.res("block/spruce_crafting_table_front"), EveryCompat.res("block/vct/spruce_crafting_table_front_m"))
                .addTextureM(EveryCompat.res("block/spruce_crafting_table_side"), EveryCompat.res("block/vct/spruce_crafting_table_side_m"))
                .addTextureM(EveryCompat.res("block/spruce_crafting_table_top"), EveryCompat.res("block/vct/spruce_crafting_table_top_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .copyParentDrop()
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(craftingTable);

        fletchingTable = SimpleEntrySet.builder(WoodType.class, "fletching_table",
                        getModBlock("oak_fletching_table"), () -> VanillaWoodTypes.OAK,
                        w -> new class_3712(Utils.copyPropertySafe(class_2246.field_16331)) {
                        }
                )
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(modRes("fletching_tables"), class_7924.field_41254, class_7924.field_41197)
                .addTextureM(modRes("block/oak_fletching_table_front"), EveryCompat.res("block/vanilla_fletching_table_front_m"))
                .addTextureM(modRes("block/oak_fletching_table_side"), EveryCompat.res("block/vanilla_fletching_table_side_m"))
                .addTextureM(modRes("block/oak_fletching_table_top"), EveryCompat.res("block/vanilla_fletching_table_top_m"))
                .copyParentDrop()
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(fletchingTable);

        grindstones = SimpleEntrySet.builder(WoodType.class, "grindstone",
                        getModBlock("oak_grindstone"), () -> VanillaWoodTypes.OAK,
                        w -> new class_3713(Utils.copyPropertySafe(class_2246.field_16337)) {
                        }
                )
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(modRes("grindstones"), class_7924.field_41254, class_7924.field_41197)
                .addTexture(modRes("block/oak_grindstone_pivot"))
                .copyParentDrop()
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(grindstones);

        lectern = SimpleEntrySet.builder(WoodType.class, "lectern",
                        getModBlock("acacia_lectern"), () -> VanillaWoodTypes.ACACIA,
                        w -> new class_3715(Utils.copyPropertySafe(class_2246.field_16330)) {
                        }
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("lecterns"), class_7924.field_41254)
                .addTag(modRes("lecterns"), class_7924.field_41197)
                .addTextureM(modRes("block/acacia_lectern_base"), EveryCompat.res("block/vanilla_lectern_base_m"))
                .addTextureM(modRes("block/acacia_lectern_front"), EveryCompat.res("block/vanilla_lectern_front_m"))
                .addTexture(modRes("block/acacia_lectern_sides"))
                .addTexture(modRes("block/acacia_lectern_top"))
                .addTile(() -> class_2591.field_16412)
                .copyParentDrop()
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(lectern);

        smithingTable = SimpleEntrySet.builder(WoodType.class, "smithing_table",
                        getModBlock("oak_smithing_table"), () -> VanillaWoodTypes.OAK,
                        w -> new class_3717(Utils.copyPropertySafe(class_2246.field_16329)) {
                        }
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("smithing_tables"), class_7924.field_41254, class_7924.field_41197)
                .addTextureM(modRes("block/oak_smithing_table_bottom"), EveryCompat.res("block/vanilla_smithing_table_bottom_m"))
                .addTextureM(modRes("block/oak_smithing_table_front"), EveryCompat.res("block/vanilla_smithing_table_front_m"))
                .addTextureM(modRes("block/oak_smithing_table_side"), EveryCompat.res("block/vanilla_smithing_table_side_m"))
                .copyParentDrop()
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(smithingTable);

        smoker = SimpleEntrySet.builder(WoodType.class, "smoker",
                        getModBlock("acacia_smoker"), () -> VanillaWoodTypes.ACACIA,
                        w -> new class_3716(Utils.copyPropertySafe(class_2246.field_16334)) {
                        }
                )
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(modRes("smokers"), class_7924.field_41254, class_7924.field_41197)
                .addTextureM(modRes("block/acacia_smoker_front"), EveryCompat.res("block/vanilla_smoker_front_m"))
                .addTextureM(modRes("block/acacia_smoker_front_on"), EveryCompat.res("block/vanilla_smoker_front_on_m"))
                .addTextureM(modRes("block/acacia_smoker_side"), EveryCompat.res("block/vanilla_smoker_side_m"))
                .addTextureM(modRes("block/acacia_smoker_top"), EveryCompat.res("block/vanilla_smoker_x_m"))
                .addTextureM(modRes("block/acacia_smoker_bottom"), EveryCompat.res("block/vanilla_smoker_x_m"))
                .addTile(() -> class_2591.field_16414)
                .copyParentDrop()
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(smoker);

    }

    //kind of hacky. don't like but we cant reference chests itself while constructing its own object
    // GetTiles
    private class_2591<? extends class_2595> getTile() {
        return chests.getTile(CompatChestBlockEntity.class);
    }

    // BlockEntity
    private class VariantChestBlockEntity extends CompatChestBlockEntity {
        public VariantChestBlockEntity(class_2338 pos, class_2680 state) {
            super(chests.getTile(), pos, state);
        }
    }

    @Override
    public void onModInit() {
        super.onModInit();
        simpleAddBlocksToPOI(beehive, class_7477.field_39293);
        simpleAddBlocksToPOI(barrel, class_7477.field_39283);
        simpleAddBlocksToPOI(cartography, class_7477.field_39280);
        simpleAddBlocksToPOI(composters, class_7477.field_39282);
        simpleAddBlocksToPOI(fletchingTable, class_7477.field_39284);
        simpleAddBlocksToPOI(grindstones, class_7477.field_39290);
        simpleAddBlocksToPOI(lectern, class_7477.field_39286);
        simpleAddBlocksToPOI(smithingTable, class_7477.field_39289);
        simpleAddBlocksToPOI(smoker, class_7477.field_39279);
    }

    // REGISTRY --------------------------------------------------------------------------------------------------------
    @Override
    @Environment(EnvType.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        /* REASON:
        apparently due to class verifier issues this is needed since it needs to check if that lambda actually implements that interface and to do so it needs to load the class
        now I have no clue why this isn't needed on the other modules (this is only fabric one so maybe that?)
        could it be that environment here strips stuff less that on common? or that all classes that use this rendered also happen to be de facto fabric classes
        ClientProxy.shutUpClassVerifier(event, chests.getTile(CompatChestBlockEntity.class), shortenedId());
        this is so dumb and IDK why it's needed. that class should never be loaded since it has environment annotation
        I tried everything, lambdas, double lambdas, anonymous classes...
        */
        CompatChestBlockRenderer.register(event, chests.getTile(CompatChestBlockEntity.class), shortenedId());
    }


    @Override
    // TEXTURES
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> {
            chests.blocks.forEach((wood, block) -> {
                // SINGLE
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/acacia_chest"),
                        EveryCompat.res("entity/vvb/oak_chest_m"),
                        EveryCompat.res("model/oak_chest_normal_o"),
                        null
                );
                // LEFT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/acacia_chest_left"),
                        EveryCompat.res("entity/vvb/oak_chest_left_m"),
                        EveryCompat.res("model/oak_chest_left_o"),
                        null
                );
                // RIGHT
                generateChestTexture(sink, manager, shortenedId(), wood, block,
                        modRes("entity/chest/acacia_chest_right"),
                        EveryCompat.res("entity/vvb/oak_chest_right_m"),
                        EveryCompat.res("model/oak_chest_right_o"),
                        null
                );

            });

        });
    }
    
}
